﻿/**
システム情報。

History:
	1.00β11:
		ﾈﾑぃへimport。
*/
module nemuxi.utility.simple.sysinfo;

debug import std.stdio: wl = writefln, pl = printf;
debug(sysinfo) void main() {}

import std.string;
import cpu=std.cpuid;
import dmd=std.compiler; // 実質そうだし。

import win32.windows;

import nemuxi.system.raii;
import nemuxi.negui.system.text;
//import nemuxi.system.text;
import nemuxi.utility.meta.memberproperty;

enum {
	SM_SERVERR2 = 89,
	VER_SUITE_WH_SERVER = 0x00008000,
}
final class SystemInfo: IInitialize {
	private {
		SYSTEM_INFO SysInfo;
		MEMORYSTATUS MemStatus;
		MEMORYSTATUSEX MemStatusEx;
		OSVERSIONINFOEX OSInfo;
	}

	void iniSystemInfo() {
		GetSystemInfo(&SysInfo);
	}
	version(X86_64) {
		// 多分…
		alias size_t SIZE_T;
	} else {
		alias ulong SIZE_T;
	}
	void initMemInfo() {
		MemStatus.dwLength = MemStatus.sizeof;
		GlobalMemoryStatus(&MemStatus);
		MemStatusEx.dwLength = MemStatusEx.sizeof;
		GlobalMemoryStatusEx(&MemStatusEx);
	}
	void initOSInfo() {
		OSInfo.dwOSVersionInfoSize = OSInfo.sizeof;
		GetVersionEx(cast(OSVERSIONINFO*)&OSInfo);
	}
	void initialize() {
		iniSystemInfo;
		initMemInfo;
		initOSInfo;
	}
	this() {
		initialize;
	}

	// メモリ --------------------------------

	mixin(StructGet!(size_t)("pageSize", q{SysInfo.dwPageSize}));
	
	mixin(StructGet!(ptrdiff_t)("minAddress", q{SysInfo.lpMinimumApplicationAddress}));
	mixin(StructGet!(ptrdiff_t)("maxAddress", q{SysInfo.lpMaximumApplicationAddress}));
	
	mixin(StructGet!(size_t)("minAllocation", q{SysInfo.dwAllocationGranularity}));

	mixin(StructGet!(size_t)("ramUsingPercent", q{MemStatusEx.dwMemoryLoad}));

	mixin(StructGet!(SIZE_T)("ramTotalSize", q{MemStatusEx.ullTotalPhys}));
	mixin(StructGet!(SIZE_T)("ramFreeSize",  q{MemStatusEx.ullAvailPhys}));
	mixin(StructGet!(SIZE_T)("ramUsingSize", q{ramTotalSize - ramFreeSize}));

	mixin(StructGet!(SIZE_T)("pageTotalSize", q{MemStatusEx.ullTotalPageFile}));
	mixin(StructGet!(SIZE_T)("pageFreeSize",  q{MemStatusEx.ullAvailPageFile}));
	mixin(StructGet!(SIZE_T)("pageUsingSize", q{pageTotalSize - pageFreeSize}));

	mixin(StructGet!(SIZE_T)("virtualTotalSize", q{MemStatusEx.ullTotalVirtual}));
	mixin(StructGet!(SIZE_T)("virtualFreeSize",  q{MemStatusEx.ullAvailVirtual}));
	mixin(StructGet!(SIZE_T)("virtualUsingSize", q{virtualTotalSize - virtualFreeSize}));
	mixin(StructGet!(SIZE_T)("virtualAvailExtended", q{MemStatusEx.ullAvailExtendedVirtual})); // 仮想メモリ拡張空き容量
	
	// OS ------------------------------------
	mixin(StructGetSet!(int)("majorVersion", q{OSInfo.dwMajorVersion}));
	mixin(StructGetSet!(int)("minorVersion", q{OSInfo.dwMinorVersion}));
	mixin(StructGetSet!(int)("buildNumber", q{OSInfo.dwBuildNumber}));
	mixin(StructGetSet!(int)("platformId", q{OSInfo.dwPlatformId}));
	Text servicePack() {
		return Text(OSInfo.szCSDVersion.ptr);
	}
	mixin(StructGetSet!(WORD)("servicePackMajor", q{OSInfo.wServicePackMajor}));
	mixin(StructGetSet!(WORD)("servicePackMinor", q{OSInfo.wServicePackMinor}));
	enum SUITES: WORD {
		SMALLBUSINESS            = VER_SUITE_SMALLBUSINESS            , /// Microsoft Small Business Serverがインストールされています。または、かつてインストーすれさていましたが、別のバージョンのWindowsにアップグレードされている可能性があります。
		ENTERPRISE               = VER_SUITE_ENTERPRISE               , /// Windows NT 4.0 Enterprise Edition、Windows 2000 Advanced Server、Windows Server 2003 Enterprise Edition、Windows Server 2008 Enterpriseのいずれかがインストールされています。
		BACKOFFICE               = VER_SUITE_BACKOFFICE               , /// Microsoft BackOfficeコンポーネントがインストールされています。
		TERMINAL                 = VER_SUITE_TERMINAL                 , /// ターミナルサービスがインストールされています。VER_SUITE_TERMINALがセットされていて、かつ、VER_SUITE_SINGLEUSERTSがセットされていない場合には、システムはアプリケーションサーバモードで動作しています。
		SMALLBUSINESS_RESTRICTED = VER_SUITE_SMALLBUSINESS_RESTRICTED , /// Microsoft Small Business Serverが制限クライアントライセンスでインストールされています。
		EMBEDDEDNT               = VER_SUITE_EMBEDDEDNT               , /// Windows XP Embeddedがインストールされています。
		DATACENTER               = VER_SUITE_DATACENTER               , /// Windows 2000 Datacenter Server、Windows Server 2003 Datacenter Edition、Windows Server 2008 Datacenterのいずれかがインストールされています。
		SINGLEUSERTS             = VER_SUITE_SINGLEUSERTS             , /// リモートデスクトップがサポートされていますが、1つの対話型セッションのみがサポートされています。この値はシステムがアプリケーションサーバモードで動作していない場合にはセットされません。
		PERSONAL                 = VER_SUITE_PERSONAL                 , /// Windows XP Home Edition、Windows Vista Home Basic、Windows Vista Home Premiumのいずれかがインストールされています。
		BLADE                    = VER_SUITE_BLADE                    , /// Windows Server 2003 Web Editionがインストールされています。
		STORAGE_SERVER           = VER_SUITE_STORAGE_SERVER           , /// Windows Storage Server 2003またはWindows Storage Server 2003 R2がインストールされています。
		COMPUTE_SERVER           = VER_SUITE_COMPUTE_SERVER           , /// Windows Server 2003 Compute Cluster Editionがインストールされています。
		WH_SERVER                = VER_SUITE_WH_SERVER                , /// Windows Home Serverがインストールされています。
	}
	mixin(StructGetSet!(SUITES)("suites", q{OSInfo.wSuiteMask}));

	//wProductType
	enum PRODUCTTYPE: BYTE {
		WORKSTATION       = VER_NT_WORKSTATION,       /// システムはWindows NT 4.0 Workstation、Windows 2000 Professional、Windows XP Home Edition、Windows XP Professional、Windows Vi
		DOMAIN_CONTROLLER = VER_NT_DOMAIN_CONTROLLER, /// システムはドメインコントローラです。
		SERVER            = VER_NT_SERVER,            /// システムはサーバです。ドメインコントローラでもあるサーバは、VER_NT_SERVERではなくVER_NT_DOMAIN_CONTROLLERとして報告されます。
	}
	mixin(StructGetSet!(PRODUCTTYPE)("productType", q{OSInfo.wProductType}));

	// CPU -----------------------------------
	
	bool slow() {
		return cast(bool)GetSystemMetrics(SM_SLOWMACHINE);
	}

	static string line(T)(string s, T val, bool NEWLINE=true) {
		return format("%s: %s", s, val, NEWLINE ? newline: "");
	}
	/**
	*/
	override string toString() {
		immutable os =["[OS]"] ~ toStringOS;
		immutable mem=["[MEMORY]"] ~ toStringMemory;
		immutable cpu=["[CPU]"] ~ toStringCPU;
		return join([
		os.join(newline),
		mem.join(newline),
		cpu.join(newline)
		], newline);
	}

	/**
	何でもいいからだれかmoduleくれ。
	*/
	string toStringOS() {
		
		immutable Major=majorVersion;
		immutable Minor=minorVersion;
		
		auto Version=format("%s.%s", Major, Minor);

		assert(Major >= 5, "2000以上のみってことで。むしろ2000も弾きたい");
		string Name;
		switch(Major) {
			case 5: // 2k, XP, 2003, 2003 R2
				switch(Minor) {
					case 0: // 2000
						Name = "2000";
						break;
					case 1: // XP
						Name = "XP";
						break;
					case 2: // 2003, 2003 R2
						Name = "2003";
						if(GetSystemMetrics(SM_SERVERR2)) {
							Name ~= " R2";
						}
						break;
					default:
						Name = "?-1";
				}
				break;
			
			case 6: // Vista ,Server 2008, Server 2008 R2, 7
				switch(Minor) {
					case 0: // Vista, Server 2008
						if(productType == PRODUCTTYPE.WORKSTATION) {
							Name = "Vista";
						} else {
							Name = "Server 2008";
						}
						break;
					case 1: // Server 2008 R2, 7
						if(productType == PRODUCTTYPE.WORKSTATION) {
							Name = "7";
						} else {
							Name = "Server 2008 R2";
						}
						break;
					default:
						Name = "?-2";
				}
				break;
			
			default: // 未来
				Name = "?-3";
		}

		//サービスパック
		string SP;
		if(servicePackMajor) {
			SP = format("%s.%s", servicePackMajor, servicePackMinor);
		} else {
			SP = "none";
		}
		
		return join([
			line("Window", Name),
			line("ServicePack", SP),
			line("BuildNumber", buildNumber),
			format("Suites: %08X", suites, newline),
			line("ProductType", productType, false)
		], null);
	}

	string toStringMemory() {
		return join([
			 format("%s: %08X / %08X", "Address,min-max",  minAddress, maxAddress)
			,line("MinAllocation",  minAllocation, false)
			,line("PageSize",       pageSize, false)
			,format("%s: %s / %s", "Page,use/all",  pageFreeSize, pageTotalSize)
			,format("%s: %s / %s", "Ram,use/all",  ramUsingSize,  ramTotalSize)
			,format("%s: %s / %s(%s)", "Virtual,use/all(ext)",  virtualUsingSize, virtualTotalSize, virtualAvailExtended)
		], newline);
	}

	/**
	CPU情報。

	std.spuid.toStringそのまんま使いたかったけど諸事情により自前で整形。

	Note:
		Intel/AMA両方の表示はやめたほうがいいのか？
	*/
	string toStringCPU() {
		string[] ss = [
			 line("Vendor",         cpu.vendor)
			,line("Processor",      cpu.processor)
			,line("MMX",            cpu.mmx)
			,line("FXSR",           cpu.fxsr)
			,line("SSE",            cpu.sse)
			,line("SSE2",           cpu.sse2)
			,line("SSE3",           cpu.sse3)
			,line("SSSE3",          cpu.ssse3)
			,line("AMD 3DNOW",      cpu.amd3dnow)
			,line("AMD 3DNOW Ext",  cpu.amd3dnowExt)
			,line("AMD MMX",        cpu.amdMmx)
			,line("IA64",           cpu.ia64)
			,line("AMD64",          cpu.amd64)
			,line("HyperThreading", cpu.hyperThreading)
			,line("Threads/CPU",    cpu.threadsPerCPU)
			,line("Core/CPU",       cpu.coresPerCPU)
			,line("INTEL",          cpu.intel)
			,line("AMD",            cpu.amd)
			,line("Stepping",       cpu.stepping)
			,line("Model",          cpu.model)
			,line("Family",         cpu.family)
			,line("Slow",           slow, false)
		];
		return join(ss, null);
	}
}

/**
システム情報の取得。
*/
string toStringInfo() {
	return join([
		(new SystemInfo).toString,
		"[COMPILER]",
		toStringCompiler,
		"[COMPILE]",
		toStringCompil
	], newline);
}
debug(sysinfo) unittest {
	wl("%s", toStringInfo);
}
/**
コンパイラ状態の取得。
*/
string toStringCompiler() {
	return join([
		SystemInfo.line("Compiler", dmd.name),
		SystemInfo.line("Version", format("%s.%03s", dmd.version_major, dmd.version_minor)),
		SystemInfo.line("Standards", dmd.D_major, false)
	], null);
}
/**
コンパイル状況の取得。
*/
string toStringCompil() {
	bool DebugVersion;
	debug {
		DebugVersion = true;
	}
	bool UnittestVersion;
	version(unittest) {
		UnittestVersion = true;
	}
	bool CoverageVersion;
	version(D_Coverage) {
		CoverageVersion = true;
	}
	bool ReleaseVersion = !DebugVersion && !UnittestVersion && !CoverageVersion;
	return join([
		SystemInfo.line("CompilTime", __TIMESTAMP__),
		SystemInfo.line("ReleaseVersion",  ReleaseVersion),
		SystemInfo.line("DebugVersion",    DebugVersion),
		SystemInfo.line("UnittestVersion", UnittestVersion),
		SystemInfo.line("CoverageVersion", CoverageVersion, false)
	], null);
}

