/**

*/
module nemuxi.utility.name;

debug import std.stdio: wl = writefln, pl = printf;
debug(name) void main() {}

import win32.windows;

import nemuxi.base;

typedef extern(Windows) BOOL function (LPWSTR, PDWORD) FuncType;
Text GetName(FuncType GetNameFunc, invariant size_t Length, lazy NemuxiException ex) {
	DWORD len=Length;
	auto name=new wchar[len];
	
	if(!GetNameFunc(name.ptr, &len)) {
		throw ex;
	}

	return Text(name.ptr);
}

/**
ユーザー名取得。

-------------------------------------------------------------------------------
assert(UserName() == EnvToPlain(Text("%USERNAME%")));
-------------------------------------------------------------------------------

Return:
	取得したユーザー名。

Exception:
	取得失敗時にNemuxiExceptionを投げる。
*/
Text UserName() {
	invariant UNLEN = 256;

	return GetName(
		cast(FuncType)&GetUserName,
		UNLEN,
		new NemuxiException("UserName:GetUserName", EC.NEMUXI_USERNAME)
	);
}

/**
コンピューター名取得。

-------------------------------------------------------------------------------
assert(ComputerName() == EnvToPlain(Text("%USERDOMAIN%")));
-------------------------------------------------------------------------------

Return:
	取得したコンピューター名。

Exception:
	取得失敗時にNemuxiExceptionを投げる。
*/
Text ComputerName() {
	invariant MAX_COMPUTERNAME_LENGTH = 256;
	
	return GetName(
		cast(FuncType)&GetComputerName,
		MAX_COMPUTERNAME_LENGTH,
		new NemuxiException("ComputerName:GetComputerName", EC.NEMUXI_PCNAME)
	);
}

debug(name) version(unittest) import nemuxi.utility.convert.env;
debug(name) unittest {
	assert(UserName() == EnvToPlain(Text("%USERNAME%")));
	assert(ComputerName() == EnvToPlain(Text("%USERDOMAIN%")));
}
