﻿/**
History:
	1.00β19:
		新規作成。
*/
module nemuxi.utility.mutex;

debug import std.stdio: wl = writefln, pl = printf;
debug(mutex) void main() {}

import win32.windows;

import nemuxi.base;

///
class MutexException: NemuxiException {
	mixin MixInNemuxiException;
}

class Mutex: HandleRaii {
	protected HANDLE hMutex;
	mixin KillResource!("ミューテックス", hMutex, CloseHandle, 0);
	
	this(in Text MutexName) {
		Err.init;
		auto mutex=CreateMutex(null, 0, MutexName.ptr);
		enforce(Err.code != ERROR_ALREADY_EXISTS, new MutexException(Text("%s[MutexName = %s]", Err.text.text8, MutexName.text8)));
		super(mutex, true);
	}
}

