﻿/**

*/
module nemuxi.utility.meta.memberproperty;

debug import std.stdio: wl = writefln, pl = printf;
debug(memberproperty) void main() {}

pure nothrow string ClassGet(T)(in string Method, in string Member, bool Override)
in {
	assert(Method.length);
	assert(Member.length);
}
body {
	return `

	` ~ (Override ? "override": "") ~ ` const  ` ~ (T).stringof ~ ` ` ~ Method ~ `() {
		return cast(` ~ (T).stringof ~ `)` ~ Member ~ `;
	}

	`;
}
pure nothrow string ClassSet(T)(in string Method, in string Member, bool Override)
in {
	assert(Method.length);
	assert(Member.length);
}
body {
	invariant Arg = Method ~ "Arg";
	
	return `

	` ~ (Override ? "override": "") ~ ` void ` ~ Method~ `(in ` ~ (T).stringof ~ ` ` ~ Arg ~ `) {
		` ~ Member ~ ` = cast(typeof(` ~ Member ~ `))` ~ Arg ~ `;
	}

	`;
}

pure nothrow string StructGet(T)(in string Method, in string Member) {
	return ClassGet!(T)(Method, Member, false);
}
pure nothrow string StructSet(T)(in string Method, in string Member) {
	return ClassSet!(T)(Method, Member, false);
}

pure nothrow string ClassGetSet(T)(in string Method, in string Member, bool Override) {
	return
	ClassGet!(T)(Method, Member, Override)
	~
	ClassSet!(T)(Method, Member, Override)
	;
}
///
pure nothrow string StructGetSet(T)(in string Method, in string Member) {
	/+
	invariant Type = T.stringof;
	invariant Arg = Method ~ "Arg";
	
	return
	Type ~ " " ~ Method ~ "() const {
		return cast(" ~ Type ~ ")" ~ Member ~ ";
	}
	void " ~ Method~ "(in " ~ Type ~ " " ~ Arg ~ ") {
		" ~ Member ~ " = cast(typeof(" ~ Member ~ "))" ~ Arg ~ ";
	}
	";
	+/
	/+
	return
	StructGet!(T)(Method, Member)
	~
	StructSet!(T)(Method, Member)
	;
	+/
	return ClassGetSet!(T)(Method, Member, false);
}

/**
History:
	1.00β15:
		[S] なんとなーくTをポインタの型じゃなくて元の型に変更。void*が微妙な記述になった。
*/
pure nothrow string SMixInStructHiddenOriginal(T)(in string Member)
in {
	assert(Member.length);
}
body {
	return `

	const ` ~ T.stringof ~ `* ptr() {
		return cast(` ~ T.stringof ~ `*)&` ~ Member ~ `;
	}

	const ` ~ T.stringof ~ `* opDot() {
		return cast(` ~ T.stringof ~ `*)&` ~ Member ~ `;
	}

	`;
}


