﻿/**
これなに？
*/
module nemuxi.utility.meta.basic;

debug import std.stdio: wl = writefln, pl = printf;
debug(basic) void main() {}

import std.string;
import std.metastrings;

/**
くっつけ。
*/
pure nothrow string join(T...)(in string sep, in T words)
in {
	assert(words.length);
}
body {
	string s;

	/+
	for(auto i=0; i < words.length; i++) {
		s ~= words[i] ~ sep;
	}
	+/
	foreach(word; words) {
		if(s.length) {
			s ~= sep;
		}
		s ~= word;
	}

	return s;
}
debug(basic) unittest {
	wl(join("","#"));
}


pure nothrow string[] splitlines(in string words)
in {
	assert(words.length);
}
out(r) {
	foreach(word; r) {
		foreach(c; word) {
			assert(c != '\r' && c != '\n');
		}
	}
}
body {
	string[] s;
	size_t head;
	
	for(auto i=0; i < words.length; i++) {
		if(head - i > 0 && (words[i] == '\r' || words[i] == '\n')) {
			s ~= words[head..i];
			head = i + 1;
			continue;
		} else if(words[i] == '\r' || words[i] == '\n') {
			head++;
		}
	}

	return s;
}

