/**
*/
module nemuxi.utility.controller;

debug import std.stdio: wl = writefln, pl = printf;
debug(controller) void main() {}

/// 開始・終了・実行中。
interface IController {
	/// 実行。
	bool start();
	/// 終了。
	bool stop();
	/// 実行中か
	const bool isRunning();
}

/**
ブロック内一時停止。

限定的な使用。
*/
scope final class Pause {
	private IController TargetController;

	/**
	一時停止を実行。

	Params:
		Controller = 一時停止させたいオブジェクト。
	*/
	this(IController Controller)
	in {
		assert(Controller);
	}
	body {
		TargetController = Controller;
		TargetController.stop();
	}

	/**
	一時停止状態から再開。
	*/
	~this() {
		TargetController.start();
	}
}






