﻿/**
テスト専用ダイアログ。
*/
module nemuxi.test.layoutdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(layoutdialog) void main() {}

import std.conv;

import win32.windows;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.image.font;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.combobox.combobox;

import nemuxi.negui.layout.layout;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.dual;

debug{} else {static assert(false, "debug only!");}
class LayoutDialog: ModalDialog {
	Font font;
	
	Push button;
	CheckBox check;
	ComboBox combo;
	Radio radio;
	Push[9] btns;
	CheckBox[2] chks;
	
	this(NeWindow Owner) {
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner   = Owner;

		super(&NeGuiInfo);

		size(500,300);
	}
	protected override {
		void OnCreate() {
			caption=true;
			haveSystemMenu=true;
			frameThick=true;
			
			font=GetSystemFont(SYSFONT.MESSAGE);

			//layoutManager=new LayoutManager(this);
			version(none) {
			auto tansu1=new Tansu(DIRECTION.VERTICAL);
			tansu1.sizeInfo.percent=10;
			tansu1.padding.right=1;
			tansu1.padding.left=1;
			
			layoutManager.basePanel = tansu1;
			
			auto tansu2=new Tansu(DIRECTION.HORIZON);
			tansu2.sizeInfo.percent=50;
			tansu2.margin.bottom = 5;
			tansu2.padding.right=1;
			tansu2.padding.left=1;
			layoutManager.basePanel += tansu2;
			
			foreach(i, ref btn; btns) {
				btn=new Push(this, cast(ITEM_ID)(i+1));
				btn.text=Text(i);
				layoutManager.basePanel += btn;
			}
			foreach(i, ref chk; chks) {
				chk=new CheckBox(this, cast(ITEM_ID)(i+1+btns.length));
				chk.text=Text(i);
				tansu2 += chk;
				chk.border = true;
			}
			}else version(all){
			auto line1=new Line(DIRECTION.HORIZON);
			layoutManager.basePanel = line1;
			button = new Push(this, 1);
			check  = new CheckBox(this, 2);
			check.border=1;
			combo  = new ComboBox(this, 3, ComboBox.TYPE.DROPEDIT);
			radio  = new Radio(this, 4);
			radio.border=1;
			line1 += button;
			line1 += null;
			line1 += check;
			line1 += combo;
			line1 += null;
			line1 += radio;
			line1.sizeInfo(0).absolute = 10;
			line1.sizeInfo(1).absolute = 10;
			line1.sizeInfo(2).absolute = -1;
			line1.sizeInfo(3).percent  = 20;
			line1.sizeInfo(4).absolute = 30;
			line1.sizeInfo(5).absolute = -1;

			auto line2=new Line(DIRECTION.VERTICAL);
			line2+=new Push(this, 100);
			line2+=new Push(this, 102);
			line2+=new Push(this, 104);
			line2.sizeInfo(0).percent = 40;
			line2.sizeInfo(1).percent = 40;
			line2.sizeInfo(2).absolute = -1;
				line2.margin.right=1;
				line2.padding.bottom=10;
			line1[4]=line2;
			} else {
			auto dual=new Dual(DIRECTION.HORIZON);
			layoutManager.basePanel = dual;
			button = new Push(this, 1);
			check  = new CheckBox(this, 2);
			//combo  = new ComboBox(this, 3, ComboBox.TYPE.DROPEDIT);
			check.border=1;
			dual[0] = check;
			dual[1] = button;
			dual.sizeInfo.absolute = 50;
			}
		}
	}
}

