﻿/**
テスト専用ダイアログ。
*/
module nemuxi.test.itemdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(itemdialog) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.image.font;
import nemuxi.negui.draw.imagelist;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.gui.control.combobox;
import nemuxi.gui.control.excombobox;
import nemuxi.gui.control.listview;
import nemuxi.negui.control.listbox.listview;
import nemuxi.negui.control.combobox.excombobox;
import nemuxi.file.items.item;
import nemuxi.file.items.items;
import nemuxi.gui.control.listview;
import nemuxi.gui.control.iteminput;
import nemuxi.gui.control.editbox;


debug{} else {static assert(false, "debug only!");}
class ItemDialog: ModalDialog {
	enum CTRL: ITEM_ID {
		ITEM
	}
	Font font;
	ItemComboBox ecb;
	ItemListView lis;
			ItemIconPairs iip;
	ImageList il;
	this(NeWindow Owner) {
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner   = Owner;

		super(&NeGuiInfo);

		size(500,300);
	}
	protected override {
		void OnDestroy() {
			delete font;
			super.OnDestroy();
		}
		void OnCreate() {
			caption=true;
			haveSystemMenu=true;
			frameThick=true;
			
			font=GetSystemFont(SYSFONT.MESSAGE);

			auto a=MakeApplication();

			iip=new ItemIconPairs(a.itemBase, ICONSIZE.SMALL);
			
			ecb = new ItemComboBox(this, 100);
			ecb.font=font;
			ecb.iiPairs = iip;
			ecb.move(10,10,200,200);

			lis = new ItemListView(this, 200);
			lis.font=font;
			lis.iiPairs = iip;
			lis.move(10,50,200,200);

			//lis.select(1, true);
			//lis.select(-1, false);
			//SetWindowPos(ecb(),NULL,20,20,250,1200,SWP_NOACTIVATE);
			ecb.select=-1;
		}
		

		int OnNotify(ITEM_ID ItemID, NOTIFY* Notify) {
			if(ItemID == 200) {
				assert(Notify.sender is lis);
				switch(Notify.code) {
					case ListView.EVENT.ITEMCHANGED:
						auto Lv = cast(LISTVIEWMESSAGE*)Notify;
					if(auto p=(cast(size_t)Lv.data in iip)) {
						
						ecb.selectValue(p);
					}
						break;
					default:
				}
			} else if(ItemID == 100) {
				switch(Notify.code) {
					case ExComboBox.EVENT.ENDEDIT:
						break;
					default:
				}
			}
			return 0;
		}
		
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui gui) {
			if(Id == 100) switch(MessageType) {
				case ComboBox.EVENT.LISTCHANGE:
				//wl("%s", gui.text.toString);
				default:
					break;
			}
			return false;
		}
		
		bool OnMouseRightDown(MOUSE_KEY Keys, int x, int y) {
			wl("%s",ecb.text.toString);
			
			return false;
		}
	}
}
