﻿/**
History:
	1.00β19:
		新規作成。
*/
module nemuxi.system.exception;

debug import std.stdio: wl = writefln, pl = printf;
//debug(exception) void main() {}

public import nemuxi.negui.system.text;
public import nemuxi.negui.system.timer;
public import nemuxi.negui.system.exception;

/**
あんまし継承関係にないんだけどこの逆よりかはマシ。
*/
class NemuxiException: NeGuiException {
	enum CODE: EX_CODE {
		NONE = EX_CODE.max / 2 + 1,

		NEMUXI_MYPATH,
		NEMUXI_USERNAME,
		NEMUXI_PCNAME,
		
		PROCCESS,
		PROCCESS_CREATE,
		FILE,
		FILE_EXECUTE_PATH,
		FILE_EXECUTE_FOLDER,
		FILE_EXECUTE_PROPERTY,

		ITEM_DATE_LENGTH,
		ITEM_DATE_SPLIT,
		ITEM_DATE,
		ITEM_DATE_INFO,

	}
	unittest {
		static assert(CODE.max >= EX_CODE.max / 2 + 1);
	}
	
	this(in Text msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, cast(NGEC)code, next, file, line);
	}
	this(string msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this(msg.toText, code, next, file, line);
	}
	this(Object msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this(msg ? msg.toString(): "*Object is null", code, next, file, line);
	}
}
///
alias NemuxiException.CODE EC;

template MixInNemuxiException() {
	override this(in Text msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, code, next, file, line);
	}
	override this(string msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, code, next, file, line);
	}
	override this(Object msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, code, next, file, line);
	}
}

__EOF__;

///
class Exception: NeGuiException {
	mixin MixInNeGuiException;
}

///
class Exception: NemuxiException {
	mixin MixInNemuxiException;
}





