﻿/**
Windowsエラー

とりあえずErr構造体が何とかしてくれる。

Bugs:
	NeGuiに統合すべき。
*/
module nemuxi.system.err;

debug(err) void main() {}

import std.windows.syserror;

import win32.windows;

//import nemuxi.base;
//import nemuxi.system.text;
import nemuxi.negui.system.text;

/// エラー表示のためのnamespaceっぽいの。
static struct Err {
static:
	/// エラーコード設定。
	void code(DWORD ErrCode) {
		SetLastError(ErrCode);
	}
	/// エラーコード初期化。
	void init() {
		code(NO_ERROR);
	}
	/// エラーコード取得。
	DWORD code() {
		return GetLastError();
	}
	/// エラー文字列を取得。
	Text text() {
		return Text(toString);
	}
	/// ditto
	string toString() {
		auto s=sysErrorString(code);
		return s;
	}
	/// エラー文字列を表示。
	void show() {
		MessageBox(
			null,
			text.ptr,
			null,
			MB_OK
			| MB_ICONINFORMATION
			| MB_DEFBUTTON1
			| MB_SETFOREGROUND
			| MB_TOPMOST
		);
	}

	string codeToString(DWORD ErrCode) {
		return sysErrorString(ErrCode);
	}
}

debug import std.string;
debug void Msg(T)(T msg) {
	MessageBox(
		null,
		Text(msg).ptr,
		null,
		MB_OK
		| MB_ICONINFORMATION
		| MB_DEFBUTTON1
		| MB_SETFOREGROUND
		| MB_TOPMOST
	);
	}

