﻿/**
ﾈﾑぃ

Authors:
	sk

License:
	NYSL, NYSDL

Version:
	History参照。

Date:
	History参照。

Bugs:
	ごちゃごちゃ触りまくったら単独コンパイルできなくなった子がちらほら。

History:
	<ul>
		<li>機能追加/実装/変更/停止/廃止: [F]eatures</li>
		<li>バグ修正: [B]ug</li>
		<li>プログラム的な変更(なんだこれ): [P]rogram</li>
		<li>ソース上の変更: [S]ource</li>
		<li>↑以外のこと: [@]</li>
	</ul>

	1.00β19, 2009/10/03:
		[F] 設定値がシステムのもの(初期値)と同等であれば値をそのまま保存しないように変更。
		[B] (debug)本体設定→ボタン型の「リスト表示」が原因で設定後にAssertion failureで落ちる設計ミスの修正。
		[F] 本体設定→コマンド型のフォント選択画面で水平方向のフォントのみ選択可能に変更。
		[F] 文字列リソースの暫定外部化、目に見える範囲のみ。
		[F] 「指定して実行」ダイアログの横幅を若干拡張。
		[F] 「エラー発生」ダイアログのサイズを拡張。
		[S] NeGuiとNemuxiの若干の切り離し。無くそう癒着。
		[F] 癒着をなくそうとしたら例外のコード値が面白いことになった。
		[F] 二重起動の禁止フラグを追加。
		[B] 選択中のメイングループに無効なサブグループが選択可能で選択すると落ちるバグの修正。

	1.00β18, 2009/09/23:
		[B] mainが公開版なのにversion(none)だったのを修正。
		[F] 「指定して実行」のダイアログがD&Dに対応。
		[P] UIを強化。nemuxi.negui.layout.*が色々と。
		[B] 設定ダイアログで項目移動時にコンボボックスやリストビューで選択されているアイテムが変更される不具合の修正。
		[B] フォルダオープンアイテムが無効な場合にUI及びプログラムが異常なことになる不具合の修正。
		[B] コマンド入力ダイアログのリストをマウス選択できなかった不具合の修正。
		[F] コマンド入力ダイアログに「消滅時間」の反映。
		[B] 設定画面のアイコンを解放出来ていなかったバグの修正(まだちょっと怪しい)。
		[@] 1.00β13未満のHistory(nemuxi.nemuxiのみ)にも印付け。

	1.00β17, 2009/09/21:
		[@] Hooker.dll差し替え(1.010 -> 1.100)
		[F] コマンド型をとりあえずの実装、「消滅時間」未実装。
		[B] ホットキー登録の登録時の不具合を修正。
		[P] アイテムIDの使用不可文字追加。
		[B] 何かがバグってた。
		[P] プラグイン仕様の変更。
		[B] アイテム一覧表示で使用されたアイコンを解放していないバグの修正。
		[B] アイテム設定時にアイテム未登録状態で複数アイテムにアイテムタイプを変更した際に落ちていたバグを修正。
	
	1.00β16, 2009/09/12:
		[@] Hooker.dll差し替え(1.000 -> 1.010)
		[S] ソースコードの整理。
		[B] アイテム描画用イメージリストを解放していなかったバグを修正。
		[B] Hooker.dllの解放処理が怪しかったので差し替え。
	
	1.00β15, 2008/09/09:
		[S] nemuxi.file.items.groupのText置き換え作業によりメソッド等変更。影響packageへのHistory記述無し。
		[S] Textへの置き換え運動は多分終了。
		[P] グループ設定のUI変更。
		[P] 設定部分のキーボードアクセラレータ使用準備。
		[P] アイテム設定のダイアログ表示に初期値を設定。
		[P] アイテム選択時にアイコンを表示するように変更。
	
	1.00β14, 2008/09/01:
		[F] アイテム設定時にアドレスが環境変数を含んでいる場合に登録できない不具合を修正。
		[F] グループ設定の項目ダブルクリックを無視するように修正。
		[P] アイテム設定時にD&Dした時の挙動を変更。ポインタがアイテムリストの上にあれば新規作成、なければ通常の設定。
		[B] アイテムの作業フォルダに環境変数が含まれていた場合にそのアイテムを実行できないバグを修正。
		[S] 大部分のstringからTextへの置き換え運動開始。修正箇所が多いので該当部分へのHistory記述無し。diffでもしてくれ。
	
	1.00β13, 2009/08/29:
		[@] 今バージョンからHistoryに修正箇所の目印を追加するように心に決めた。
		[F] アイテム設定においてショートカットファイル(*.lnk)に対応。
		[P] D&D処理を一部実装。
		[P] バージョン情報ダイアログにユーザー環境ではなく作者の環境を表示するように変更。
		[S] Historyがあまりにも残念だったのを修正。

	1.00β12, 2009/08/27:
		[P] 設定画面における「OK」と「CANCEL」の位置を入れ替え。
		[B] メインウィンドウがバー状態でもタイトルバーD&Dによる移動が許可されていたバグの修正。
		[F] メインウィンドウがバー状態の際に特定方向のみへサイズ変更するようにヒットテスト修正。
		[F] アイテムの設定で「アドレスに合わせる」を実装。

	1.00β11, 2009/08/24:
		[B] アイコン取得時にアドレスがDLLだった場合にアイコンインデックスが無視される不具合を修正。
		[F] アイコン入力欄を入力可能に変更。
		[B] アイテムメニューにおいて拡張子無しのファイル(と.無しフォルダ)が存在する場合に落ちるバグを修正。
		[F] バージョン情報ダイアログ暫定実装。
		[B] フォルダオープン時にエクスプローラ表示が無視されていた不具合を修正。
	
	1.00β10, 2009/08/19:
		[@] 公開。

*/
module nemuxi.nemuxi;

version(build) {
	pragma(build_def, "EXETYPE NT");
	pragma(build_def, "SUBSYSTEM WINDOWS,5.0");
}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;
import nemuxi.negui.window.dialog.system;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.utility.mutex;

/**

Bugs:
	WinMainに変えなきゃいかんはず。

History:
	1.00β19:
		[P] 実行前に少し処理追加。

	1.00β17:
		[S] 試験的なことする時用にコード分離。
	
	1.00β12:
		設定ファイルの書き込みタイミングを変更。

	1.00β11:
		例外catchの悪足掻きを追加。
*/
int main(string[] args) {
	//Logger.flag=true;
	version(all) {
		Logger.flag=StaticData.logEnable;
		
		try {
			scope Mutex mutex;
			//前検査
			try {
				if(StaticData.mutex) {
					mutex = new Mutex(StaticData.mutexName);
				}
			} catch(Exception e) {
				throw new NemuxiException("前検査", EC.NONE, e);
			}
			scope(success) delete mutex;

			//実行
			
			Logger.write("Nemuxi Start ->");
			
			auto hWnd=new NemuxiWindow(MakeApplication());
			
			try {
				scope(success) {
					SaveApplication(hWnd.application);
				}
				Logger.write("args -> %s", args);
				hWnd.dataLoad;
				return hWnd.execute();
			} catch(NemuxiException e) {
				Logger.write(e);
				ShowExceptionDialog(hWnd, e);
				return e.code;
			}
		} catch (Throwable e) {
			Logger.write(e);
			ShowExceptionDialog(null, e);
			debug wl("%s", e);
			return -1;
		} catch(Object o) {
			Logger.write(o);
			MessageDialog.show(o.toString.toText);
			debug wl("%s", o);
			return -2;
		} finally {
			Logger.write("<- Nemuxi End.");
		}
		
	} else {
		debug {
			auto hWnd=new NemuxiWindow(MakeApplication());
			scope(success) {
				SaveApplication(hWnd.application);
			}
			Logger.write("args -> %s", args);
			hWnd.dataLoad;
			return hWnd.execute();
		} else {
			static assert(false, "ON -release!");
		}
	}
}

