﻿/**

*/
module nemuxi.negui.window.window;

debug import std.stdio: wl = writefln, pl = printf;
debug(window) void main() {}

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.negui;
import nemuxi.negui.window.menu.menu;

///
class WindowException: NeGuiException {
	mixin MixInNeGuiException;
}

///
class Window: NeGui {
	///
	protected alias NeGui.hItem hWnd;

	protected override this(HWND hWnd) {
		super(hWnd);
	}

	protected this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Window    = true;
		
		NeGuiInfo.ExStyle   |= WS_EX_CONTROLPARENT;
		NeGuiInfo.Style     |= WS_POPUP | WS_CLIPCHILDREN;
		super(NeGuiInfo);
	}
	
	mixin(ItemExStyleGetSetMixStr("contextHelp", q{WS_EX_CONTEXTHELP}));
	mixin(ItemExStyleGetSetMixStr("taskBar", q{WS_EX_APPWINDOW}));
	mixin(ItemExStyleGetSetMixStr("tab", q{WS_EX_CONTROLPARENT}, false));
	
	mixin(ItemStyleGetSetMixStr("caption", q{WS_CAPTION}));
	mixin(ItemStyleGetSetMixStr("clipChildren", q{WS_CLIPCHILDREN}));
	mixin(ItemStyleGetSetMixStr("haveSystemMenu", q{WS_SYSMENU}));

	mixin(ItemStyleGetSetMixStr("frameDialog", q{WS_DLGFRAME}));
	mixin(ItemStyleGetSetMixStr("frameThick", q{WS_THICKFRAME}));
	mixin(ItemStyleGetSetMixStr("frameSize", q{WS_SIZEBOX}));
	
	mixin(ItemStyleGetSetMixStr("maxButton", q{WS_MAXIMIZEBOX}));
	mixin(ItemStyleGetSetMixStr("minButton", q{WS_MINIMIZEBOX}));
	

	const bool isSmall() {
		return cast(bool)IsIconic(hWnd);
	}
	bool openSmall() {
		return cast(bool)OpenIcon(hWnd);
	}
	bool toSmall() {
		return cast(bool)CloseWindow(hWnd);
	}
	
	const bool isZoom() {
		return cast(bool)IsZoomed(hWnd);
	}
	
	const bool isVisible() {
		return cast(bool)IsWindowVisible(hWnd);
	}
	Window toActive() {
		auto hOldActiveWnd=SetActiveWindow(hWnd);
		if(auto OldGui=NeGui.getGuiObject(hOldActiveWnd)) {
			return cast(Window)OldGui;
		} else {
			return new OtherWindow(hOldActiveWnd);
		}
	}
	

	static enum CENTER {
		DESKTOP,
		WORKAREA,
		WINDOW
	}
	bool toCenter(CENTER Center, NeGui OwnerWindow=null)
	in {
		if(Center == CENTER.WINDOW) {
			assert(OwnerWindow.alive);
		}
	}
	body {
		auto WindowRect=itemRect();
		
		with(CENTER) switch(Center) {
			case DESKTOP: {
				RECT DeskTop=void;
				GetWindowRect(GetDesktopWindow(), &DeskTop);
				return super.move(
					DeskTop.right  / 2 - (WindowRect.right  - WindowRect.left) / 2,
					DeskTop.bottom / 2 - (WindowRect.bottom - WindowRect.top)  / 2,
					WindowRect.right  - WindowRect.left,
					WindowRect.bottom - WindowRect.top,
					true
				);
			}
			// あわせねば
			case WORKAREA: {
				RECT WorkArea=void;
				SystemParametersInfo(SPI_GETWORKAREA, 0, &WorkArea, 0);
				return super.move(
					WorkArea.left + (WorkArea.right  - WorkArea.left) / 2 - (WindowRect.right  - WindowRect.left) / 2,
					WorkArea.top  + (WorkArea.bottom - WorkArea.top)  / 2 - (WindowRect.bottom - WindowRect.top)  / 2,
					WindowRect.right  - WindowRect.left,
					WindowRect.bottom - WindowRect.top,
					true
				);
			}
			case WINDOW: {
				auto OwnerRect=OwnerWindow.itemRect();
				
				return super.move(
					OwnerRect.left + (OwnerRect.right  - OwnerRect.left) / 2 - (WindowRect.right  - WindowRect.left) / 2,
					OwnerRect.top  + (OwnerRect.bottom - OwnerRect.top)  / 2 - (WindowRect.bottom - WindowRect.top)  / 2,
					WindowRect.right  - WindowRect.left,
					WindowRect.bottom - WindowRect.top,
					true
				);
			}
			default:
				assert(false);
		}
	}
	/**
	クライアント領域を指定サイズに変更。

	Params:
		Width = 横幅。
		Hwight = 縦幅。

	Return:
		最終的なサイズ変更が成功すればtrue、失敗すればfalse。

	Exception:
		初っ端から失敗すればWindowException。
	*/
	bool adjustSize(in int Width, in int Height) {
		RECT Rect;
		Rect.right  = Width;
		Rect.bottom = Height;
		if(
			AdjustWindowRectEx(
				&Rect,
				this.getItemInfo(GWL.STYLE),
				GetMenu(hItem) ? true: false,
				this.getItemInfo(GWL.EXSTYLE)
			)
		) {
			auto ItemRect=itemRect();
			return this.move(
				ItemRect.left, ItemRect.top,
				Rect.right - Rect.left, Rect.bottom - Rect.top,
				true
			);
		}
		
		throw new WindowException(Text("AdjustWindowRectEx"));
	}
	bool adjustSize(SIZE* Size) {
		return adjustSize(Size.cx, Size.cy);
	}

	static Window find(in Text ClassName, in Text TitleName) {
		wchar* pTitle  = TitleName.length ? TitleName.ptr: null;
	
		if(auto hWnd=FindWindow(ClassName.ptr, pTitle)) {
			if(auto gui=cast(Window)NeGui.getGuiObject(hWnd)) {
				return gui;
			} else {
				return new OtherWindow(hWnd);
			}
		} else {
			return null;
		}
	}
	static Window find(in Text ClassName) {
		return Window.find(ClassName, Text.emptyText);
	}
}

/***/
final class OtherWindow: Window {
	this(HWND hWnd) {
		super(hWnd);
	}
}

Window GetParentWindow(NeGui base) {
	auto gui=base;
	
	while(!cast(Window)gui.parent) {
		gui = gui.parent;
	}

	return cast(Window)gui.parent;
}

