﻿/**

*/
module nemuxi.negui.window.newindow;

debug import std.stdio: wl = writefln, pl = printf;
debug(newindow) void main() {}

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.window.window;
public import nemuxi.negui.dropfile;
public import nemuxi.negui.layout.layout;
import nemuxi.negui.window.dialog.dialog;
public import nemuxi.negui.keyboard.accelerator;

///
class NeWindowException: WindowException {
	mixin MixInNeGuiException;
}

private immutable NEGUICLASS = "NeGuiWindow"w;
static this() {
	WNDCLASSEX WndClass;

	with(WndClass) {
		cbSize          = WndClass.sizeof;
		style           = CS_HREDRAW | CS_SAVEBITS | CS_VREDRAW;
		lpfnWndProc     = &NeWindow.NeGuiEventProc;
		cbClsExtra      = 0;
		//cbWndExtra      = DLGWINDOWEXTRA;
		hInstance       = GetModuleHandle(null);
		hIcon = hIconSm = LoadIcon(hInstance, IDI_APPLICATION);
		hCursor         = LoadCursor(NULL, IDC_ARROW);
		hbrBackground   = cast(HBRUSH)COLOR_BTNFACE+1;
		lpszMenuName    = null;
		lpszClassName   = NEGUICLASS.ptr;
	}
	if(!RegisterClassEx(&WndClass)) {
		throw new NeWindowException(Text("ウィンドウクラス登録失敗, %s", Err.text));
	}
}



///
abstract class NeWindow: Window {
	protected override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = NEGUICLASS;
		super(NeGuiInfo);
	}

	mixin NeGuiDestructor;

	mixin NeGuiEvent;

	mixin MixInNeGuiEventProc!(NeWindow);
}


