﻿/**
ポップアップメニュー。


*/
module nemuxi.negui.window.menu.popup;

debug import std.stdio: wl = writefln, pl = printf;

debug(popup) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.draw.cursor;
public import nemuxi.negui.window.menu.menu;
import nemuxi.negui.negui;
public import nemuxi.negui.control.control;

enum {
	TPM_HORNEGANIMATION = 0x800,
	TPM_HORPOSANIMATION = 0x400,
	TPM_VERPOSANIMATION = 0x1000L,
	TPM_NOANIMATION     = 0x4000L,
	TPM_VERNEGANIMATION = 0x2000,
}

/// ポップアップメニュークラス。
class PopUp: Menu {
	/**
	コンストラクタ。

	CreatePopupMenuで生成されたメニューハンドルをラップ。

	Exception:
		ポップアップメニュー作成に失敗した場合はNemuxiExceptionを投げる。
	*/
	this() {
		auto hMenu=CreatePopupMenu();
		
		if(!hMenu) {
			throw new NemuxiException("メニュー作成に失敗");
		}
		super(hMenu, true);
	}

	/// ポップアップ表示フラグ。
	static enum FLAGS {
		BOTTOMALIGN  = TPM_BOTTOMALIGN  , /// メニューの下端を、y パラメータの位置に合わせます。 
		CENTERALIGN  = TPM_CENTERALIGN  , /// メニューの水平方向の中心を、x パラメータの位置に合わせます。 
		LEFTALIGN    = TPM_LEFTALIGN    , /// メニューの左端を、x パラメータの位置に合わせます。 
		LEFTBUTTON   = TPM_LEFTBUTTON   , /// マウスの左ボタンをトラックします、 
		NONOTIFY     = TPM_NONOTIFY     , /// 通知メッセージを送らないようにします。 
		RETURNCMD    = TPM_RETURNCMD    , /// 関数の戻り値に、ユーザーがクリックしたメニュー項目のIDがセットされます。 
		RIGHTALIGN   = TPM_RIGHTALIGN   , /// メニューの右端を、x パラメータの位置に合わせます。 
		RIGHTBUTTON  = TPM_RIGHTBUTTON  , /// マウスの右ボタンをトラックします。 
		TOPALIGN     = TPM_TOPALIGN     , /// メニューの上端を、y パラメータの位置に合わせます。 
		VCENTERALIGN = TPM_VCENTERALIGN , /// メニューの垂直方向の中心を、y パラメータの位置に合わせます。

		//Windows 98 と Windows 2000：
		HORNEGANIMATION = TPM_HORNEGANIMATION , /// 左から右へ向かってメニューのアニメーション表示を行います。
		HORPOSANIMATION = TPM_HORPOSANIMATION , /// 右から左へ向かってメニューのアニメーション表示を行います。
		NOANIMATION     = TPM_NOANIMATION     , /// アニメーションなしでメニューを表示します。
		VERNEGANIMATION = TPM_VERNEGANIMATION , /// 下から上へ向かってメニューのアニメーション表示を行います。
		VERPOSANIMATION = TPM_VERPOSANIMATION , /// 上から下へ向かってメニューのアニメーション表示を行います。
		RECURSE         = TPM_RECURSE         , /// メニュー内で、特定のメニュー項目に関するチップヘルプの表示を有効にします。
	}
	alias FLAGS TPM;
	/**
	ポップアップ表示。

	Params:
		Flags = ポップアップ表示フラグ。

		Point = 表示座標。

		hWnd = 表示する際の親ウィンドウ。

		Rect = 未だにコレの使い方が分からん。

	Return:
		TPM.RETURNCMDが使用されていた場合は選択されたメニューID。
		それ以外は知らん。
	*/
	COMMAND_ID show(in NeGui Owner, FLAGS Flags, ref const(POINT) Point, in RECT* Rect=null) {
		TPMPARAMS TpmParams=void;
		if(Rect) {
			TpmParams.cbSize    = TpmParams.sizeof;
			TpmParams.rcExclude = *Rect;
		}
		return cast(COMMAND_ID)TrackPopupMenuEx(
			hMenu,
			Flags,
			Point.x,
			Point.y,
			Owner(),
			Rect ? &TpmParams: null
		);
	}
	COMMAND_ID show(in NeGui Owner, FLAGS Flags, in RECT* Rect=null) {
		auto Point=Cursor.getPos();

		return show(Owner, Flags, Point, Rect);
	}

	enum ATTACH {
		RIGHT,
		BOTTOM,
	}
	enum MESSAGE: FLAGS {
		OWNER  = cast(FLAGS)0,
		NONE   = FLAGS.NONOTIFY,
		RETURN = FLAGS.RETURNCMD,
	}
	COMMAND_ID attach(in NeGui Owner, in NeGui Target, ATTACH Attach, MESSAGE Message) {
		FLAGS Flags=FLAGS.LEFTALIGN | FLAGS.TOPALIGN | FLAGS.LEFTBUTTON | FLAGS.RIGHTBUTTON | Message;

		POINT Point=void;
		auto Rect=Target.itemRect();

		switch(Attach) {
			case ATTACH.RIGHT:
				Point.x = Rect.right+1;
				Point.y = Rect.top;
				break;
			case ATTACH.BOTTOM:
				Point.x = Rect.left;
				Point.y = Rect.bottom+1;
				break;
			default:
				assert(false);
		}
		
		return show(Owner, Flags, Point, &Rect);
	}
}



