﻿/**

*/
module nemuxi.negui.window.mainwindow;

debug import std.stdio: wl = writefln, pl = printf;
debug(mainwindow) void main() {}

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.window.newindow;
public import nemuxi.negui.window.dialog.dialog;

/**
History:
	1.00β18:
		[S] Oneの扱いを微妙に変更。
*/
class MainWindow: NeWindow {
	invariant() {
		debug assert(One == 1);
	}
	debug static int One=0;
	this(GUIINFO* NeGuiInfo) {
		debug One+=1;
		//NeGuiInfo.Window    = true;
		super(NeGuiInfo);
	}
	
	private mixin Message;
	
	INT execute() {
		return loop();
	}

	protected override void OnDestroy() {
		super.OnDestroy();
		PostQuitMessage(0);
	}

	private {
		struct WINDOWDATA {
			Window[] windows;
			MainWindow me;
			DWORD ProccessID;
		}
		static extern(Windows) BOOL EnumWindowsProc(HWND hWnd , LPARAM lParam) {
			auto WindowData=cast(WINDOWDATA*)lParam;
			
			DWORD ProccessID;
			GetWindowThreadProcessId(hWnd, &ProccessID);
			if(WindowData.ProccessID != ProccessID) {
				return TRUE;
			} else if((new OtherWindow(hWnd)).className != WindowData.me.className) {
				return TRUE;
			}
			if(auto window=cast(Window)NeGui.getGuiObject(hWnd)) {
				if(window == WindowData.me) {
					return TRUE;
				}
				WindowData.windows ~= window;
			}
			
			return TRUE;
		}
	}
	/**
	History:
		1.00β18:
			新規追加。
	*/
	public class MyChildren {
		Window[] windows;
		this(Window[] windows) {
			this.windows = windows;
		}
		~this() {
			delete windows;
			delete values;
		}
		enum MODE {
			ENABLE
		}
		private {
			bool[] values;
			MODE Mode;
		}
		void lock(MODE Mode) {
			this.Mode = Mode;
			final switch(Mode) {
				case MODE.ENABLE:
					values = new bool[windows.length];
					for(auto i=0; i < windows.length; i++) {
						values[i] = windows[i].enable;
						windows[i].enable =false;;
					}
					break;
			}
		}
		void release() {
			final switch(Mode) {
				case MODE.ENABLE:
					for(auto i=0; i < windows.length; i++) {
						if(windows[i].alive) {
							windows[i].enable = values[i];
						}
					}
					break;
			}
		}
	}
	/**
	History:
		1.00β18:
			[P] 戻り値の型変更。

		1.00β17:
			新規追加。
	*/
	final MyChildren getNeGuiWindow() {
		WINDOWDATA WindowData;
		WindowData.me = this;
		GetWindowThreadProcessId(hWnd, &WindowData.ProccessID);
		EnumWindows(&EnumWindowsProc, cast(LPARAM)&WindowData);

		return new MyChildren(WindowData.windows);
	}
}



