﻿/**
やっつけ！
*/
module nemuxi.negui.window.hook;

debug import std.stdio: wl = writefln, pl = printf;

debug(hook) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.utility.controller;

/+
abstract class Hook: Raii, IController {
	protected HHOOK hHook;
	mixin KillResource!("フック", hHook, UnhookWindowsHookEx, 0);

	static enum TYPE {
		MIN             = WH_MIN,
		MSGFILTER       = WH_MSGFILTER,
		JOURNALRECORD   = WH_JOURNALRECORD,
		JOURNALPLAYBACK = WH_JOURNALPLAYBACK,
		KEYBOARD        = WH_KEYBOARD,
		GETMESSAGE      = WH_GETMESSAGE,
		CALLWNDPROC     = WH_CALLWNDPROC,
		CBT             = WH_CBT,
		SYSMSGFILTER    = WH_SYSMSGFILTER,
		MOUSE           = WH_MOUSE,
		HARDWARE        = WH_HARDWARE,
		DEBUG           = WH_DEBUG,
		SHELL           = WH_SHELL,
		FOREGROUNDIDLE  = WH_FOREGROUNDIDLE,
		CALLWNDPROCRET  = WH_CALLWNDPROCRET,
		KEYBOARD_LL     = WH_KEYBOARD_LL,
		MOUSE_LL        = WH_MOUSE_LL,
		MAX             = WH_MAX,
		MINHOOK         = WH_MINHOOK,
		MAXHOOK         = WH_MAXHOOK,
	}
	protected {
		TYPE Type;
		HOOKPROC HookProc;
		HMODULE hModule;
		DWORD ThreadID;
	}
	this(TYPE Type, HOOKPROC HookProc, HMODULE hModule, DWORD ThreadID) {
		this.Type     = Type;
		this.HookProc = HookProc;
		this.hModule  = hModule;
		this.ThreadID = ThreadID;

		start();
	}

	override bool start() {
		hHook = SetWindowsHookEx(
			Type,
			HookProc,
			hModule,
			ThreadID
		);
		return hHook
			? true
			: false
		;
	}
	override bool stop() {
		return kill();
	}
	override const bool isRunning() {
		return hHook
			? true
			: false
		;
	}

	HHOOK opCall() {
		return hHook;
	}

	static enum CODE {
		ACTION      = HC_ACTION,
		GETNEXT     = HC_GETNEXT,
		SKIP        = HC_SKIP,
		NOREMOVE    = HC_NOREMOVE,
		NOREM       = HC_NOREM,
		SYSMODALON  = HC_SYSMODALON,
		SYSMODALOFF = HC_SYSMODALOFF,
	}
	LRESULT callNext(CODE Code, WPARAM wParam, LPARAM lParam) {
		return CallNextHookEx(hHook, Code, wParam, lParam);
	}
	
}

/+
/**
フックの一時停止。

Hook.stop(), Hook.start()の糖衣クラス。
*/
scope class Pause {
	private Hook TargetHook;
	/**
	一時停止。

	Params:
		hook = 一時停止させたいフック。
	*/
	this(Hook hook)
	in {
		assert(hook);
	}
	body {
		TargetHook = hook;
		TargetHook.stop();
	}
	~this() {
		TargetHook.start();
	}
}
+/

class KeyBorad: Hook {
	this(HOOKPROC HookProc, HMODULE hModule=GetModuleHandle(null)) {
		super(TYPE.KEYBOARD, HookProc, hModule, 0);
		super.Suicide = true;
	}
}
+/
