﻿/**
タスクトレイ関連。

packageどこにしたらいいのか。
*/
module nemuxi.negui.tasktray;

debug import std.stdio: wl = writefln, pl = printf;

debug(tasktray) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.image.icon;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
import nemuxi.system.raii;

///
class TaskTrayException: NeGuiException {
	mixin MixInNeGuiException;
}



///
typedef int TASK_ID;

/**
タスクトレイ用の人。
*/
struct TASKTRAY {
	NOTIFYICONDATA NotifyIcon;

	void sizeInit() {
		NotifyIcon.cbSize = NotifyIcon.sizeof;
	}

	NeWindow window() {
		return NotifyIcon.hWnd
			? cast(NeWindow)NeGui.getGuiObject(NotifyIcon.hWnd)
			: null
		;
	}
	void window(NeWindow wnd) {
		NotifyIcon.hWnd = wnd();
	}
	DWORD id() {
		return NotifyIcon.uID;
	}
	void id(DWORD Id) {
		NotifyIcon.uID = Id;
	}
	static enum NIF {
		MESSAGE = NIF_MESSAGE, /// uCallbackMessage
		ICON    = NIF_ICON, /// hIcon
		TIP     = NIF_TIP, /// szTip
		STATE   = NIF_STATE, /// Version 5.0 以降： dwState, dwStateMask
		INFO    = NIF_INFO, /// Version 5.0 以降： szInfo, uTimeout, szInfoTitle, dwInfoFlags
		GUID    = NIF_GUID, ///Version 6.0 以降： 予約されています。
	}
	NIF flags() {
		return cast(NIF)NotifyIcon.uFlags;
	}
	void flags(NIF Nif) {
		NotifyIcon.uFlags = Nif;
	}

	DWORD message() {
		return NotifyIcon.uCallbackMessage;
	}
	void message(DWORD MessageID) {
		NotifyIcon.uCallbackMessage = MessageID;
	}

	Icon icon() {
		return NotifyIcon.hIcon
			? new Icon(NotifyIcon.hIcon, false)
			: null
		;
	}
	void icon(Icon icon) {
		NotifyIcon.hIcon = icon();
	}

	static invariant auto TEXT_MAX = 128;
	Text tips()
	out(r) {
		assert(r.length < TEXT_MAX);
	}
	body {
		Text text=NotifyIcon.szTip.ptr;
		return text;
	}
	void tips(Text text) {
		if(text.length >= TEXT_MAX) {
			throw new TaskTrayException(Text("tool tip length over"));
		}
		//NotifyIcon.szTip = text.text;
		lstrcpy(NotifyIcon.szTip.ptr, text.ptr);
	}

	static enum NIS {
		NONE       = 0,
		HIDDEN     = NIS_HIDDEN, /// アイコンは非表示です。
		SHAREDICON = NIS_SHAREDICON, /// アイコンは共有されます。
	}

	mixin(StructGetSet!(NIS)("state", q{NotifyIcon.dwState}));
	
	NIS stateMask() {
		return cast(NIS)NotifyIcon.dwStateMask;
	}
	void stateMask(NIS Nis) {
		NotifyIcon.dwStateMask = Nis;
	}

	static invariant auto INFO_MAX = 255;
	Text infoTips()
	out(r) {
		assert(r.length < INFO_MAX);
	}
	body {
		Text text=NotifyIcon.szInfo.ptr;
		return text;
	}
	void infoTips(Text text) {
		if(text.length >= INFO_MAX) {
			throw new TaskTrayException(Text("info tip length over"));
		}
		//NotifyIcon.szTip = text.text;
		lstrcpy(NotifyIcon.szInfo.ptr, text.ptr);
	}

	UINT timeOut() {
		return cast(UINT)NotifyIcon.uTimeout;
	}
	void timeOut(UINT ms) {
		NotifyIcon.uTimeout = ms;
	}
	static enum VER {
		WIN95 = 0,
		WIN2K = NOTIFYICON_VERSION
	}
	VER ver() {
		return cast(VER)NotifyIcon.uVersion;
	}
	void ver(VER Ver) {
		NotifyIcon.uVersion = Ver;
	}

	static invariant auto TITLE_MAX = 64;
	Text infoTitle()
	out(r) {
		assert(r.length < TITLE_MAX);
	}
	body {
		Text text=NotifyIcon.szInfoTitle.ptr;
		return text;
	}
	void infoTitle(Text text) {
		if(text.length >= TITLE_MAX) {
			throw new TaskTrayException(Text("info title length over"));
		}
		lstrcpy(NotifyIcon.szInfoTitle.ptr, text.ptr);
	}
	static enum NIIF {
		NONE      = NIIF_NONE,      /// アイコンなし
		INFO      = NIIF_INFO,      /// 「情報」アイコン
		WARNING   = NIIF_WARNING,   /// 「警告」アイコン
		ERROR     = NIIF_ERROR,     /// 「エラー」アイコン
		ICON_MASK = NIIF_ICON_MASK, /// Version 6.0 以降： 予約されています。
		NOSOUND   = NIIF_NOSOUND,   /// Version 6.0 以降： 関連サウンドを鳴らさないようにします。バルーンツールチップにのみ適用されます。
	}
	NIIF infoFlag() {
		return cast(NIIF)NotifyIcon.dwInfoFlags;
	}
	void infoFlag(NIIF Niif) {
		NotifyIcon.dwInfoFlags = Niif;
	}
}

/**
タスクトレイ。

これなんで抽象クラスなんだろ。
もう忘れたなぁ。
*/
abstract class TaskTray: Raii {
	protected static invariant UINT TaskBar;
	static this() {
		TaskBar = RegisterWindowMessage(Text("TaskbarCreated").ptr);
	}
	
	private static enum NIM: UINT {
		ADD    = NIM_ADD, /// ステータスエリアにアイコンを追加します。
		MODIFY = NIM_MODIFY, /// アイコンを変更します。
		DELETE = NIM_DELETE, /// アイコンを削除します。
		SETFOCUS = NIM_SETFOCUS, /// Version 5.00 以降： タスクバー通知エリアにフォーカスを返します。タスクバーアイコンは、ユーザーインターフェース操作が完了したときにこのメッセージを送るべきです。例えば、タスクバーアイコンにショートカットメニューを表示して、ユーザーが ESC キーを押してキャンセルしたときに、このメッセージを送信してフォーカスをタスクバー通知エリアに返すべきです。
		SETRVERSION = NIM_SETVERSION, /// Version 5.00 以降： pnid パラメータで指定される NOTIFYICONDATA 構造体の uVersion メンバで指定されるバージョンに従って振舞うようにタスクバーに指定します。このメンバのデフォルト値は 0 であり、原型の Windows 95 の通知アイコンにおける振舞いになります。
	}
	
	this(bool Suicide=false) {
		super(Suicide);
	}
	/+
	+/

	private bool Notify(NIM Nim, TASKTRAY* Tray) {
		return Shell_NotifyIcon(Nim, &Tray.NotifyIcon)
			? true
			: false
		;
	}

	final bool addTray(TASKTRAY* Tray, bool WaitFlag=false, uint WaitTime=500, size_t LoopCount=5)
	in {
		if(WaitFlag) {
			assert(WaitTime);
			assert(LoopCount);
		}
	}
	body {
		if(!WaitFlag) {
			return Notify(NIM.ADD, Tray);
		} else {
			size_t i=0;
			try {
				do {
					Err.init;
					if(Notify(NIM.ADD, Tray)) {
						return true;
					} else if(Err.code != ERROR_TIMEOUT) {
						throw new TaskTrayException(Err.text);
					} else if(this.modifyTray(Tray)) {
						return true;
					} else {
						Sleep(WaitTime);
					}
				} while(LoopCount > i++)

				throw new TaskTrayException(Text("？"));
				
			} catch(TaskTrayException e) {
				throw new TaskTrayException(Text("タスクトレイ登録失敗"), NGEC.NONE, e);
			}
		}
	}
	final bool modifyTray(TASKTRAY* Tray) {
		return Notify(NIM.MODIFY, Tray);
	}
	final bool deleteTray(TASKTRAY* Tray) {
		return Notify(NIM.DELETE, Tray);
	}
	final bool focusTray(TASKTRAY* Tray) {
		return Notify(NIM.SETFOCUS, Tray);
	}
	final bool versionTray(TASKTRAY* Tray) {
		return Notify(NIM.SETRVERSION, Tray);
	}
}



