﻿/**

*/
module nemuxi.negui.system.type;

debug import std.stdio: wl = writefln, pl = printf;
debug(type) void main() {}

import std.bitmanip;
import std.string;
//import std.contracts;

import win32.core;
import win32.shellapi;
import win32.commctrl;

struct NEGUIPOINT {
	union {
		LPARAM lParam;
		struct {
			short x;
			short y;
		}
	}
}

/// プログラム表示方法
enum SHOW {
//	NONE            = -1,                 /// 表示非表示のフラグでなく別途用途に使用。
	HIDE            = SW_HIDE,            /// ウィンドウを非表示にして、他のウィンドウをアクティブにします。
	SHOWNORMAL      = SW_SHOWNORMAL,      /// ウィンドウをアクティブにして表示します。ウィンドウが最小化または最大化されている場合は、ウィンドウの位置とサイズを元に戻します。アプリケーションは、最初にウィンドウを表示させるときにこのフラグを指定するべきです。
	SHOWMINIMIZED   = SW_SHOWMINIMIZED,   /// ウィンドウをアクティブにして、最小化されたウィンドウとして表示します。
	SHOWMAXIMIZED   = SW_SHOWMAXIMIZED,   /// ウィンドウをアクティブにして、最大化されたウィンドウとして表示します。
	SHOWNOACTIVATE  = SW_SHOWNOACTIVATE,  /// ウィンドウをアクティブにはせずに表示します。
	SHOW            = SW_SHOW,            /// ウィンドウをアクティブにして、現在の位置とサイズで表示します。
	MINIMIZE        = SW_MINIMIZE,        /// 指定されたウィンドウを最小化して、次の Z オーダーにあるトップレベルウィンドウをアクティブにします。
	SHOWMINNOACTIVE = SW_SHOWMINNOACTIVE, /// ウィンドウを最小化されたウィンドウとして表示します。ウィンドウはアクティブ化されません。
	SHOWNA          = SW_SHOWNA,          /// ウィンドウを現在の位置とサイズで表示します。ウィンドウはアクティブ化されません。
	RESTORE         = SW_RESTORE,         /// ウィンドウをアクティブにして表示します。ウィンドウが最小化または最大化されている場合は、ウィンドウの位置とサイズを元に戻します。アプリケーションは、最小化されたウィンドウの位置とサイズを元に戻すときにこのフラグを指定するべきです。
	SHOWDEFAULT     = SW_SHOWDEFAULT,     /// アプリケーションを起動したプログラムが CreateProcess 関数にパラメータとして渡した STARTUPINFO 構造体で指定されている SW_ 値に基づいて表示状態が設定されます。
	FORCEMINIMIZE   = SW_FORCEMINIMIZE,   /// Windows 2000/XP： ウィンドウを所有しているスレッドがハングしている状態であっても、ウィンドウを最小化します。他のスレッドからウィンドウを最小化させる場合にのみ、このフラグを使用するべきです。
}

/// コマンド用ID。
typedef DWORD COMMAND_ID;
/// アイテム用ID。
typedef DWORD ITEM_ID;
/// ホットキー用ID。
typedef int HOTKEY_ID;
/// タイマー用ID。
typedef int TIMER_ID=WM_APP;
/// 通知メッセージ用。
typedef DWORD MESSAGETYPE;

public import nemuxi.negui.draw.canvas;
public import nemuxi.negui.dropfile;
public import nemuxi.negui.keyboard.keyboard;
public import nemuxi.negui.negui;
import nemuxi.utility.meta.memberproperty;


enum WM_MOUSEWHELL = 0x20A;

enum WINDOW_ACTIVE {
	INACTIVE    = WA_INACTIVE,    /// 非アクティブ化されます。
	ACTIVE      = WA_ACTIVE,      /// マウスクリック以外の方法（例えば、キーボードインターフェースによる選択や、 SetActiveWindow 関数によるもの）でアクティブ化されます。
	CLICKACTIVE = WA_CLICKACTIVE, /// マウスクリックによってアクティブ化されます。
}
alias WINDOW_ACTIVE WA;

enum SC {
	CLOSE        = SC_CLOSE        , /// ウィンドウを終了する
	CONTEXTHELP  = SC_CONTEXTHELP  , /// マウスポインタを疑問符付きにする
	DEFAULT      = SC_DEFAULT      , /// デフォルト項目を選択する
	HOTKEY       = SC_HOTKEY       , /// ホットキーに関連する
	HSCROLL      = SC_HSCROLL      , /// 水平方向にスクロールする
	ICON         = SC_ICON         , /// = SC_MINIMIZE
	KEYMENU      = SC_KEYMENU      , /// キーストロークを使用してメニューを取得
	MAXIMIZE     = SC_MAXIMIZE     , /// ウィンドウを最大化
	MINIMIZE     = SC_MINIMIZE     , /// ウィンドウをアイコン化
	MONITORPOWER = SC_MONITORPOWER , /// ディスプレイの電源管理状態を設定
	MOUSEMENU    = SC_MOUSEMENU    , /// マウスを使用してメニューを取得
	MOVE         = SC_MOVE         , /// ウィンドウを移動する
	NEXTWINDOW   = SC_NEXTWINDOW   , /// 次のウィンドウに移動
	PREVWINDOW   = SC_PREVWINDOW   , /// 前のウィンドウに移動
	RESTORE      = SC_RESTORE      , /// ウィンドウを元のサイズに戻す
	SCREENSAVE   = SC_SCREENSAVE   , /// スクリーンセーバを実行
	SIZE         = SC_SIZE         , /// ウィンドウのサイズを変更
	TASKLIST     = SC_TASKLIST     , /// タスクマネージャを実行
	VSCROLL      = SC_VSCROLL      , /// 水平方向にスクロールする
	ZOOM         = SC_ZOOM         , /// = SC_MAXIMIZE
}

/// WM_SIZE wParam
enum SIZE_TYPE: WPARAM {
	RESTORED  = SIZE_RESTORED,  ///	ウィンドウがサイズ変更されました。ただし最小化または最大化ではありません。
	MINIMIZED = SIZE_MINIMIZED, ///	ウィンドウが最小化されました。
	MAXIMIZED = SIZE_MAXIMIZED, ///	ウィンドウが最大化されました。
	MAXSHOW   = SIZE_MAXSHOW,   ///	ある他のウィンドウが元のサイズに戻されたとき、すべてのポップアップウィンドウに送られます。
	MAXHIDE   = SIZE_MAXHIDE,   ///	ある他のウィンドウが最大化されたとき、すべてのポップアップウィンドウに送られます。}
}
enum {
	SW_PARENTOPPENING = 3,
}
enum SHOW_FLAG {
	PARENTCLOSING  = SW_PARENTCLOSING,  /// 親ウィンドウがアイコン化されようとしている
	OTHERZOOM      = SW_OTHERZOOM,      /// 別のウィンドウが最大化されようとして見えなくなろうとしている
	PARENTOPPENING = SW_PARENTOPPENING, /// 親ウィンドウが表示されようとしている
	OTHERUNZOOM    = SW_OTHERUNZOOM,    /// 別のウィドウがアイコン化されたため見えるようになる
}
enum CONTROL_TYPE {
	BUTTON   = ODT_BUTTON  , /// ボタン
	COMBOBOX = ODT_COMBOBOX, /// コンボボックス
	LISTBOX  = ODT_LISTBOX , /// リストボックス
	LISTVIEW = ODT_LISTVIEW, /// リストビューコントロール
	MENU     = ODT_MENU    , /// メニュー
	STATIC   = ODT_STATIC  , /// スタティックコントロール
	TAB      = ODT_TAB     , /// タブ コントロール
}

unittest {
	assert(NMHDR.sizeof == NOTIFY.sizeof);
}
///
struct NOTIFY {
	NMHDR Nmhdr;
	mixin(SMixInStructHiddenOriginal!(void)(q{Nmhdr}));

	//mixin(StructGetSet!(HWND)("handle", q{Nmhdr.hwndFrom}));
	NeGui sender() {
		return NeGui.getGuiObject(Nmhdr.hwndFrom);
	}
	mixin(StructGetSet!(ITEM_ID)("id", q{Nmhdr.idFrom}));
	mixin(StructGetSet!(MESSAGETYPE)("code", q{Nmhdr.code}));
}

unittest {
	assert(MEASUREITEMSTRUCT.sizeof == MEASUREITEM.sizeof);
}
/***/
struct MEASUREITEM {
	MEASUREITEMSTRUCT MeasureItem;
	mixin(SMixInStructHiddenOriginal!(MEASUREITEMSTRUCT)(q{MeasureItem}));

	mixin(StructGetSet!(CONTROL_TYPE)("type", q{MeasureItem.CtlType}));
	mixin(StructGetSet!(ITEM_ID)("id", q{MeasureItem.CtlID}));

	mixin(StructGetSet!(COMMAND_ID)("commandID", q{MeasureItem.itemID}));
	
	mixin(StructGetSet!(int)("width", q{MeasureItem.itemWidth}));
	mixin(StructGetSet!(int)("height", q{MeasureItem.itemHeight}));

	mixin(StructGetSet!(void*)("data", q{MeasureItem.itemData}));
}
unittest {
	assert(DRAWITEMSTRUCT.sizeof == DRAWITEM.sizeof);
}
/***/
struct DRAWITEM {
	DRAWITEMSTRUCT DrawItem;
	mixin(SMixInStructHiddenOriginal!(DRAWITEMSTRUCT)(q{DrawItem}));

	mixin(StructGetSet!(CONTROL_TYPE)("type", q{DrawItem.CtlType}));
	mixin(StructGetSet!(ITEM_ID)("id", q{DrawItem.CtlID}));
	mixin(StructGetSet!(COMMAND_ID)("commandID", q{DrawItem.itemID}));

	///
	enum ACTION {
		DRAWENTIRE = ODA_DRAWENTIRE, /// コントロール全体を描画する必要がある場合は、このビットが設定されます。
		FOUCS      = ODA_FOCUS     , /// コントロールが入力フォーカスを取得したり失ったりするときに、このビットが設定されます。itemState メンバをチェックして、コントロールがフォーカスを持っているかどうかを調べる必要があります。
		SELECT     = ODA_SELECT    , /// 選択項目のステータスが変更されたときにだけ、このビットが設定されます。itemState メンバをチェックして、新しい選択項目のステータスを調べる必要があります。
	}
	mixin(StructGetSet!(ACTION)("action", q{DrawItem.itemAction}));

	/// 現在の描画動作が行われた後の項目の表示状態を指定します。
	enum STATE {
		CHECKED      = ODS_CHECKED     , /// メニュー項目をチェックする場合は、このビットが設定されます。このビットはメニューだけで使われます。
		DISABLED     = ODS_DISABLED    , /// 項目を使用できない状態で描画する場合は、このビットが設定されます。
		FOCUS        = ODS_FOCUS       , /// 項目が入力フォーカスを持つ場合は、このビットが設定されます。
		GRAYED       = ODS_GRAYED      , /// 項目を淡色表示する場合は、このビットが設定されます。このビットはメニューだけで使われます。
		SELECTED     = ODS_SELECTED    , /// 項目が選択されている場合は、このビットが設定されます。
		COMBOBOXEDIT = ODS_COMBOBOXEDIT, /// 描画が、オーナー描画コンボ ボックスの選択フィールド (エディット コントロール) で行われます。
		DEFAULT      = ODS_DEFAULT     , /// 項目は既定の項目です。
	}
	mixin(StructGetSet!(STATE)("state", q{DrawItem.itemState}));

	Canvas canvas() {
		return new Canvas(DrawItem.hDC, false);
	}

	// これどうしよ
	mixin(StructGetSet!(HWND)("handle", q{DrawItem.hwndItem}));
	
	//mixin(StructGetSet!(RECT)("rect", q{DrawItem.rcItem}));
	ref RECT rect() {
		return DrawItem.rcItem;
	}
	mixin(StructGetSet!(void*)("data", q{DrawItem.itemData}));
}

enum MOUSE_KEY {
	CONTROL = MK_CONTROL, /// [Ctrl]が押されている
	LEFT    = MK_LBUTTON, /// 左のマウスボタンが押されている
	MIDDLE  = MK_MBUTTON, /// 中央のマウスボタンが押されている
	RIGHT   = MK_RBUTTON, /// 右のマウスボタンが押されている
	SHIFT   = MK_SHIFT  , /// [Shift]キーが押されている
	OTHERS_1= MK_XBUTTON1,
	OTHERS_2= MK_XBUTTON2,
}

enum {
	HTHSCROOL = 6,
}
enum HT {
	BORDER      = HTBORDER     , /// 可変枠を持たない境界線上にある
	BOTTOM      = HTBOTTOM     , /// 可変枠の下辺境界線上にある
	BOTTOMLEFT  = HTBOTTOMLEFT , /// 同、左下隅にある
	BOTTOMRIGHT = HTBOTTOMRIGHT, /// 同、右下隅にある
	CAPTION     = HTCAPTION    , /// キャプションバー上にある
	CLIENT      = HTCLIENT     , /// クライアント領域内にある
	ERROR       = HTERROR      , /// デスクトップ上にあり、警告音を鳴らす
	HSCROOL     = HTHSCROOL    , /// 水平スクロールバーないある
	LEFT        = HTLEFT       , /// 可変枠の左辺境界線上にある
	MENU        = HTMENU       , /// メニューバー内にある
	MINBUTTON   = HTMINBUTTON  , /// アイコン化ボタン上にある
	REDUCE      = HTREDUCE     , /// ditto
	MAXBUTTON   = HTMAXBUTTON  , /// 最大化ボタン上にある
	ZOOM        = HTZOOM       , /// ditto
	NOWHERE     = HTNOWHERE    , /// デスクトップ上にある
	RIGHT       = HTRIGHT      , /// 可変枠の右辺境界線上にある
	SIZE        = HTSIZE       , /// サイズボックス内にある
	GROWBOX     = HTGROWBOX    , /// ditto
	SYSMENU     = HTSYSMENU    , /// システムメニュー内にある
	TOP         = HTTOP        , /// 可変枠の上辺境界線上にある
	TOPLEFT     = HTTOPLEFT    , /// 可変枠の左上隅にある
	TOPRIGHT    = HTTOPRIGHT   , /// 可変枠の右上隅にある
	TRANSPARENT = HTTRANSPARENT, /// 同じスレッドの別のウィンドウの下にある
	VSCROLL     = HTVSCROLL    , /// 垂直スクロールバー内にある
}

///
enum SIDEFLAG {
	LEFT        = WMSZ_LEFT,        /// 左辺
	RIGHT       = WMSZ_RIGHT,       /// 右辺
	TOP         = WMSZ_TOP,         /// 上辺
	TOPLEFT     = WMSZ_TOPLEFT,     /// 左上隅
	TOPRIGHT    = WMSZ_TOPRIGHT,    /// 右上隅
	BOTTOM      = WMSZ_BOTTOM,      /// 底辺
	BOTTOMLEFT  = WMSZ_BOTTOMLEFT,  /// 左下隅
	BOTTOMRIGHT = WMSZ_BOTTOMRIGHT, /// 右下隅
}

///
enum MENU_FLAG: ushort {
	GRAYED      = MF_GRAYED      , /// アイテムは灰色表示されています。
	DISABLED    = MF_DISABLED    , /// アイテムは無効化されています。
	BITMAP      = MF_BITMAP      , /// アイテムはビットマップを表示します。
	POPUP       = MF_POPUP       , /// アイテムはドロップダウンメニューまたはサブメニューを持ちます。
	HILITE      = MF_HILITE      , /// アイテムはハイライト表示されています。
	OWNERDRAW   = MF_OWNERDRAW   , /// アイテムはオーナードローアイテムです。
	SYSMENU     = MF_SYSMENU     , /// アイテムはウィンドウメニュー（システムメニュー）に含まれています。 hMenu パラメータには、メッセージに関連付けられたメニューのハンドルが指定されます。
	MOUSESELECT = MF_MOUSESELECT , /// アイテムはマウス操作によって選択されています。
}
alias MENU_FLAG MF;

enum MESSAGE_TYPE: MESSAGETYPE {
	MENU        = 0,
	ACCELERATOR = 1,
}

enum {
	DLGC_WANTARROWS      = 0x0001,
	DLGC_WANTTAB         = 0x0002,
	DLGC_WANTALLKEYS     = 0x0004,
	DLGC_WANTMESSAGE     = 0x0004,
	DLGC_HASSETSEL       = 0x0008,
	DLGC_DEFPUSHBUTTON   = 0x0010,
	DLGC_UNDEFPUSHBUTTON = 0x0020,
	DLGC_RADIOBUTTON     = 0x0040,
	DLGC_WANTCHARS       = 0x0080,
	DLGC_STATIC          = 0x0100,
	DLGC_BUTTON          = 0x2000,
	DLGC_PUSHBUTTON = 0x0020,

}
enum DLGC {
	DEFPUSHBUTTON = DLGC_DEFPUSHBUTTON, /// デフォルトプッシュボタン
	HASSETSEL     = DLGC_HASSETSEL,     /// EM_SETSELメッセージ
	PUSHBUTTON    = DLGC_PUSHBUTTON,    /// プッシュボタン
	RADIOBUTTON   = DLGC_RADIOBUTTON,   /// オプションボタン
	WANTALLKEYS   = DLGC_WANTALLKEYS,   /// 全てのキーボード入力
	WANTARROWS    = DLGC_WANTARROWS,    /// 方向キー
	WANTCHARS     = DLGC_WANTCHARS,     /// WM_CHARメッセージ
	//WANTMESSAG    = DLGC_WANTMESSAG,    /// E全てのキーボード入力(アプリケーションはこのメッセージをコントロールに渡す)
	WANTTAB       = DLGC_WANTTAB,       /// [Tab]キー
}

///
enum PRF {
	CHECKVISIBLE = PRF_CHECKVISIBLE, /// 見えている状態のときのみ描画
	CHILDREN     = PRF_CHILDREN    , /// 可視状態の子ウィンドウを描画
	CLIENT       = PRF_CLIENT      , /// クライアント領域を描画
	ERASEBKGND   = PRF_ERASEBKGND  , /// 描画前に背景を再描画
	NONCLIENT    = PRF_NONCLIENT   , /// 非クライアント領域を描画
	OWNED        = PRF_OWNED       , /// 所有する全てのウィンドウを描画
}

typedef bool delegate() OnEraseBackGroundDg;

enum {
	SB_THUMTRACK = 5,
	SB_BOTTMOM   = 7,
}
enum SCROLL {
	LINE_UP        = SB_LINEUP       , /// 上矢印を押した
	LINE_DOWN      = SB_LINEDOWN     , /// 下矢印を押した
	LINE_LEFT      = SB_LINELEFT     , /// 左へ1単位スクロール
	LINE_RIGHT     = SB_LINERIGHT    , /// 右へ1単位スクロール

	PAGE_UP        = SB_PAGEUP       , /// 上ページアップを押した
	PAGE_DOWN      = SB_PAGEDOWN     , /// 下ページアップを押した
	PAGE_LEFT      = SB_PAGELEFT     , /// 左へウィンドウの幅だけスクロール
	PAGE_RIGHT     = SB_PAGERIGHT    , /// 右へウィンドウの幅だけスクロール

	THUMB_POSITION = SB_THUMBPOSITION, /// lParamの下位ワードにサムの位置を示す
	THUMB_TRACK    = SB_THUMTRACK    , /// サム移動中, サムの位置を示す

	TOP            = SB_TOP          , /// [HOME]キーが押された
	BOTTOM         = SB_BOTTMOM      , /// [END]キーが押された
	LEFT           = SB_LEFT         , /// 左にスクロール
	RIGHT          = SB_RIGHT        , /// 右にスクロール

	END            = SB_ENDSCROLL    , /// スクロールが終了
}

