﻿/**
NeGuiの例外クラス。

NeGuiはException投げてもErrorは投げない。
※あくまで明示的にだけど。

History:
	1.00β19:
		新規作成。
*/
module nemuxi.negui.system.exception;

debug import std.stdio: wl = writefln, pl = printf;
debug(exception) void main() {}

public import std.contracts;
import std.date;
import std.string;

public import nemuxi.negui.system.text;
public import nemuxi.negui.system.timer;

/**
識別コード。

サブクラスで同じ値になってもクラス違えば違う意味。
*/
typedef uint EX_CODE;

class NeGuiException: Exception {
	// 集中管理
	enum CODE: EX_CODE {
		NONE,

		// タイマー
		DATETIME,
		DATETIME_DAY,
		DATETIME_HOUR,
		DATETIME_MINUTE,
		DATETIME_MONTH,
		DATETIME_MONTH_LIST,
		DATETIME_SECOND,
		DATETIME_WEEK,
		DATETIME_WEEKLIST,
		DATETIME_WEEK_NAME,

		// GUI
		GUI,
		GUI_CREATE,
	}
	unittest {
		static assert(CODE.max < EX_CODE.max / 2 + 1);
	}
	private {
		EX_CODE Code;
		d_time  Time;
	}
	this(in Text msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg.text8, file, line, next);
		Code = code;
		Time = UTCtoLocalTime(getUTCtime());
	}
	final const EX_CODE code() {
		return Code;
	}
	final const DateTime time() {
		return new DateTime(Time);
	}
	
	override string toString() {
		auto s=format(
			"%s@%s(%s): %s [code=%s, %s]",
			this.classinfo.name,
			file,
			line,
			msg,
			code,
			time
		);
		if(next) {
			s ~= newline ~ next.toString;
		}

		return s;
	}
}
///
alias NeGuiException.CODE NGEC;

template MixInNeGuiException() {
	override this(in Text msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, code, next, file, line);
	}
}


