﻿/**
タンス。
*/
module nemuxi.negui.layout.panel.tansu;

debug import std.stdio: wl = writefln, pl = printf;
debug(tansu) void main() {}

import std.math;

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.layout.layout;
public import nemuxi.negui.layout.panel.panel;

/**
箪笥型パネル。

各セルの領域は同じ大きさ。
ただし最終要素の横幅がパディング領域を超える場合はパディング領域に収まるように努力する。

セルとセルの間はpaddingが決定する。
*/
class Tansu: Panel, IDirection {
	invariant() {
		assert(Direction == DIRECTION.HORIZON || Direction == DIRECTION.VERTICAL);
	}
	/+
	///
	enum TYPE {
		HORIZON,  /// 水平
		VERTICAL, /// 垂直
	}
	protected TYPE Type;
	final TYPE type() const {
		return Type;
	}
	+/
	mixin TDirection;
	
	SIZEINFO sizeInfo;
	
	this(DIRECTION Direction, size_t Length=0) {
		this.Direction = Direction;
		if(Length) {
			length = Length;
		}
	}

	override void onSize(ref const(RECT) TotalSize) {
		if(!Contents.length) {
			return;
		}
		/+
		// パディング領域を含む領域の取得。
		RECT InPaddingSize=void;
		
		InPaddingSize.left   = TotalSize.left   + margin.left;
		InPaddingSize.top    = TotalSize.top    + margin.top;
		InPaddingSize.right  = TotalSize.right  - margin.right;
		InPaddingSize.bottom = TotalSize.bottom - margin.bottom;
		+/
		immutable InPaddingSize=GetInPaddingSize(TotalSize);
		
		immutable ElementSize = GetElemntSize(Direction, sizeInfo, InPaddingSize);
		
		// 有効なコンテント領域の取得。
		auto ContentSize=GetContentSize(InPaddingSize);

		
		foreach(i, Content; Contents) {
			
			bool LoopLast() {
				return i == Contents.length - 1 && sizeInfo.type == SIZEINFO.TYPE.PERCENT && ContentSize.right > InPaddingSize.right;
			}
			
			switch(Direction) {
				case DIRECTION.HORIZON:
					ContentSize.left  = InPaddingSize.left + padding.left * (i + 1) + padding.right * i + ElementSize * i;
					ContentSize.right = ContentSize.left   + ElementSize;
					if(LoopLast()) {
						ContentSize.right = InPaddingSize.right  - padding.right;
					}
					break;
				
				case DIRECTION.VERTICAL:
					ContentSize.top = InPaddingSize.top + padding.top * (i + 1) + padding.bottom * i + ElementSize * i;
					ContentSize.bottom= ContentSize.top+ ElementSize;
					if(LoopLast()) {
						ContentSize.bottom = InPaddingSize.bottom  - padding.bottom;
					}
					break;
				
				default:
					assert(false);
			}
			Content.onSize(ContentSize);
		}
	}
}

