﻿/**
キーボード。
*/
module nemuxi.negui.keyboard.keyboard;

debug import std.stdio: wl = writefln, pl = printf;
debug(keyboard) void main() {}

import std.bitmanip;
import std.string;

import win32.core;

import nemuxi.base;

///
class KeyBoardException: NeGuiException {
	mixin MixInNeGuiException;
}

/**
History:
	1.00β13:
		NONE追加。
*/
enum MOD: ubyte {
	NONE    = 0,
	ALT     = MOD_ALT, /// [ALT]キー
	CONTROL = MOD_CONTROL, /// [Ctrl]キー
	SHIFT   = MOD_SHIFT, /// [Shift]キー
	WIN     = MOD_WIN, /// Windowsキー
}
///
enum: ubyte {
	HOTKEY_SHIFT  = 0x01, /// [Shift]キー
	HOTKEY_CONTROL= 0x02, /// [Ctrl]キー
	HOTKEY_ALT    = 0x04, /// [ALT]キー
	HOTKEY_EXT    = 0x08, /// 拡張キー
}
/**
History:
	1.00β13:
		NONE追加。
*/
enum HOTKEY: ubyte {
	NONE    = 0,
	SHIFT   = HOTKEY_SHIFT  , ///     &H1    [Shift]キー
	CONTROL = HOTKEY_CONTROL, ///     &H2    [Ctrl]キー
	ALT     = HOTKEY_ALT    , ///     &H4    [ALT]キー
	EXT     = HOTKEY_EXT    , ///     &H8    拡張キー
}


/// 仮想キー。
enum KEY: ubyte {
	MOUSE_L = VK_LBUTTON, /// マウス左ボタン
	MOUSE_R = VK_RBUTTON, /// マウス右ボタン
	CANCEL  = VK_CANCEL, /// [Cancel]
	MOUSE_M = VK_MBUTTON, /// マウス中央ボタン
	MOUSE_X1 = VK_XBUTTON1, /// Windows 2000/XP： マウス X1 ボタン
	MOUSE_X2 = VK_XBUTTON2, /// Windows 2000/XP： マウス X2 ボタン
	BACK = VK_BACK, /// [Back space]
	TAB = VK_TAB, /// [Tab]
	CREAR = VK_CLEAR, /// [Clear]
	ENTER = VK_RETURN, /// [Enter]
	SHIFT = VK_SHIFT, /// [Shift]
	CONTROL = VK_CONTROL, /// [Ctrl]
	ALT = VK_MENU, /// [Alt]
	PAUSE = VK_PAUSE, /// [Pause]
	CAPS_LOCK = VK_CAPITAL, /// [Caps Lock]
	KANA = VK_KANA, /// IME カナモード
	JUNJA = VK_JUNJA, /// 
	FINAL = VK_FINAL, /// 
	HANJA = VK_HANJA, /// 
	KANJI = VK_KANJI, /// IME 漢字モード
	ESC = VK_ESCAPE, /// [Esc]
	CONVERT = VK_CONVERT, /// IME 変換
	NONCONVERT = VK_NONCONVERT, /// IME 無変換
	ACCEPT = VK_ACCEPT, /// 
	MODECHANGE = VK_MODECHANGE, /// IME モード変更
	SPACE = VK_SPACE, /// スペースキー
	PAGEUP = VK_PRIOR, /// [Page Up]
	PAGEDOWN = VK_NEXT, /// [Page Down]
	END = VK_END, /// [End]
	HOME = VK_HOME, /// [Home]
	LEFT = VK_LEFT, /// [←]
	UP = VK_UP, /// [↑]
	RIGHT = VK_RIGHT, /// [→]
	DOWN = VK_DOWN, /// [↓]
	SELECT = VK_SELECT, /// [Select]
	PRINT = VK_PRINT, /// [Print]
	EXECUTE = VK_EXECUTE, /// [Execute]
	PRINT_SCREEN = VK_SNAPSHOT, /// [Print Screen]
	INSERT = VK_INSERT, /// [Insert]
	DELETE = VK_DELETE, /// [Delete]
	HELP = VK_HELP, /// [Help]

	KEY_0 = 0x30, /// [0]
	KEY_1, /// [1]
	KEY_2, /// [2]
	KEY_3, /// [3]
	KEY_4, /// [4]
	KEY_5, /// [5]
	KEY_6, /// [6]
	KEY_7, /// [7]
	KEY_8, /// [8]
	KEY_9, /// [9]
	A = 0x41, /// [A]
	B, /// [B]
	C, /// [C]
	D, /// [D]
	E, /// [E]
	F, /// [F]
	G, /// [G]
	H, /// [H]
	I, /// [I]
	J, /// [J]
	K, /// [K]
	L, /// [L]
	M, /// [M]
	N, /// [N]
	O, /// [O]
	P, /// [P]
	Q, /// [Q]
	R, /// [R]
	S, /// [S]
	T, /// [T]
	U, /// [U]
	V, /// 1.00β16
	W, /// [W]
	X, /// [X]
	Y, /// [Y]
	Z, /// [Z]
	WINDOWS_L = VK_LWIN, /// 左の Windows キー
	WINDOWS_R = VK_RWIN, /// 右の Windows キー
	APPS = VK_APPS, /// アプリケーションキー
	SLEEP = VK_SLEEP, /// コンピュータスリープキー
	PAD_0 = VK_NUMPAD0, /// テンキーの [0]
	PAD_1, /// テンキーの [1]
	PAD_2, /// テンキーの [2]
	PAD_3, /// テンキーの [3]
	PAD_4, /// テンキーの [4]
	PAD_5, /// テンキーの [5]
	PAD_6, /// テンキーの [6]
	PAD_7, /// テンキーの [7]
	PAD_8, /// テンキーの [8]
	PAD_9 = VK_NUMPAD9, /// テンキーの [9]

	PAD_MULTIPLY = VK_MULTIPLY, /// テンキーの [ * ]
	PAD_ADD = VK_ADD, /// テンキーの [ + ]
	PAD_ENTER = VK_SEPARATOR, /// テンキーの [Enter]
	PAD_SUBTRACT = VK_SUBTRACT, /// テンキーの [ - ]
	PAD_DECIMAL = VK_DECIMAL, /// テンキーの [ . ]
	PAD_DIVIDE = VK_DIVIDE, /// テンキーの [ / ]
	F1	= VK_F1, /// [F1]
	F2	= VK_F2, /// [F2]
	F3	= VK_F3, /// [F3]
	F4	= VK_F4, /// [F4]
	F5	= VK_F5, /// [F5]
	F6	= VK_F6, /// [F6]
	F7	= VK_F7, /// [F7]
	F8	= VK_F8, /// [F8]
	F9	= VK_F9, /// [F9]
	F10	= VK_F10, /// [F10]
	F11	= VK_F11, /// [F11]
	F12	= VK_F12, /// [F12]
	F13	= VK_F13, /// [F13]
	F14	= VK_F14, /// [F14]
	F15	= VK_F15, /// [F15]
	F16	= VK_F16, /// [F16]
	F17	= VK_F17, /// [F17]
	F18	= VK_F18, /// [F18]
	F19	= VK_F19, /// [F19]
	F20	= VK_F20, /// [F20]
	F21	= VK_F21, /// [F21]
	F22	= VK_F22, /// [F22]
	F23	= VK_F23, /// [F23]
	F24	= VK_F24, /// [F24]

	NUMLOCK = VK_NUMLOCK, /// [Num Lock]
	SCROLL_LOCK = VK_SCROLL, /// [Scroll Lock]
	OME_92 = 0x92,
	OME_93,
	OME_94,
	OME_95,
	OME_96,
	SHIFT_L = VK_LSHIFT, /// 左の [Shift]
	SHIFT_R = VK_RSHIFT, /// 右の [Shift]
	CONTROL_L = VK_LCONTROL, /// 左の [Ctrl]
	CONTROL_R = VK_RCONTROL, /// 右の [Ctrl]
	ALT_L = VK_LMENU, /// 左の [Alt]
	ALT_R = VK_RMENU, /// 右の [Alt]
	BROWSER_BACK = VK_BROWSER_BACK, /// Windows 2000/XP： ブラウザの「戻る」キー
	BROWSER_FORWARD = VK_BROWSER_FORWARD, /// Windows 2000/XP： ブラウザの「次へ」キー
	BROWSER_REFRESH = VK_BROWSER_REFRESH, /// Windows 2000/XP： ブラウザの「更新」キー
	BROWSER_STOP = VK_BROWSER_STOP, /// Windows 2000/XP： ブラウザの「中止」キー
	BROWSER_SEARCH = VK_BROWSER_SEARCH, /// Windows 2000/XP： ブラウザの「検索」キー
	BROWSER_FAVORITES = VK_BROWSER_FAVORITES, /// Windows 2000/XP： ブラウザの「お気に入り」キー
	BROWSER_HOME = VK_BROWSER_HOME, /// Windows 2000/XP： ブラウザの「ホーム」キー
	VOLUME_MUTE = VK_VOLUME_MUTE, /// Windows 2000/XP： ボリュームのミュートキー
	VOLUME_DOWN = VK_VOLUME_DOWN, /// Windows 2000/XP： ボリュームダウンキー
	VOLUME_UP = VK_VOLUME_UP, /// Windows 2000/XP： ボリュームアップキー
	MEDIA_NEXT_TRACK = VK_MEDIA_NEXT_TRACK, /// Windows 2000/XP： 「次のトラック」キー
	MEDIA_PREV_TRACK = VK_MEDIA_PREV_TRACK, /// Windows 2000/XP： 「前のトラック」キー
	MEDIA_STOP = VK_MEDIA_STOP, /// Windows 2000/XP： 「メディア停止」キー
	MEDIA_PLAY_PAUSE = VK_MEDIA_PLAY_PAUSE, /// Windows 2000/XP： 「メディア Start / Stop 」キー
	LAUNCH_MAIL = VK_LAUNCH_MAIL, /// Windows 2000/XP： 「メール開始」キー
	LAUNCH_MEDIA_SELECT = VK_LAUNCH_MEDIA_SELECT, /// Windows 2000/XP： 「メディア選択」キー
	LAUNCH_APP1 = VK_LAUNCH_APP1, /// Windows 2000/XP： 「アプリケーション 1 起動」キー
	LAUNCH_APP2 = VK_LAUNCH_APP2, /// Windows 2000/XP： 「アプリケーション 2 起動」キー
	OEM_1 = VK_OEM_1, /// さまざまな文字。Windows 2000/XP： U.S. 標準キーボードでは [ :; ]

	OEM_PLUS = VK_OEM_PLUS, /// Windows 2000/XP： [ + ]
	OEM_COMMA = VK_OEM_COMMA, /// Windows 2000/XP： [ , ]
	OEM_MINUS = VK_OEM_MINUS, /// Windows 2000/XP： [ - ]
	OEM_PERIOD = VK_OEM_PERIOD, /// Windows 2000/XP： [ . ]

	OEM_2 = VK_OEM_2, /// さまざまな文字。Windows 2000/XP： U.S. 標準キーボードでは [ /? ]

	OEM_3 = VK_OEM_3, /// さまざまな文字。Windows 2000/XP： U.S. 標準キーボードでは [ `~ ]

	OEM_4 = VK_OEM_4, /// さまざまな文字。Windows 2000/XP： U.S. 標準キーボードでは [ [{ ]

	OEM_5 = VK_OEM_5, /// さまざまな文字。Windows 2000/XP： U.S. 標準キーボードでは [ \| ]

	OEM_6 = VK_OEM_6, /// さまざまな文字。Windows 2000/XP： U.S. 標準キーボードでは [ ]} ]

	OEM_7 = VK_OEM_7, /// さまざまな文字。Windows 2000/XP： U.S. 標準キーボードでは [ '" ]

	OEM_8 = VK_OEM_8, ///  さまざまな文字。

	OEM_102, /// Windows 2000/XP： RT 102-key キーボードの角カッコまたはバックスラッシュ
	PROCESSKEY, /// Windows 95/98/Me/NT 4.0/2000/XP： IME Process
	PACKET, /// 
	ATTN = VK_ATTN, /// Attn
	CRSEL = VK_CRSEL, /// CrSel
	EXSEL = VK_EXSEL, /// ExSel
	EREOF = VK_EREOF, /// Erase EOF
	PLAY = VK_PLAY, /// Play
	ZOOM = VK_ZOOM, /// Zoom
	NONAME = VK_NONAME, /// 予約
	PA1 = VK_PA1, /// PA1
	OEM_CLEAR = VK_OEM_CLEAR, /// Clear
}

/**
History:
	1.00β17:
		新規追加。
*/
wchar toCharacter(KEY Key) {
	return LOWORD(MapVirtualKey(Key, 2));
}

/**
*/
struct KEYDATA {
	/**
	キー情報作成。

	Params:
		lParam = キー情報メッセージ。

	Return:
		当てはめたような感じ。
	*/
	static KEYDATA opCall(LPARAM lParam) {
		KEYDATA key;
		key.data = lParam;
		return key;
	}
	union {
		/// 生データ
		LPARAM data;
		mixin(bitfields!(
			ubyte, "count",  16,
			ubyte, "scan",    8,
			bool,  "ex",      1,
			bool,  "",        2,
			bool,  "",        2,
			bool,  "context", 1,
			bool,  "prev",    1,
			bool,  "keyup",   1
		));
	}
	unittest {
		assert(KEYDATA.sizeof == LPARAM.sizeof);
	}
	string toString() {
		return format(
			"[KeyData]"
			"  count = %s"   , count,
			", scan = %s"    , scan,
			", ex = %s"      , ex,
			", context = %s" , context,
			", prev = %s"    , prev,
			", keyup = %s"   , keyup
		);
	}
}

/**
新規作成。

History:
	1.00β14:
		[S] 新規追加。
*/
struct KEYVALUE {
	MOD mod;
	KEY key;
}

/**
*/
struct HOTKEYVALUE {
	HOTKEY Mod;
	KEY Key;

	/**
	History:
		1.00β17:
			[B] 複数キー入力時に大変なことになっていたのを修正。

		1.00β13:
			defaultの戻り値変更。
	*/
	MOD hotkeyToMod() {
		/+
		with(HOTKEY) switch(Mod) {
			case ALT    : return MOD.ALT;
			case CONTROL: return MOD.CONTROL;
			case SHIFT  : return MOD.SHIFT;
			case EXT    : return MOD.WIN;
			default     : return MOD.NONE;
		}
		+/
		MOD Mod=MOD.NONE;
		
		auto ModMods = [MOD.ALT,    MOD.CONTROL,    MOD.SHIFT,    MOD.WIN];
		auto HotMods = [HOTKEY.ALT, HOTKEY.CONTROL, HOTKEY.SHIFT, HOTKEY.EXT];
		
		for(auto i=0; i < ModMods.length; i++) {
			if((this.Mod & HotMods[i]) == HotMods[i]) {
				Mod |= ModMods[i];
			}
		}

		return Mod;
	}
	/**
	History:
		1.00β17:
			[B] 複数キー入力時に大変なことになっていたのを修正。

		1.00β13:
			defaultの設定値変更。
	*/
	void modToHotkey(MOD Mod) {
		/+
		with(MOD) switch(Mod) {
			case ALT    : this.Mod=HOTKEY.ALT;     break;
			case CONTROL: this.Mod=HOTKEY.CONTROL; break;
			case SHIFT  : this.Mod=HOTKEY.SHIFT;   break;
			case WIN    : this.Mod=HOTKEY.EXT;     break;
			default     : this.Mod=HOTKEY.NONE;
		}
		+/
		this.Mod = HOTKEY.NONE;
		
		auto ModMods = [MOD.ALT,    MOD.CONTROL,    MOD.SHIFT,    MOD.WIN];
		auto HotMods = [HOTKEY.ALT, HOTKEY.CONTROL, HOTKEY.SHIFT, HOTKEY.EXT];

		for(auto i=0; i < ModMods.length; i++) {
			if((Mod & ModMods[i]) == ModMods[i]) {
				this.Mod |= HotMods[i];
			}
		}
	}
}

__EOF__;
struct KEYSTATE {
	static KEYSTATE opCall(SHORT data) {
		KEYSTATE state;
		state.data = data;
		return state;
	}
	union {
		short data;
		mixin(bitfields!(
			bool, "toggle",  1,
			bool, "",       14,
			bool, "pushed",  1
		));
	}
	bool nonPush() {
		return data == 0;
	}
}
struct KEYBOARD {
	static KEYSTATE getKeyState(KEY Key) {
		return KEYSTATE(GetKeyState(Key));
	}
}

