﻿/**
単位変換とか単位分の何かを取得。

大丈夫なんかいと思いながらもデスクトップのウィンドウハンドルでデバイスコンテキスト。
GetDC(GetDesktopWindow())で検索したら結構出てきたんで大丈夫認定。…大丈夫なんかい。
*/
module nemuxi.negui.draw.unit;

debug import std.stdio: wl = writefln, pl = printf;
debug(unit) void main() {}

import std.math;

import win32.windows;

import nemuxi.base;
import nemuxi.negui.negui;
import nemuxi.negui.draw.font;
import nemuxi.image.icon;

/**
ポイント→ピクセル変換。
*/
int PointToPixel(int Point) {
	auto hDC=GetDC(GetDesktopWindow());
	scope(exit) if(hDC) DeleteDC(hDC);

	return MulDiv(Point, GetDeviceCaps(hDC, LOGPIXELSY), 72);
}


/**
メニュー一行あたりの高さ。
アイコンの大きさとシステムの規定の高さから背比べ。
*/
int GetMenuHeight(int IconHeight) {
	auto menu=GetSystemMetrics(SM_CYMENU);

	return IconHeight > menu
		? IconHeight
		: menu
	;
}

int GetFontHeightPx(in Font font) {
	return abs(PointToPixel(font.height));
}
int GetDefaultControlHeight(in Font font) {
	return GetFontHeightPx(font) + GetSystemMetrics(SM_CYEDGE)*2;
}

Font GetSafeFont(NeGui gui) {
	if(auto CtrlFont = gui.font) {
		return CtrlFont;
	} else {
		return new Font(Font.STOCK.SYSTEM);
	}
}

ref SIZE GetControlPadding() {
	auto Size=new SIZE;
	Size.cx = GetSystemMetrics(SM_CXFRAME);
	Size.cy = GetSystemMetrics(SM_CYFRAME);
	return *Size;
}

void GetIconControlHeight(ICONSIZE IconSize, ref SIZE Size) {
	auto IconPx=GetIconSize(IconSize);
	Size.cx = IconPx + GetSystemMetrics(SM_CXEDGE)*2;
	Size.cy = IconPx + GetSystemMetrics(SM_CYEDGE)*2;
}

/**
History:
	1.00β19:
		[P] 取得方法の変更。
*/
ref SIZE GetIconControlSize(ICONSIZE IconSize) {
	/+
	immutable IconPx= GetIconSize(IconSize);
	auto Padding=new SIZE;
	*Padding = GetControlPadding();

	Padding.cx += Padding.cx+IconPx;
	Padding.cy += Padding.cy+IconPx;

	return *Padding;
	+/
	auto IconPx=new SIZE;
	GetIconControlHeight(IconSize, *IconPx);
	return *IconPx;
}

