﻿/**

*/
module nemuxi.negui.draw.region;

debug import std.stdio: wl = writefln, pl = printf;

debug(region) void main() {}

import win32.core;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.draw.draw;
/+
/**
*/
deprecated class Region: Raii {
	///
	static enum COMP {
		NULL      = NULLREGION, /// リージョンは空です。
		SIMPLE    = SIMPLEREGION, /// リージョンは単一の長方形です。
		LEXREGION = COMPLEXREGION, ///リージョンは単一の長方形より複雑な形です。
	}
	protected COMP Complexity;
	protected HRGN hRegion;
	mixin KillResource!("リージョン", hRegion, DeleteObject, 0);
	/+
	override void Kill() {
		if(!hRegion)
			throw new NeGuiException(Text("リージョンが未設定"));
		
		debug {
			debug wd(wf("Region.Kill == %s", DeleteObject(hRegion)));
		} else {
			DeleteObject(hRegion);
		}
	}
	+/
	///
	//this() {}
	///
	this(HWND hWnd) {
		if(!IsWindow(hWnd))
			throw new NemuxiException("指定オブジェクトがWindows的に死んでます");
		
		Complexity = cast(COMP)GetWindowRgn(hWnd, hRegion);
		Suicide = true;
	}
	this(RECT* Rect) {
		if((hRegion = CreateRectRgnIndirect(Rect)) != null) {
			Suicide = true;
			Complexity = COMP.SIMPLE;
		}
	}
}

+/