﻿/**
イメージリスト。
*/
module nemuxi.negui.draw.imagelist;

debug import std.stdio: wl = writefln, pl = printf;

debug(imagelist) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.draw.draw;
import nemuxi.negui.draw.icon;


///
class ImageListException: DrawException {
	mixin MixInNeGuiException;
}

/**
イメージリスト。

イメージリストハンドルのラッパ。
*/
class ImageList: Draw {
	/// イメージリストハンドル。
	protected alias Handle hImageList;
	mixin KillResource!("イメージリスト", hImageList, ImageList_Destroy, 0);

	/**
	History:
		1.00β15:
			[S] ILC -> COLOR_TYPEに名称変更。
	*/
	static enum COLOR_TYPE {
		COLOR    = ILC_COLOR    , /// デフォルトの動作を示す。通常は ILC_COLOR4 が用いられる
		COLOR4   = ILC_COLOR4   , /// 4ビットDIBセクションを使用する
		COLOR8   = ILC_COLOR8   , /// 8ビットDIBセクションを使用する
		COLOR16  = ILC_COLOR16  , /// 16ビットDIBセクションを使用する
		COLOR24  = ILC_COLOR24  , /// 24ビットDIBセクションを使用する
		COLOR32  = ILC_COLOR32  , /// 32ビットDIBセクションを使用する
		COLORDDB = ILC_COLORDDB , /// DDBを使用する
		MASK     = ILC_MASK     , /// マスクを使用する。イメージリストには、通常のビットマップとマスクビットマップがセットで扱われる
	}
	alias COLOR_TYPE ILC;
	/**
	*/
	this(int Width, int Height, COLOR_TYPE IlcFlags, size_t InitSize, size_t ExSize, bool Suicide=true) {
		auto hImgList = ImageList_Create(
			Width,
			Height,
			IlcFlags,
			InitSize,
			ExSize
		);
		this(hImgList, Suicide);
	}
	/**
	*/
	override this(HIMAGELIST hImageList, bool Suicide) {
		super(hImageList, Suicide);
	}

	/**
	描画オブジェクトの追加。

	Params:
		icon = アイコン。

	Return:
		追加オブジェクトのインデックス。

	Exception:
		失敗時にImageListExceptionを投げる。
	*/
	size_t add(in Icon icon) {
		auto Index=ImageList_AddIcon(hImageList , icon());
		if(Index == -1) {
			throw new ImageListException(Text("アイコン追加失敗"));
		}

		return Index;
	}
}

