﻿/**

*/
module nemuxi.negui.draw.draw;

debug import std.stdio: wl = writefln, pl = printf;

debug(draw) void main() {}

import nemuxi.base;
import nemuxi.system.raii;

///
class DrawException: NeGuiException {
	mixin MixInNeGuiException;
}


///
template GetImportObject(alias Graphic, alias Handle, alias Struct, alias CreateStructFunc) {
	const ref Struct GetStruct(HANDLE Handle, string file=__FILE__, int line=__LINE__) {
		auto StructPonit=new Struct;
		if(GetObject(Handle, Struct.sizeof, StructPonit) == 0) {
			throw new NemuxiException(Graphic, EC.NONE,
				new DrawException(Text("情報取得失敗"), NGEC.NONE, null, file, line)
			);
		}
		return *StructPonit;
	}
	bool Import(ref const(Struct) StructPonit) {
		Kill();
		scope(exit) if(Handle) Suicide = true;
		return (Handle = CreateStructFunc(cast(Struct*)&StructPonit)) != null ? true: false;
	}
}

abstract class Draw: HandleRaii {
	mixin HandleRaiiClass;
}

