﻿/**

*/
module nemuxi.negui.draw.cursor;

debug import std.stdio: wl = writefln, pl = printf;

debug(cursor) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.draw.draw;

///
class CursorException: DrawException {
	mixin MixInNeGuiException;
}

class Cursor: Draw {
	protected alias Handle hCursor;
	mixin KillResource!("カーソル", hCursor, DestroyCursor, 0);

	mixin HandleRaiiClass;

	/// カーソル位置設定。
	static bool setPos(in int x, in int y) {
		return cast(bool)SetCursorPos(x, y);
	}
	/// ditto
	static bool setPos(const ref POINT Point) {
		return setPos(Point.x, Point.y);
	}

	/***/
	static ref POINT getPos() {
		auto Point=new POINT;

		enforce(GetCursorPos(Point), new CursorException(Err.text));

		return *Point;
	}
}



