﻿/**
あ
*/
module nemuxi.negui.control.treeview.treeview;

debug import std.stdio: wl = writefln, pl = printf;
debug(treeview) void main() {}

import std.bitmanip;
import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.imagelist;
import nemuxi.negui.window.window;
public import nemuxi.negui.control.control;
import nemuxi.utility.meta.memberproperty;

///
class TreeViewException: ControlException {
	mixin MixInNeGuiException;
}


typedef HTREEITEM TREE_NODE=TVI_ROOT; /// こいつに落ち着いた！
alias TREE_NODE TREE_HANDLE; /// 散々ハンドルを隠蔽したのに。
alias TREE_HANDLE TREE_ITEM; /// 構造体とかぶる。
enum {
	TVIS_EXPANDPARTIAL=0x0080,
	TVSI_NOSINGLEEXPAND=0x8000,
}

enum {
  TVN_ASYNCDRAW           = TVN_FIRST-20,
  TVN_ITEMCHANGINGA       = TVN_FIRST-16,
  TVN_ITEMCHANGINGW       = TVN_FIRST-17,
  TVN_ITEMCHANGEDA        = TVN_FIRST-18,
  TVN_ITEMCHANGEDW        = TVN_FIRST-19,
}
version(UNICODE) enum {
  TVN_ITEMCHANGING        = TVN_ITEMCHANGINGW,
  TVN_ITEMCHANGED         = TVN_ITEMCHANGEDW,
} else enum {
  TVN_ITEMCHANGING        = TVN_ITEMCHANGINGA,
  TVN_ITEMCHANGED         = TVN_ITEMCHANGEDA,
}



class TreeView: Control, ICommonControl, INoHideSelect {
	immutable TEXTLENGTH = 1024;
	enum EVENT: MESSAGETYPE {
		ASYNCDRAW      = TVN_ASYNCDRAW     ,
		BEGINDRAG      = TVN_BEGINDRAG     ,
		BEGINLABELEDIT = TVN_BEGINLABELEDIT,
		BEGINRDRAG     = TVN_BEGINRDRAG    ,
		DELETEITEM     = TVN_DELETEITEM    ,
		ENDLABELEDIT   = TVN_ENDLABELEDIT  ,
		GETDISPINFO    = TVN_GETDISPINFO   ,
		GETINFOTIP     = TVN_GETINFOTIP    ,
		ITEMCHANGED    = TVN_ITEMCHANGED   ,
		ITEMCHANGING   = TVN_ITEMCHANGING  ,
		ITEMEXPANDED   = TVN_ITEMEXPANDED  ,
		ITEMEXPANDING  = TVN_ITEMEXPANDING ,
		KEYDOWN        = TVN_KEYDOWN       ,
		SELCHANGED     = TVN_SELCHANGED    ,
		SELCHANGING    = TVN_SELCHANGING   ,
		SETDISPINFO    = TVN_SETDISPINFO   ,
		SINGLEEXPAND   = TVN_SINGLEEXPAND  ,
	}
	mixin CommonControl;
	
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Style |= TVS_HASBUTTONS | TVS_HASLINES | TVS_LINESATROOT;
		NeGuiInfo.ExStyle |= WS_EX_CLIENTEDGE;
		NeGuiInfo.ClassName = WC_TREEVIEW;
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		super(&NeGuiInfo);

		noHideSelect = true;
	}
	override this(GUIINFO* NeGuiInfo) {
		super(NeGuiInfo);
	}

	/**
	指定アイテムの削除。

	Params:
		Item = 削除するアイテム

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool del(TREE_ITEM Item) {
		return super.send(TVM_DELETEITEM, NONE, cast(LPARAM)Item)
			? true
			: false
		;
	}
	
	static enum EXPAND {
		COLLAPSE       = TVE_COLLAPSE, /// 子アイテムのリストを閉じます。
		EXPAND         = TVE_EXPAND,   /// 子アイテムのリストを開きます。
		TOGGLE         = TVE_TOGGLE,   /// 子アイテムのリストが開かれている場合にはリストを閉じ、閉じられている場合にはリストを開きます。
		EXPAND_CHILD   = TVE_EXPAND | TVE_EXPANDPARTIAL,   /// Version 4.70 以上： 子アイテムのリストの一部のみを開きます。
		COLLAPSE_CHILD = TVE_COLLAPSE | TVE_COLLAPSERESET, /// 子アイテムのリストを閉じて、子アイテムを削除します。
	}
	bool expand(TREE_ITEM Item, EXPAND Expand) {
		return cast(bool)send(TVM_EXPAND, cast(WPARAM)Expand, cast(LPARAM)Item);
	}
	
	/**
	背景色の取得。

	Return:
		取得した背景色。

	Exception:
		背景色がシステムカラーならTreeViewException。
	*/
	COLOR backColor() {
		uint code=send(TVM_GETBKCOLOR, NONE, NONE);
		
		if(code != -1) {
			return COLOR(code);
		}
		
		throw new TreeViewException(Text("背景色はシステムカラー"));
	}
	/**
	背景色の設定。

	Params:
		cl = 色。
		     nullの場合はシステムカラー。
	*/
	void backColor(in COLOR* cl) {
		uint code;
		if(cl) {
			code = cl.code;
		} else {
			code = -1;
		}
		send(TVM_SETBKCOLOR, NONE, code);
	}
	///
	bool isSystemBackColor() {
		return send(TVM_GETBKCOLOR, NONE, NONE) == -1;
	}

	int count() {
		return send(TVM_GETCOUNT, NONE, NONE);
	}
	int countVisible() {
		return send(TVM_GETVISIBLECOUNT, NONE, NONE);
	}

	bool get(ref TREEITEM TreeItem) {
		return send(TVM_GETITEM, NONE, cast(LPARAM)TreeItem.ptr)
			? true
			: false
		;
	}
	ref TREEITEM get(TREE_HANDLE TreeHandle) {
		auto TreeItem=new TREEITEM;
		auto TextBuf=new wchar[TEXTLENGTH];

		with(TREEITEM.MASK) TreeItem.mask = TEXT | IMAGE | DATA | STATE | HANDLE | SELECTEDIMAGE | CHILDREN | INTEGRAL | DI_SETITEM;
		with(TREEITEM.STATE)TreeItem.stateMask = SELECTED | CUT | DROPHILITED | BOLD | EXPANDED | EXPANDEDONCE | EXPANDPARTIAL | FOCUSED | OVERLAYMASK | STATEIMAGEMASK | USERMASK;

		TreeItem.item = TreeHandle;
		TreeItem.text = TextBuf.ptr;
		TreeItem.textLength = TEXTLENGTH;

		get(*TreeItem);

		return *TreeItem;
	}
	TREE_ITEM insert(const ref TREEINSERTITEM InsertItem) {
		return cast(TREE_ITEM)send(TVM_INSERTITEM, NONE, cast(LPARAM)&InsertItem.TvInsertItem);
	}
	bool set(ref const(TREEITEM) TreeItem)
	in {
		assert(TreeItem.item);
	}
	body {
		return send(TVM_SETITEM, NONE, cast(LPARAM)&TreeItem.TvItem)
			? true
			: false
		;
	}
	

	///
	static enum NEXT {
		ROOT            = TVGN_ROOT           , /// ツリービューのルート（最も上の階層）のアイテムを取得します。
		NEXT            = TVGN_NEXT           , /// 指定されたアイテムの同じグループ内の次のアイテムを取得します。
		PREVIOUS        = TVGN_PREVIOUS       , /// 指定されたアイテムの同じグループ内の前のアイテムを取得します。
		PARENT          = TVGN_PARENT         , /// 指定されたアイテムの親アイテムを取得します。
		CHILD           = TVGN_CHILD          , /// 指定されたアイテムが持つ最初の子アイテムを取得します。
		FIRSTVISIBLE    = TVGN_FIRSTVISIBLE   , /// ツリービューウィンドウ内で見えている最初のアイテムを取得します。
		NEXTVISIBLE     = TVGN_NEXTVISIBLE    , /// 指定されたアイテムに続く次の見えているアイテムを取得します。指定されたアイテムはツリービューウィンドウ内で見えていなければなりません。
		PREVIOUSVISIBLE = TVGN_PREVIOUSVISIBLE, /// 指定されたアイテムの前にある見えているアイテムを取得します。指定されたアイテムはツリービューウィンドウ内で見えていなければなりません。
		DROPHILITE      = TVGN_DROPHILITE     , /// ドラッグ・アンド・ドロップのターゲットとなっているアイテムを取得します。
		CARET           = TVGN_CARET          , /// 現在選択されているアイテムを取得します。
		LASTVISIBLE     = TVGN_LASTVISIBLE    , /// Version 4.71 以上：最後に広げられたアイテムを取得します。
	}
	///
	TREE_ITEM getNode(TREE_ITEM Item, NEXT Next) {
		return cast(TREE_ITEM)send(TVM_GETNEXTITEM, cast(WPARAM)Next, cast(LPARAM)Item);
	}
	///
	TREE_ITEM nodeRoot(TREE_ITEM Item) {
		return getNode(Item, NEXT.ROOT);
	}
	///
	TREE_ITEM nodeParent(TREE_ITEM Item) {
		return getNode(Item, NEXT.PARENT);
	}
	///
	TREE_ITEM nodeNext(TREE_ITEM Item) {
		return getNode(Item, NEXT.NEXT);
	}
	///
	TREE_ITEM nodePrevious(TREE_ITEM Item) {
		return getNode(Item, NEXT.PREVIOUS);
	}
	///
	TREE_ITEM nodeChild(TREE_ITEM Item) {
		return getNode(Item, NEXT.CHILD);
	}
	///
	TREE_ITEM nodeCaret() {
		return getNode(TREEINSERTITEM.ROOT, NEXT.CARET);
	}
	///
	TREE_NODE nodeHead(TREE_NODE BaseNode) {
		return nodeChild(nodeParent(BaseNode));
	}
	///
	TREE_NODE nodeTail(TREE_NODE BaseNode) {
		TREE_NODE TailNode;
		auto TempNode = BaseNode;
		while(cast(bool)(TempNode = nodeNext(TempNode))) {
			TailNode = TempNode;
		}
		return TailNode;
	}

	COLOR textColor() {
		uint code=send(TVM_GETTEXTCOLOR, NONE, NONE);
		
		if(code != -1) {
			return COLOR(code);
		}
		
		throw new TreeViewException(Text("前景色はシステムカラー"));
	}
	///
	bool isSystemTextColor() {
		return send(TVM_GETTEXTCOLOR, NONE, NONE) == -1;
	}
	void textColor(COLOR* cl) {
		uint code;
		if(cl) {
			code = cl.code;
		} else {
			code = -1;
		}
		send(TVM_SETTEXTCOLOR, NONE, code);
	}

	private static enum IMAGE_TYPE {
		NORMAL = TVSIL_NORMAL,
		STATE  = TVSIL_STATE,
	}
	private ImageList GetSetImageList(bool GetList, ImageList NewImage, IMAGE_TYPE ImageType) {
		auto hImageList = cast(HIMAGELIST)(GetList
			? send(TVM_GETIMAGELIST, ImageType, NONE)
			: send(TVM_SETIMAGELIST, ImageType, cast(LPARAM)NewImage())
		);

		return hImageList
			? new ImageList(hImageList, false)
			: null
		;
	}
	/***/
	ImageList imageListNormal() {
		return GetSetImageList(true, null, IMAGE_TYPE.NORMAL);
	}
	/// ditto
	ImageList imageListNormal(ImageList NewImage) {
		return GetSetImageList(false, NewImage, IMAGE_TYPE.NORMAL);
	}
	/***/
	ImageList imageListState() {
		return GetSetImageList(true, null, IMAGE_TYPE.STATE);
	}
	/// ditto
	ImageList imageListState(ImageList NewImage) {
		return GetSetImageList(false, NewImage, IMAGE_TYPE.STATE);
	}

	bool sort(TREE_ITEM Item, bool Recurse) {
		return send(TVM_SORTCHILDREN, cast(WPARAM)Recurse, cast(LPARAM)Item)
			? true
			: false
		;
	}
	
	mixin(ItemStyleGetSetMixStr("itemDrag", q{TVS_DISABLEDRAGDROP}));
	mixin(ItemStyleGetSetMixStr("editLabel", q{TVS_EDITLABELS}));
	mixin(ItemStyleGetSetMixStr("button", q{TVS_HASBUTTONS}));
	mixin(ItemStyleGetSetMixStr("line", q{TVS_HASLINES}));
	mixin(ItemStyleGetSetMixStr("rootLine", q{TVS_LINESATROOT}));
	mixin(ItemStyleGetSetMixStr("noHideSelect", q{TVS_SHOWSELALWAYS}, true));
	mixin(ItemStyleGetSetMixStr("checkBox", q{TVS_CHECKBOXES}));
	

	///
	TREE_ITEM hitTest(ref TREEHITTEST TreeHitTese) {
		return cast(TREE_ITEM)send(TVM_HITTEST, NONE, cast(LPARAM)TreeHitTese.ptr);
	}

	/**
	ノードコピー。
	ABからコピー。

	Params:
		Src = コピー元。

		Parent = コピー先親アイテム。

		InsertAfter = Parentに対する位置。
	*/
	TREE_ITEM nodeCopy(in TREE_ITEM SrcItem, in TREE_ITEM Parent, in TREE_ITEM InsertAfter) {
		TREEINSERTITEM TreeInsertItem;
		wchar[TEXTLENGTH] TextBuf;

		with(TREEITEM.MASK) TreeInsertItem.item.mask = TEXT | IMAGE | DATA | STATE | HANDLE | SELECTEDIMAGE | CHILDREN | INTEGRAL | DI_SETITEM;
		with(TREEITEM.STATE)TreeInsertItem.item.stateMask = DROPHILITED | EXPANDED | EXPANDEDONCE | EXPANDPARTIAL;

		TreeInsertItem.item.item = SrcItem;
		TreeInsertItem.item.text = TextBuf.ptr;
		TreeInsertItem.item.textLength = TEXTLENGTH;

		enforce(get(*TreeInsertItem.item), new TreeViewException(Err.text));

		TreeInsertItem.parent = Parent;
		TreeInsertItem.insertAfter = InsertAfter;

		immutable TempItem = insert(TreeInsertItem);
		auto ChildItem = getNode(SrcItem, NEXT.CHILD);

		while(ChildItem) {
			ChildItem = nodeCopy(ChildItem, TempItem, TREEINSERTITEM.LAST);
			ChildItem = getNode(ChildItem, NEXT.NEXT);
		}
		
		return SrcItem;
	}

	/**
	ノード移動。

	親を範囲として(視覚上の)上下に移動。

	Params:
		TargetItem = 移動させるノード。
		             正常終了後は死ぬ。

		Count = 上の場合は負数、下の場合は正数を指定。

	Return:
		移動後のノード。

	In:
		Count != 0
	*/
	TREE_HANDLE nodeMove(in TREE_HANDLE TargetItem, int Count)
	in {
		assert(Count);
	}
	body {
		immutable Parent = nodeParent(TargetItem);
		immutable MOVE_UP = Count > 0;
		bool Last=false;
		TREE_HANDLE InsertAfter;
		TREE_HANDLE SelecteItem;

		if(MOVE_UP) {
			if(auto TempAfter=nodePrevious(nodePrevious(TargetItem))) {
				InsertAfter = TempAfter;
			} else {
				InsertAfter = TREEINSERTITEM.FIRST;
				Last=true;
			}
		} else {
			if(auto TempAfter=nodeNext(TargetItem)) {
				InsertAfter = TempAfter;
			} else {
				InsertAfter = TREEINSERTITEM.LAST;
				Last=true;
			}
		}
		
		nodeCopy(TargetItem, Parent, InsertAfter);
		
		if(MOVE_UP) {
			if(Last) {
				SelecteItem = nodeHead(TargetItem);
			} else {
				SelecteItem = nodeNext(InsertAfter);
			}
		} else {
			if(Last) {
				SelecteItem = nodeTail(TargetItem);
			} else {
				SelecteItem = nodeNext(InsertAfter);
			}
		}
		
		del(TargetItem);
		
		select(SelecteItem, TreeView.SELECT.CARET);

		return SelecteItem;
	}

	
	///
	enum SELECT {
		NONE=0,
		CARET          = TVGN_CARET,
		DROPHILITE     = TVGN_DROPHILITE,
		FIRSTVISIBLE   = TVGN_FIRSTVISIBLE,
		NOSINGLEEXPAND = TVSI_NOSINGLEEXPAND,
	}
	///
	bool select(TREE_HANDLE TreeHandle, SELECT Select) {
		return cast(bool)send(TVM_SELECTITEM, Select, cast(WPARAM)TreeHandle);
	}

}
unittest {
	assert(TREEITEM.sizeof == TVITEMEX.sizeof, "設計が狂う");
}
///
struct TREEITEM {
	TVITEMEX TvItem;
	mixin(SMixInStructHiddenOriginal!(TVITEMEX)(`TvItem`));

	static enum MASK {
		TEXT          = TVIF_TEXT         , /// pszText, cchTextMax
		IMAGE         = TVIF_IMAGE        , /// iImage
		DATA          = TVIF_PARAM        , /// lParam
		STATE         = TVIF_STATE        , /// state, stateMask
		HANDLE        = TVIF_HANDLE       , /// hItem
		SELECTEDIMAGE = TVIF_SELECTEDIMAGE, /// iSelectedImage
		CHILDREN      = TVIF_CHILDREN     , /// cChildren
		INTEGRAL      = TVIF_INTEGRAL     , /// iIntegral
		DI_SETITEM    = TVIF_DI_SETITEM   , /// ツリービューコントロールが与えられた情報を保持し、再度情報を要求しないようにします。このフラグは TVN_GETDISPINFO 通知メッセージを処理する場合にのみ有効です。

		PARAM            = DATA,
		USERDATA         = PARAM        , /// lParam
	}
	mixin(StructGetSet!(MASK)("mask", q{TvItem.mask}));

	mixin(StructGetSet!(TREE_ITEM)("item", q{TvItem.hItem}));

	static enum STATE {
		SELECTED       = TVIS_SELECTED       , /// アイテムは選択されています。
		CUT            = TVIS_CUT            , /// アイテムはカット・アンド・ペーストの操作の一部として選択されています。
		DROPHILITED    = TVIS_DROPHILITED    , /// アイテムはドラッグ・アンド・ドロップのターゲットとして選択されています。
		BOLD           = TVIS_BOLD           , /// アイテムは太字表示されています。
		EXPANDED       = TVIS_EXPANDED       , /// 子アイテムのリストが展開されています。このフラグは子アイテムを持つ親アイテムのみに適用されます。
		EXPANDEDONCE   = TVIS_EXPANDEDONCE   , /// 少なくとも一度以上、アイテムが持つ子アイテムのリストが展開されたことがあることを示します。このフラグは子アイテムを持つ親アイテムのみに適用されます。 TVM_EXPAND メッセージによってこのフラグがセットされた親アイテムに対して、 TVN_ITEMEXPANDING や TVN_ITEMEXPANDED 通知メッセージは発生しません。 メッセージで、 TVE_COLLAPSE と TVE_COLLAPSERESET フラグを指定したときにこのフラグはリセットされます。
		EXPANDPARTIAL  = TVIS_EXPANDPARTIAL  , /// Version 4.70 以上： アイテムが部分的に展開されています。
		FOCUSED        = TVIS_FOCUSED        , /// 項目にフォーカスがある
		OVERLAYMASK    = TVIS_OVERLAYMASK    , /// 項目のオーバーレイイメージが描画時に含められる
		STATEIMAGEMASK = TVIS_STATEIMAGEMASK , /// 項目の状態イメージが描画時に含められる
		USERMASK       = TVIS_USERMASK       , /// TVISSTATEIMAGEMAS と同じ
	}


	/// あ～もう知らん
	union STATUS {
		UINT Status;
		
		mixin(bitfields!(
			STATE, "State",       8,
			int,   "NormalIndex", 4,
			int,   "StateIndex",  4
		));

		static STATUS opCall(UINT StatusArg) {
			STATUS Status;
			Status.Status = StatusArg;
			return Status;
		}
	}

	STATUS status() {
		return STATUS(TvItem.state);
	}
	void status(STATUS Status) {
		TvItem.state = Status.Status;
	}
	
	mixin(StructGetSet!(STATE)("stateMask", q{TvItem.stateMask}));
	///
	const Text text() {
		return Text(cast(wchar*)TvItem.pszText);
	}
	///
	void text(wchar* s) {
		TvItem.pszText = s;
	}
	///
	wchar* text(in Text t) {
		return TvItem.pszText = t.ptr;
	}
	bool textCallBack() {
		return TvItem.pszText == LPSTR_TEXTCALLBACK;
	}
	void textCallBack(bool CallBack) {
		TvItem.pszText = CallBack ? LPSTR_TEXTCALLBACK: null;
	}
	mixin(StructGetSet!(int)("textLength", q{TvItem.cchTextMax}));

	mixin(StructGetSetCallBack!(int)("normalImageIndex", "normalImageCallBack", q{TvItem.iImage}, q{I_IMAGECALLBACK}));

	mixin(StructGetSetCallBack!(int)("selectedImageIndex", "selectedImageCallBack", q{TvItem.iSelectedImage}, q{I_IMAGECALLBACK}));
	
	mixin(StructGetSetCallBack!(int)("children", "childrenCallBack", q{TvItem.cChildren}, q{I_CHILDRENCALLBACK}));

	mixin(StructGetSet!(void*)("data", q{TvItem.lParam}));
	mixin(StructGetSet!(void*)("integral", q{TvItem.iIntegral}));
}

///
struct TREEINSERTITEM {
	TVINSERTSTRUCT TvInsertItem;
	mixin(SMixInStructHiddenOriginal!(TVINSERTSTRUCT)(`TvInsertItem`));

	mixin(StructGetSet!(TREE_ITEM)("parent", q{TvInsertItem.hParent}));
	
	///
	static enum : TREE_NODE {
		ROOT  = TVI_ROOT , /// アイテムをルートアイテムとして追加します。
		FIRST = TVI_FIRST, /// アイテムをリストの最初の位置に挿入します。
		LAST  = TVI_LAST , /// アイテムをリストの最後の位置に挿入します。
		SORT  = TVI_SORT , /// アイテムをアルファベット順にリストに挿入します。
	}
	mixin(StructGetSet!(TREE_NODE)("insertAfter", q{TvInsertItem.hInsertAfter}));


	TREEITEM* item() {
		return cast(TREEITEM*)&TvInsertItem.itemex;
	}
	
}

///
struct TREEHITTEST {
	TVHITTESTINFO TvHitTestInfo;
	mixin(SMixInStructHiddenOriginal!(TVHITTESTINFO)(`TvHitTestInfo`));

	ref POINT point() {
		return TvHitTestInfo.pt;
	}

	enum FLAGS {
		ABOVE           = TVHT_ABOVE           , /// Above the client area.
		BELOW           = TVHT_BELOW           , /// Below the client area.
		NOWHERE         = TVHT_NOWHERE         , /// In the client area, but below the last item.
		ONITEM          = TVHT_ONITEM          , /// On the bitmap or label associated with an item.
		ONITEMBUTTON    = TVHT_ONITEMBUTTON    , /// On the button associated with an item.
		ONITEMICON      = TVHT_ONITEMICON      , /// On the bitmap associated with an item.
		ONITEMINDENT    = TVHT_ONITEMINDENT    , /// In the indentation associated with an item.
		ONITEMLABEL     = TVHT_ONITEMLABEL     , /// On the label (string) associated with an item.
		ONITEMRIGHT     = TVHT_ONITEMRIGHT     , /// In the area to the right of an item.
		ONITEMSTATEICON = TVHT_ONITEMSTATEICON , /// On the state icon for a tree view item that is in a user-defined state.
		TOLEFT          = TVHT_TOLEFT          , /// To the left of the client area.
		TORIGHT         = TVHT_TORIGHT         , /// To the right of the client area.
	}
	mixin(StructGetSet!(FLAGS)("flags", q{TvHitTestInfo.flags}));
	mixin(StructGetSet!(TREE_ITEM)("item", q{TvHitTestInfo.hItem}));
	
}

///
typedef UINT TREE_ACTION;

///
struct TREEVIEWMESSAGE {
	NMTREEVIEW NmTreeView;
	mixin(SMixInStructHiddenOriginal!(NMTREEVIEW)(`NmTreeView`));
	
	const NOTIFY* notify() {
		return cast(NOTIFY*)&NmTreeView.hdr;
	}

	enum ACTION: TREE_ACTION {
		UNKNOWN  = TVC_UNKNOWN,
		MOUSE    = TVC_BYMOUSE,
		KEYBOARD = TVC_BYKEYBOARD,
	}
	TREEITEM* itemOld() {
		return cast(TREEITEM*)&NmTreeView.itemOld;
	}
	TREEITEM* itemNew() {
		return cast(TREEITEM*)&NmTreeView.itemNew;
	}
	ref POINT dragPoint() {
		return NmTreeView.ptDrag;
	}
}


