/**
デートタイムピッカー。
*/
module nemuxi.negui.control.time.datetimepicker;

debug import std.stdio: wl = writefln, pl = printf;
debug(datetimepicker) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.event;
public import nemuxi.negui.control.control;
public import nemuxi.negui.system.timer;

/***/
abstract class DateTimePicker: Control, ICommonControl {
	mixin CommonControl;
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = DATETIMEPICK_CLASS;
		super(NeGuiInfo);
	}
	static enum MSG {
		DATETIMECHANGE = DTN_DATETIMECHANGE,
	}
	
	/// Bugs: エラー処理未実装
	DateTime value() {
		SYSTEMTIME SystemTime=void;
		send(DTM_GETSYSTEMTIME, NONE, cast(LPARAM)&SystemTime);
		auto date=new DateTime(&SystemTime);
		return date;
	}
	void value(DateTime Value) {
		send(DTM_SETSYSTEMTIME, GDT_VALID, cast(LPARAM)Value.ptr);
	}
}

/***/
class DatePicker: DateTimePicker {
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= DTS_SHORTDATECENTURYFORMAT;
		
		super(NeGuiInfo);
	}
	alias DateTimePicker.value value;
	override DateTime value() {
		auto Value=super.value();
		Value.mask = DateTime.MASK.DATE;
		return Value;
	}
}
/***/
class TimePicker: DateTimePicker {
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= DTS_TIMEFORMAT;
		
		super(NeGuiInfo);
	}
	alias DateTimePicker.value value;
	override DateTime value() {
		auto Value=super.value();
		Value.mask = DateTime.MASK.TIME;
		return Value;
	}
}

