﻿/**
あ
*/
module nemuxi.negui.control.listbox.listview;

debug import std.stdio: wl = writefln, pl = printf;
debug(listview) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.draw.color;
import nemuxi.negui.window.window;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.listbox.header;
public import nemuxi.negui.draw.imagelist;
public import nemuxi.negui.keyboard.keyboard;

enum {
	LVIS_DRAPHILITED = 0x0008,
}

unittest {
	assert(LVCOLUMN.sizeof == LISTCOLUMN.sizeof);
}
struct LISTCOLUMN {
	LVCOLUMN LvColumn;
	///
	static enum MASK {
		//FMT     = LVCF_FMT    , /// fmt
		POSITION = LVCF_FMT    , /// fmt
		WIDTH    = LVCF_WIDTH  , /// cx
		TEXT     = LVCF_TEXT   , /// pszText
		SUBITEM  = LVCF_SUBITEM, /// iSubItem
		IMAGE    = LVCF_IMAGE  , /// Version 4.70 以降： iImage
		ORDER    = LVCF_ORDER  , /// Version 4.70 以降： iOrder
	}
	///
	MASK mask() {
		return cast(MASK)LvColumn.mask;
	}
	///
	void mask(MASK Mask) {
		LvColumn.mask = Mask;
	}
	
	///
	static enum POSITION {
		LEFT            = LVCFMT_LEFT           , /// テキストが左に配置されます。
		RIGHT           = LVCFMT_RIGHT          , /// テキストが右に配置されます。
		CENTER          = LVCFMT_CENTER         , /// テキストが中央に配置されます。
		IMAGE           = LVCFMT_IMAGE          , /// Version 4.70 以降： アイテムはイメージリストのイメージを表示します。
		BITMAP_ON_RIGHT = LVCFMT_BITMAP_ON_RIGHT, /// Version 4.70 以降： ビットマップをアイテムの右側に表示します。これは、ヘッダアイテムに割り当てられたイメージリストのイメージには影響しません。
		COL_HAS_IMAGES  = LVCFMT_COL_HAS_IMAGES , /// Version 4.70 以降： ヘッダアイテムはイメージリスト中のイメージを含みます。
	}

	mixin(StructGetSet!(POSITION)("position", q{LvColumn.fmt}));
	
	///
	mixin(StructGetSet!(uint)("px", q{LvColumn.cx}));

	///
	wchar* text() {
		return LvColumn.pszText;
	}
	///
	void text(wchar* s) {
		LvColumn.pszText = s;
	}
	///
	wchar* text(Text t) {
		return LvColumn.pszText = t.ptr;
	}

	mixin(StructGetSet!(int)("textMax", q{LvColumn.cchTextMax}));
	
	///
	int subIndex() {
		return LvColumn.iSubItem;
	}
	///
	void subIndex(int Index) {
		LvColumn.iSubItem = Index;
	}
	///
	int imageIndex() {
		return LvColumn.iImage;
	}
	///
	void imageIndex(int Index) {
		LvColumn.iImage = Index;
	}
	///
	int order() {
		return LvColumn.iOrder;
	}
	///
	void order(int Order) {
		LvColumn.iOrder = Order;
	}
}

unittest {
	assert(LVITEM.sizeof == LISTITEM.sizeof);
}

/**
History:
	1.00β15:
		[S] 別構造体内でT出来なかったから外に出す。
*/
static enum LISTITEM_STATE {
	CUT            = LVIS_CUT           , /// 切り取りと貼り付け操作に対してマークされる
	DRAPHILITED    = LVIS_DRAPHILITED   , /// 切り取りと貼り付け操作の対象として強調表示される
	FOCUSED        = LVIS_FOCUSED       , /// フォーカスをもっている
	OVERLAYMASK    = LVIS_OVERLAYMASK   , /// オーバーレイイメージインデックスが含まれているかどうか判定する
	SELECTED       = LVIS_SELECTED      , /// 選択されている
	STATEIMAGEMASK = LVIS_STATEIMAGEMASK, /// 状態イメージが関連付けられているかどうか判定する
}

struct LISTITEM {
	LVITEM LvItem;
	mixin(SMixInStructHiddenOriginal!(LISTITEM)(q{LvItem}));

	///
	static enum MASK {
		TEXT        = LVIF_TEXT       , /// pszText
		IMAGE       = LVIF_IMAGE      , /// iImage
		//PARAM       = LVIF_PARAM      , /// lParam
		DATA        = LVIF_PARAM      , /// lParam
		STATE       = LVIF_STATE      , /// state
		INDENT      = LVIF_INDENT     , /// Version 4.70 以降： iIndent
		GROUPID     = LVIF_GROUPID    , /// Version 6.0 以降： iGroupID
		COLUMNS     = LVIF_COLUMNS    , /// Version 6.0 以降： cColumns
		NORECOMPUTE = LVIF_NORECOMPUTE, /// Version 4.70 以降： コントロールは LVM_GETITEM メッセージを受け取ったときに、テキスト情報を取得するのに LVN_GETDISPINFO 通知メッセージを発生させません。代わりに、 pszText メンバに -1 (LPSTR_TEXTCALLBACK) を格納します。
		DI_SETITEM  = LVIF_DI_SETITEM , /// システムは、要求されたリストアイテムの情報を格納しておき、後で再び情報を求めません。このフラグは LVN_GETDISPINFO 通知メッセージでのみ使用されます。
	}
	mixin(StructGetSet!(MASK)("mask", q{LvItem.mask}));
	///
	int index() {
		return LvItem.iItem;
	}
	///
	void index(int Index) {
		LvItem.iItem = Index;
	}
	///
	int subIndex() {
		return LvItem.iSubItem;
	}
	///
	void subIndex(int Index) {
		LvItem.iSubItem = Index;
	}
	alias LISTITEM_STATE STATE;
	///
	STATE state() {
		return cast(STATE)LvItem.state;
	}
	///
	void state(STATE State) {
		LvItem.state = State;
	}
	///
	STATE stateMask() {
		return cast(STATE)LvItem.stateMask;
	}
	///
	void stateMask(STATE State) {
		LvItem.stateMask = State;
	}
	///
	wchar* text() {
		return LvItem.pszText;
	}
	///
	void text(wchar* s) {
		LvItem.pszText = s;
	}
	///
	wchar* text(Text t) {
		return LvItem.pszText = t.ptr;
	}
	bool textCallBack() {
		return LvItem.pszText == LPSTR_TEXTCALLBACK;
	}
	void textCallBack(bool CallBack) {
		LvItem.pszText = CallBack ? LPSTR_TEXTCALLBACK: null;
	}
	mixin(StructGetSet!(int)("textMax", q{LvItem.cchTextMax}));
	
	///
	int imageIndex() {
		return LvItem.iImage;
	}
	void imageIndex(int Index) {
		LvItem.iImage = Index;
	}
	void* data() {
		return cast(void*)LvItem.lParam;
	}
	void data(void* Data) {
		LvItem.lParam = cast(LPARAM)Data;
	}
	int indent() {
		return LvItem.iIndent;
	}
	void indent(int Indent) {
		LvItem.iIndent = Indent;
	}
	int groupID() {
		return LvItem.iGroupId;
	}
	void groupID(int GroupID) {
		LvItem.iGroupId = GroupID;
	}
	uint columns() {
		return LvItem.cColumns;
	}
	void columns(uint Columns) {
		LvItem.cColumns = Columns;
	}
	uint* columsAddress() {
		return LvItem.puColumns;
	}
	void columsAddress(uint* ColumsAddress) {
		LvItem.puColumns = ColumsAddress;
	}
}

struct LISTVIEWDRAW {
	NMLVCUSTOMDRAW CustomDraw;
	mixin(SMixInStructHiddenOriginal!(CUSTOMDRAW)(q{CustomDraw}));

	COLOR textColor() {
		return COLOR(CustomDraw.clrText);
	}
	void textColor(COLOR Color) {
		CustomDraw.clrText = Color.code;
	}
	
	COLOR backColor() {
		return COLOR(CustomDraw.clrTextBk);
	}
	void backColor(COLOR Color) {
		CustomDraw.clrTextBk = Color.code;
	}
	mixin(StructGetSet!(int)("subIndex", q{CustomDraw.iSubItem}));
	
}

struct LISTHITTEST {
	LVHITTESTINFO LvHitTest;
	mixin(SMixInStructHiddenOriginal!(LVHITTESTINFO)(q{LvHitTest}));
}


struct LISTFIND {
	LVFINDINFO LvFindInfo;
	mixin(SMixInStructHiddenOriginal!(LVFINDINFO)(q{LvFindInfo}));

	enum FLAGS {
		DATA      = LVFI_PARAM,     /// lParam メンバに基づいて検索します。 LVITEM 構造体の lParam メンバがこの値と同じアイテムを検索します。このフラグが指定された場合は、他のフラグは無視されます。
		TEXT_ALL  = LVFI_STRING,    /// アイテムの文字列に基づいて検索します。アイテムの持つ文字列が、 psz メンバで示される文字列と完全に一致するアイテムを検索します。
		TEXT      = LVFI_PARTIAL,   /// アイテムの文字列が、 psz メンバで示された文字列で始まるアイテムを検索します。
		WRAP      = LVFI_WRAP,      /// 該当するアイテムが見つからない場合は、最初に戻って検索を続けます。
		NEARESTXY = LVFI_NEARESTXY, /// pt メンバで指定された位置から vkDirection メンバで指定された方向に最も近い位置にあるアイテムを検索します。
	}
	mixin(StructGetSet!(FLAGS)("flags", q{LvFindInfo.flags}));
	
	mixin(StructGetSet!(void*)("data", q{LvFindInfo.lParam}));

	alias LvFindInfo.lParam point;
	
	mixin(StructGetSet!(KEY)("direction", q{LvFindInfo.vkDirection}));
	
}

struct LISTVIEWMESSAGE {
	NMLISTVIEW NmListView;
	mixin(SMixInStructHiddenOriginal!(NMLISTVIEW)(q{NmListView}));
	const NOTIFY* notify() {
		return cast(NOTIFY*)&NmListView.hdr;
	}
	mixin(StructGetSet!(int)("item", q{NmListView.iItem}));
	mixin(StructGetSet!(int)("subItem", q{NmListView.iSubItem}));

	mixin(StructGetSet!(LISTITEM.STATE)("stateNew", q{NmListView.uNewState}));
	mixin(StructGetSet!(LISTITEM.STATE)("stateOld", q{NmListView.uOldState}));
	mixin(StructGetSet!(LISTITEM.STATE)("stateMask", q{NmListView.uChanged}));

	alias NmListView.ptAction point;
	
	mixin(StructGetSet!(void*)("data", q{NmListView.lParam}));
}

/**
History:
	1.00β17:
		新規追加。
*/
struct LISTKEYDOWN {
	NMLVKEYDOWN NmLVKeyDown;
	mixin(SMixInStructHiddenOriginal!(NMLVKEYDOWN)(q{NmLVKeyDown}));
	const NOTIFY* notify() {
		return cast(NOTIFY*)&NmLVKeyDown.hdr;
	}

	mixin(StructGetSet!(KEY)("key", q{NmLVKeyDown.wVKey}));
}

/**
*/
class ListView: Control, ICommonControl, IOwnerDraw, INoHideSelect {
	mixin CommonControl;
	
	enum EVENT : MESSAGETYPE {
		END_LABEL_EDIT  = LVN_ENDLABELEDIT,
		BEGINDRAG       = LVN_BEGINDRAG,
		BEGINLABELEDIT  = LVN_BEGINLABELEDIT,
		COLUMNCLICK     = LVN_COLUMNCLICK,
		DELETEALLITEMS  = LVN_DELETEALLITEMS,
		DELETEITEM      = LVN_DELETEITEM,
		GETDISPINFO     = LVN_GETDISPINFO,
		GETINFOTIP      = LVN_GETINFOTIP,
		INSERTITEM      = LVN_INSERTITEM,
		ITEMCHANGED     = LVN_ITEMCHANGED,
		ITEMACTIVATE    = LVN_ITEMACTIVATE,
		ITEMCHANGING    = LVN_ITEMCHANGING,
		KEYDOWN         = LVN_KEYDOWN,
		MARQUEEBEGIN    = LVN_MARQUEEBEGIN,
		ODCACHEHINT     = LVN_ODCACHEHINT,
		ODFINDITEM      = LVN_ODFINDITEM,
		ODSTATECHANGED  = LVN_ODSTATECHANGED,
		SETDISPINFO     = LVN_SETDISPINFO,
	}
	
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = WC_LISTVIEW;
		
		super(NeGuiInfo);
		clientEdge=true;
		noHideSelect=true;
	}
	
	mixin(ItemStyleGetSetMixStr("ownerDraw", q{LVS_OWNERDRAWFIXED}, true));
	mixin(ItemStyleGetSetMixStr("noHideSelect", q{LVS_SHOWSELALWAYS}, true));
	mixin(ItemStyleGetSetMixStr("noHeader", q{LVS_NOCOLUMNHEADER}, false));
	//mixin(ItemStyleGetSetMixStr("noHeaderEvent", q{LVS_NOSORTHEADER}, false));
	mixin(ItemStyleGetSetMixStr("single", q{LVS_SINGLESEL}, false));
	mixin(ItemStyleGetSetMixStr("shareImageLists", q{LVS_SHAREIMAGELISTS}, false));
	
	enum TYPE {
		SMALLICON  = LVS_SMALLICON, /// 小さいアイコン
		NORMALICON = LVS_ICON,      /// 大きいアイコン
		//BUTTON     = LVS_BUTTON,    /// 大きいアイコンで項目アイコンをボタン風にする
		LIST       = LVS_LIST,      /// 一覧表示
		REPORT     = LVS_REPORT,    /// 詳細表示
	}
	mixin(ItemStyleGetSetMixStrEx!(TYPE, DWORD)(
		"type", false, [
		q{TYPE.SMALLICON}, q{TYPE.NORMALICON}, q{TYPE.LIST}, q{TYPE.REPORT},
		q{LVS_SMALLICON},  q{LVS_ICON},        q{LVS_LIST}, q{LVS_REPORT}
	]));
	


	DWORD listStyle() {
		return send(LVM_GETEXTENDEDLISTVIEWSTYLE, NONE, NONE);
	}
	DWORD listStyle(DWORD StyleMask, DWORD ExStyle) {
		return send(LVM_SETEXTENDEDLISTVIEWSTYLE, StyleMask, ExStyle);
	}
	
	class ListHeader: Header {
		override this(HWND hWnd) {
			super(hWnd);
		}
	}
	Header header() {
		return new ListHeader(cast(HANDLE)send(LVM_GETHEADER, NONE, NONE));
	}

	/// アイテム全削除
	void clear() {
		super.send(LVM_DELETEALLITEMS, NONE, NONE);
	}

	/**
	カラムの削除。

	Params:
		Index = 削除するカラム。
		        0番目は消せない。

	In:
		Indexは1以上。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool delColumn(WPARAM Index)
	in {
		assert(Index > 0);
	}
	body {
		return super.send(LVM_DELETECOLUMN, Index, NONE)
			? true
			: false
		;
	}

	/**
	指定アイテムの削除。

	Params:
		Index = 削除するアイテム

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool del(WPARAM Index) {
		return super.send(LVM_DELETEITEM, Index, NONE)
			? true
			: false
		;
	}

	private uint BackColor() {
		return super.send(LVM_GETBKCOLOR, NONE, NONE);
	}
	private bool IsBackColor(uint code) {
		return CLR_NONE != code;
	}
	/**
	背景色の有無を判定。

	Return:
		背景色が設定されていればtrue、設定されていなければfalse。
	*/
	bool isBackColor() {
		return IsBackColor(BackColor());
	}
	/**
	背景色の取得。

	Return:
		取得した背景色。

	Exception:
		背景色が設定されていなければNemuxiException。
	*/
	COLOR backColor() {
		uint code=BackColor();
		
		if(IsBackColor(code)) {
			return COLOR(code);
		}
		
		throw new NemuxiException("背景色未設定");
	}
	/**
	背景色の設定。

	Params:
		cl = 色。
		     nullの場合は背景色を持たない。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool backColor(COLOR* cl) {
		uint code;
		if(cl) {
			code = cl.code;
		} else {
			code = CLR_NONE;
		}
		return send(LVM_SETBKCOLOR, NONE, code)
			? true
			: false
		;
	}
	/**
	アイテムの取得。

	Params:
		ListItem = アイテムの値を格納する構造体。
		           取得する値のための情報を格納しておく。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool get(ref LISTITEM ListItem) {
		return super.send(LVM_GETITEM, NONE, cast(WPARAM)&ListItem.LvItem)
			? true
			: false
		;
	}
	/**
	アイテムの総数を取得。

	Return:
		アイテム数。
	*/
	int count() {
		return super.send(LVM_GETITEMCOUNT, NONE, NONE);
	}
	/**
	*/
	COLOR textColor() {
		return COLOR(send(LVM_GETTEXTCOLOR, NONE, NONE));
	}
	/**
	*/
	bool textColor(COLOR cl) {
		return send(LVM_SETTEXTCOLOR, NONE, cl.code)
			? true
			: false
		;
	}
	/**
	*/
	COLOR textBackColor() {
		return COLOR(send(LVM_GETTEXTBKCOLOR, NONE, NONE));
	}
	/**
	*/
	bool textBackColor(COLOR cl) {
		return send(LVM_SETTEXTBKCOLOR, NONE, cl.code)
			? true
			: false
		;
	}
	/**
	カラムの挿入。

	Params:
		Index = 新しいカラムを挿入する位置。
		        0基準。

		ListColumn = カラム情報。

	Return:
		成功すれば実際のカラムの位置を返す。

	Exception:
		失敗時にNemuxiException。
	*/
	int insertColumn(int Index, LISTCOLUMN* ListColumn)
	in {
		assert(ListColumn);
	}
	body {
		auto pos = send(LVM_INSERTCOLUMN, Index, cast(LPARAM)&ListColumn.LvColumn);

		if(pos == -1) {
			throw new NemuxiException("カラム挿入失敗");
		}

		return pos;
	}
	/**
	アイテムの挿入。

	Params:
		ListItem = アイテム情報。

	Return:
		成功すれば実際のアイテムの位置を返す。

	Exception:
		失敗時にNemuxiException。
	*/
	size_t insertItem(LISTITEM* ListItem)
	in {
		assert(ListItem);
	}
	body {
		auto pos = send(LVM_INSERTITEM, NONE, cast(LPARAM)&ListItem.LvItem);

		if(pos == -1) {
			throw new NemuxiException("アイテム挿入失敗" ~ Err.toString);
		}

		return pos;
	}
	private static enum IMAGE_TYPE {
		NORMAL= LVSIL_NORMAL, /// 通常のアイコン
		SMALL = LVSIL_SMALL,  /// 小さいアイコン
		STATE = LVSIL_STATE,  /// 状態
	}
	private ImageList SetImageList(ImageList NewImage, IMAGE_TYPE ImageType) {
		auto hImageList = cast(HIMAGELIST)send(LVM_SETIMAGELIST, ImageType, cast(LPARAM)NewImage());
		
		return hImageList
			? new ImageList(hImageList, false)
			: null
		;
	}

	/**
	History:
		1.00β15:
			新規作成。
	*/
	private ImageList GetImageList(IMAGE_TYPE ImageType) {
		auto hImageList = cast(HIMAGELIST)send(LVM_GETIMAGELIST, ImageType, NONE);
		
		return hImageList
			? new ImageList(hImageList, false)
			: null
		;
	}
	
	/***/
	ImageList imageListNormal(ImageList NewImage) {
		return SetImageList(NewImage, IMAGE_TYPE.NORMAL);
	}
	/// ditto
	ImageList imageListSmall(ImageList NewImage) {
		return SetImageList(NewImage, IMAGE_TYPE.SMALL);
	}
	/// ditto
	ImageList imageListState(ImageList NewImage) {
		return SetImageList(NewImage, IMAGE_TYPE.STATE);
	}
	/**
	History:
		1.00β15:
			新規作成
	*/
	ImageList imageListNormal() {
		return GetImageList(IMAGE_TYPE.NORMAL);
	}
	/// ditto
	ImageList imageListSmall() {
		return GetImageList(IMAGE_TYPE.SMALL);
	}
	/// ditto
	ImageList imageListState() {
		return GetImageList(IMAGE_TYPE.STATE);
	}

	
	/**
	アイテムの設定。

	Params:
		ListItem = 設定するアイテム情報。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool set(LISTITEM* ListItem) {
		return send(LVM_SETITEM, NONE, cast(LPARAM)&ListItem.LvItem)
			? true
			: false
		;
	}
	bool status(int Index, LISTITEM.STATE Status, LISTITEM.STATE Mask) {
		LISTITEM ListItem;
		ListItem.index     = Index;
		ListItem.mask      = LISTITEM.MASK.STATE;
		ListItem.state     = Status;
		ListItem.stateMask = Mask;
		
		return set(&ListItem);
	}
	bool select(int Index, bool Select) {
		immutable LISTITEM.STATE Mask = (Index != -1 ? LISTITEM.STATE.FOCUSED: cast(LISTITEM.STATE)0) | LISTITEM.STATE.SELECTED;
		immutable LISTITEM.STATE Status = Select ? Mask: cast(LISTITEM.STATE)0;
		
		if(Index != -1) {
			return status(Index, Status, Mask);
		} else {
			bool ret=true;
			foreach(i; 0 .. count) {
				ret &= status(i, Status, Mask);
			}
			return ret;
		}
	}
	
	bool get(LISTITEM* ListItem) {
		return cast(bool)send(LVM_GETITEM, NONE, cast(LPARAM)&ListItem.LvItem);
	}

	/**
	History:
		1.00β15:
			新規作成。
	*/
	bool get(int Index, LISTCOLUMN* ListColumn) {
		return cast(bool)send(LVM_GETCOLUMN, Index, cast(LPARAM)&ListColumn.LvColumn);
	}
	/**
	History:
		1.00β15:
			新規作成。
	*/
	bool set(int Index, LISTCOLUMN* ListColumn) {
		return cast(bool)send(LVM_SETCOLUMN, Index, cast(LPARAM)&ListColumn.LvColumn);
	}

	/**
	History:
		1.00β15:
			新規作成。
	*/
	enum NEXT {
		ALL     = LVNI_ALL,     /// 指定されたアイテムの後に続くアイテムを検索します。（デフォルト）
		ABOVE   = LVNI_ABOVE,   /// 指定されたアイテムの上にあるアイテムを検索します。
		BELOW   = LVNI_BELOW,   /// 指定されたアイテムの下にあるアイテムを検索します。
		TOLEFT  = LVNI_TOLEFT,  /// 指定されたアイテムの左にあるアイテムを検索します。
		TORIGHT = LVNI_TORIGHT, /// 指定されたアイテムの右にあるアイテムを検索します。

		FOCUSED    = LVNI_FOCUSED,     /// フォーカスを持つアイテムを検索します。
		SELECTED   = LVNI_SELECTED,    /// 選択されているアイテムを検索します。
		CUT        = LVNI_CUT,         /// カット・アンド・ペーストの対象としてマークされているアイテムを検索します。
		DROPHILITE = LVNI_DROPHILITED, /// ドラッグ・アンド・ドロップのターゲットとしてハイライト表示されているアイテムを検索します。
	}
	/**
	History:
		1.00β15:
			新規作成。
	*/
	int next(NEXT Next, int StartIndex=-1) {
		return send(LVM_GETNEXTITEM, StartIndex, cast(LPARAM)Next);
	}
	int select(int StartIndex=-1) {
		return next(NEXT.ALL | NEXT.SELECTED, StartIndex);
	}

	
	/**
	History:
		1.00β15:
			新規作成。
	*/
	int find(const ref LISTFIND ListFind, int StartIndex=-1) {
		return send(LVM_FINDITEM, StartIndex, cast(LPARAM)ListFind.ptr);
	}
}

