﻿/**
あ
*/
module nemuxi.negui.control.listbox.listbox;

debug import std.stdio: wl = writefln, pl = printf;

debug(listbox) void main() {}

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.control.control;

///
class ListBoxException: ControlException {
	mixin MixInNeGuiException;
}

/**
一人だけ異質だ。
*/
class ListBox: Control, IListBox, INotify, IOwnerDraw {
	///
	enum EVENT: MESSAGETYPE {
		ERRSPACE  = LBN_ERRSPACE,  // メモリの割り当てに失敗した
		SELCHANGE = LBN_SELCHANGE, // 選択状態が変更された
		DBLCLK    = LBN_DBLCLK,    // 項目がダブルクリックされた
		SELCANCEL = LBN_SELCANCEL, // ユーザが選択をキャンセルした
		SETFOCUS  = LBN_SETFOCUS,  // キーボードフォーカスを受け取った
		KILLFOCUS = LBN_KILLFOCUS, // キーボードフォーカスを失った
	}

	protected override this(HWND hWnd) {
		super(hWnd);
	}
	///
	enum SELECT {
		SINGLE   = 0,               /// 
		MULTI    = LBS_MULTIPLESEL, /// 
		READONRY = LBS_NOSEL,       /// 
	}
	enum TYPE {
		LIST   = 0,               /// 
		COLUMN = LBS_MULTICOLUMN, /// 
	}
	
	this(NeGui Owner, ITEM_ID Id, SELECT Select=SELECT.SINGLE, TYPE Type=TYPE.LIST) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo, Select, Type);
	}
	override this(GUIINFO* NeGuiInfo, SELECT Select, TYPE Type) {
		NeGuiInfo.ClassName =  "LISTBOX";
		
		NeGuiInfo.Style |= Select;
		if(Select == SELECT.MULTI) {
			NeGuiInfo.Style |= LBS_EXTENDEDSEL;
		}
		if(Type) {
			NeGuiInfo.Style |= Type | WS_HSCROLL;
		} else {
			NeGuiInfo.Style |= WS_VSCROLL;
		}
		NeGuiInfo.Style |= LBS_NOINTEGRALHEIGHT | LBS_NOTIFY;
		
		super(NeGuiInfo);

		clientEdge=true;
		border=false;
		reLoad;
	}

	mixin(ItemStyleGetSetMixStr("standard", q{LBS_STANDARD}, false));
	mixin(ItemStyleGetSetMixStr("notify", q{LBS_NOTIFY}, false));
	mixin(ItemStyleGetSetMixStr("ownerDraw", q{LBS_OWNERDRAWFIXED}, false));
	mixin(ItemStyleGetSetMixStr("sort", q{LBS_SORT}, false));

	void column(int Column) {
		send(LB_SETCOLUMNWIDTH, Column, NONE);
	}
	
	override int add(in Text text) {
		auto Index=super.send(LB_ADDSTRING, NONE, cast(LPARAM)text.ptr);
		switch(Index) {
			case LB_ERRSPACE: throw new ListBoxException(Text("メモリ不足"));
			case LB_ERR:      throw new ListBoxException(Text("何らかのエラー"));
			default:          return Index;
		}
	}
	override int add(in Text[] texts)
	in {
		assert(texts.length);
	}
	body {
		int LastIndex;
		foreach(text; texts) {
			LastIndex = this.add(text);
		}
		return LastIndex;
	}
	override int del(int Index) {
		auto Count=super.send(LB_DELETESTRING, Index, NONE);
		if(Count == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Count;
	}
	override int find(int StartIndex, in Text text) {
		auto Count=super.send(LB_FINDSTRING, StartIndex, cast(LPARAM)text.ptr);
		if(Count == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Count;
	}

	override int count() {
		auto Count=super.send(LB_GETCOUNT, NONE, NONE);
		if(Count == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Count;
	}

	override const int select() {
		auto Index=super.send(LB_GETCURSEL, NONE, NONE);
		if(Index == LB_ERR) {
			throw new ListBoxException(Text("未選択"));
		}
		return Index;
	}
	override int select(int Index) {
		auto SelectIndex=super.send(LB_SETCURSEL, Index, NONE);
		if(SelectIndex == LB_ERR && Index != -1) {
			throw new NemuxiException(Err.text);
		}
		return SelectIndex;
	}
	
	override int getHeight(int Index) {
		auto Size=super.send(LB_GETITEMHEIGHT, Index, NONE);
		if(Size == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Size;
	}
	override bool setHeight(int Index, int Height) {
		return super.send(LB_SETITEMHEIGHT, Index, Height) != LB_ERR;
	}

	override void setWidth(int Width) {
		super.send(LB_SETHORIZONTALEXTENT, Width, NONE);
	}

	/**
	History:
		1.00β17:
			[S] const属性に変更。
	*/
	override const Text listText(int Index) {
		auto text=new wchar[this.listTextLength(Index) + 1];
		auto Length=super.send(LB_GETTEXT, Index, cast(LPARAM)text.ptr);
		if(Length == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Text(text[0..Length]);
	}
	override bool listText(int Index, in Text text) {
		insert(Index, text);
		
		return cast(bool)del(Index+1);
	}

	/**
	History:
		1.00β17:
			[S] const属性に変更。
	*/
	override const int listTextLength(int Index) {
		auto Length=super.send(LB_GETTEXTLEN, Index, NONE);
		if(Length == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Length;
	}

	override int topIndex() {
		return super.send(LB_GETTOPINDEX, NONE, NONE);
	}

	override int insert(int Index, in Text text) {
		auto Pos=super.send(LB_INSERTSTRING, Index, cast(LPARAM)text.ptr);
		switch(Pos) {
			case LB_ERRSPACE: throw new ListBoxException(Text("メモリ不足"));
			case LB_ERR:      throw new ListBoxException(Text("何らかのエラー"));
			default:          return Pos;
		}
	}

	override void clear() {
		super.send(LB_RESETCONTENT, NONE, NONE);
	}

	override int search(int StartIndex, in Text text) {
		auto Index=super.send(LB_SELECTSTRING, StartIndex, cast(LPARAM)text.ptr);
		if(Index == LB_ERR) {
			throw new ListBoxException(Text("見つからない"));
		}
		return Index;
	}
	
	//---------------------------------------------------------------------
	/**
	History:
		1.00β17:
			[S] const属性に変更。
	*/
	const bool isSelect() {
		return super.send(LB_GETCURSEL, NONE, NONE) != LB_ERR;
	}
	bool isSelect(int Index) {
		auto Selected=super.send(LB_GETSEL, Index, NONE);
		if(Selected == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Selected ? true: false;
	}
	bool toSelect(int Index, bool Select) {
		auto Success=super.send(LB_SETSEL, Select, Index);
		return Success != LB_ERR;
	}

	int selectedCount() {
		auto Count=super.send(LB_GETSELCOUNT, NONE, NONE);
		if(Count == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Count;
	}

	int caretIndex() {
		return super.send(LB_GETCARETINDEX, NONE, NONE);
	}

	void* getItemData(int Index) {
		return cast(void*)super.send(LB_GETITEMDATA, Index, NONE);
	}
	void setItemData(int Index, void* Data) {
		super.send(LB_SETITEMDATA, Index, cast(LPARAM)Data);
	}


	mixin ListControlArray!("ListBox");
}

interface IListBox {
	int add(in Text);
	int add(in Text[]);
	int del(int);
	int find(int, in Text);
	int count();
	/**
	History:
		1.00β15:
			[S] 属性変更。
	*/
	const int select();
	int select(int);
	int getHeight(int);
	bool setHeight(int, int);
	void setWidth(int);
	/**
	History:
		1.00β17:
			[S] 属性変更。
	*/
	const Text listText(int);
	bool listText(int, in Text);
	/**
	History:
		1.00β17:
			[S] 属性変更。
	*/
	const int listTextLength(int);
	int topIndex();
	int insert(int, in Text);
	void clear();
	int search(int, in Text);

	// 配列っぽく
	Text opIndex(int);
	void opIndexAssign(in Text, int);
	Text[] opSlice();
	Text[] opSlice(int, int);
	void opAddAssign(in Text);
}

template ListControlArray(string ListCtrlType) {
	// 配列っぽく===================

	/**
	項目の文字列取得。

	Params:
		Index = 項目のインデックス。

	Exception:
		失敗時にControlExceptionを投げる。
	*/
	Text opIndex(int Index)
	in {
		assert(Index >= 0, `RangeError`);
	}
	body {
		if(!this.count) {
			throw new ControlException(Text(ListCtrlType ~ ".RangeError(opIndex)"));
		}
		
		return this.listText(Index);
	}
	void opIndexAssign(in Text text, int Index)
	in {
		assert(Index >= 0, `RangeError`);
	}
	body {
		if(!this.count) {
			throw new ControlException(Text(ListCtrlType ~ ".RangeError(opIndexAssign)"));
		}
		
		this.listText(Index, text);
	}
	/// ditto
	Text[] opSlice() {
		if(!this.count) {
			return null;
		}
		return opSlice(0, this.count());
	}
	Text[] opSlice(int StartIndex, int EndIndex)
	in {
		assert(StartIndex < EndIndex, `あらら`);
		assert(EndIndex - StartIndex > 0, `わわわ`);
	}
	body {
		if(EndIndex > this.count()) {
			throw new ControlException(Text(ListCtrlType ~ ".RangeError(opSlice)"));
		}
		
		auto texts=new Text[EndIndex - StartIndex];
		for(auto i=StartIndex; i < EndIndex; i++) {
			texts[i] = this.listText(i);
		}

		return texts;
	}
	void opAddAssign(in Text text) {
		add(text);
	}
	
}

class ListBoxGroup: Group!(ListBox) {
	mixin TGroupClass!(ListBox);

	void clear() {
		foreach(Listbox; List) {
			Listbox.clear();
		}
	}

}


