/**
あ
*/
module nemuxi.negui.control.listbox.header;

debug import std.stdio: wl = writefln, pl = printf;
debug(header) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
public import nemuxi.negui.control.control;

///
class HeaderException: ControlException {
	mixin MixInNeGuiException;
}

class Header: Control, ICommonControl {
	mixin CommonControl;
	override protected this(HWND hWnd) {
		super(hWnd);
	}
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = WC_HEADER;
		super(NeGuiInfo);
	}

	size_t count() {
		auto len = send(HDM_GETITEMCOUNT, NONE, NONE);
		enforce(len != -1, new HeaderException(Text("ヘッダーアイテム数取得失敗")));
		return len;
	}
}

