﻿/**
あ
*/
module nemuxi.negui.control.control;

debug import std.stdio: wl = writefln, pl = printf;

debug(control) void main() {}

import std.string;
import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.group;
import nemuxi.negui.draw.unit;
public import nemuxi.utility.meta.memberproperty;
public import nemuxi.utility.meta.guimethod;

///
class ControlException: NeGuiException {
	mixin MixInNeGuiException;
}

static this() {
	INITCOMMONCONTROLSEX ic;
	ic.dwSize = INITCOMMONCONTROLSEX.sizeof;
	ic.dwICC =
	ICC_LISTVIEW_CLASSES |
	ICC_TREEVIEW_CLASSES |
	ICC_BAR_CLASSES      |
	ICC_TAB_CLASSES      |
	ICC_UPDOWN_CLASS     |
	ICC_PROGRESS_CLASS   |
	ICC_HOTKEY_CLASS     |
	ICC_ANIMATE_CLASS    |
	ICC_WIN95_CLASSES    |
	ICC_DATE_CLASSES     |
	ICC_USEREX_CLASSES   |
	ICC_COOL_CLASSES     ;
	
	enforce(InitCommonControlsEx(&ic), new ControlException(Err.text));
}

///
abstract class Control: NeGui {
	/// Windowsが勝手に作ってくれるやつ用。
	protected override this(HWND hWnd) {
		super(hWnd);
	}
	/**
	History:
		1.00β15:
			[P] WS_CLIPSIBLINGSを排除。
	*/
	protected override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= WS_CHILDWINDOW | WS_TABSTOP | WS_VISIBLE;// |WS_CLIPSIBLINGS;
		
		super(NeGuiInfo);

		if(!super.layoutManager) {
			super.layoutManager = new LayoutManager(NeGuiInfo.Owner);
		}
		
		parent.send(WM_PARENTNOTIFY, MAKELONG(WM_CREATE, 0), cast(LPARAM)hItem);
	}
	
	const ITEM_ID id()
	out(r) {
		assert(r);
	}
	body {
		return cast(ITEM_ID)super.getItemInfo(GWL.ID);
	}
	void id(ITEM_ID Id)
	in {
		assert(Id);
	}
	body {
		return super.setItemInfo(GWL.ID, Id);
	}

	
	mixin(ItemExStyleGetSetMixStr("noParentNotify", q{WS_EX_NOPARENTNOTIFY}, false));
	
	mixin(ItemStyleGetSetMixStr("tab", q{WS_TABSTOP}, false));
	mixin(ItemStyleGetSetMixStr("group", q{WS_GROUP}, false));
	mixin(ItemStyleGetSetMixStr("clipSiblings", q{WS_CLIPSIBLINGS}, false));

	/***/
	ref POINT clientPosition() {
		try {
			auto Rect=itemRect();
			
			auto Point=new POINT;
			
			Point.x = Rect.left;
			Point.y = Rect.top;
			parent.pointToClient(*Point);
			
			return *Point;
		} catch(Exception e) {
			throw new ControlException(Err.text, NGEC.NONE, e);
		}
	}
	
	mixin NeGuiEvent;

	/// 独断と偏見によるコントロールの最低の高さを取得。
	int minHeight() {
		return GetFontHeightPx(GetSafeFont(this));
	}
	/// ditto
	int minContentHeight() {
		return GetDefaultControlHeight(GetSafeFont(this));
	}
}

interface ICommonControl {
	/// コモンコントロールを親ウィンドウの上端に作成します。
	bool top();
	void top(bool);

	/// WM_SIZE メッセージに対して、xサイズは変更するが、yサイズは変更しない様にします。CCS_NORESIZE が同時に指定されている場合には、このスタイルは無視されます。
	bool noMoveY();
	void noMoveY(bool);

	/// コモンコントロールを親ウィンドウの下端に作成します。
	bool bottom();
	void bottom(bool);

	/// サイズを固定して、デフォルトサイズが使用されないようにします。
	bool noReSize();
	void noReSize(bool);

	/// コントロールが自動的に親ウィンドウの上端または下端に移動しないようにします。CCS_TOP または CCS_BOTTOM が同時に指定されている場合は、高さはデフォルトに調整されますが、位置および幅は固定されます。
	bool noParentAlign();
	void noParentAlign(bool);

	/// ユーザーがツールバーのカスタマイズをすることができるようにします。
	bool ajustble();
	void ajustble(bool);

	/// コントロールの上端に2ピクセル分のハイライト表示がされないようにします。
	bool noDivider();
	void noDivider(bool);

	/// version 4.70 以降： コントロールを垂直表示します。
	bool vert();
	void vert(bool);

	/// version 4.70 以降： コントロールをウィンドウの左側に垂直表示します。
	bool left();
	void left(bool);

	/// version 4.70 以降： コントロールをウィンドウの右側に垂直表示します。
	bool right();
	void right(bool);

	/// version 4.70 以降： WM_SIZE メッセージに対して、yサイズは変更するが、xサイズは変更しない様にします。CCS_NORESIZE が同時に指定されている場合には、このスタイルは無視されます。
	bool noMoveX();
	void noMoveX(bool);
}
template CommonControl() {
	/// コモンコントロールを親ウィンドウの上端に作成します。
	mixin(ItemStyleGetSetMixStr("top", q{CCS_TOP}, true));

	/// WM_SIZE メッセージに対して、xサイズは変更するが、yサイズは変更しない様にします。CCS_NORESIZE が同時に指定されている場合には、このスタイルは無視されます。
	mixin(ItemStyleGetSetMixStr("noMoveY", q{CCS_NOMOVEY}, true));

	/// コモンコントロールを親ウィンドウの下端に作成します。
	mixin(ItemStyleGetSetMixStr("bottom", q{CCS_BOTTOM}, true));

	/// サイズを固定して、デフォルトサイズが使用されないようにします。
	mixin(ItemStyleGetSetMixStr("noReSize", q{CCS_NORESIZE}, true));

	/// コントロールが自動的に親ウィンドウの上端または下端に移動しないようにします。CCS_TOP または CCS_BOTTOM が同時に指定されている場合は、高さはデフォルトに調整されますが、位置および幅は固定されます。
	mixin(ItemStyleGetSetMixStr("noParentAlign", q{CCS_NOPARENTALIGN}, true));

	/// ユーザーがツールバーのカスタマイズをすることができるようにします。
	mixin(ItemStyleGetSetMixStr("ajustble", q{CCS_ADJUSTABLE}, true));

	/// コントロールの上端に2ピクセル分のハイライト表示がされないようにします。
	mixin(ItemStyleGetSetMixStr("noDivider", q{CCS_NODIVIDER}, true));

	/// version 4.70 以降： コントロールを垂直表示します。
	mixin(ItemStyleGetSetMixStr("vert", q{CCS_VERT}, true));

	/// version 4.70 以降： コントロールをウィンドウの左側に垂直表示します。
	mixin(ItemStyleGetSetMixStr("left", q{CCS_LEFT}, true));

	/// version 4.70 以降： コントロールをウィンドウの右側に垂直表示します。
	mixin(ItemStyleGetSetMixStr("right", q{CCS_RIGHT}, true));

	/// version 4.70 以降： WM_SIZE メッセージに対して、yサイズは変更するが、xサイズは変更しない様にします。CCS_NORESIZE が同時に指定されている場合には、このスタイルは無視されます。
	mixin(ItemStyleGetSetMixStr("noMoveX", q{CCS_NOMOVEX}, true));

	///
	enum COMMONEVENT: MESSAGETYPE {
		OUTOBMEMORY     = NM_OUTOFMEMORY     , /// コントロールは、利用できるメモリが十分になかったため操作を完了できなかった
		CLICKED         = NM_CLICK           , /// ユーザーがコントロール内で左クリックした
		DBLCLK          = NM_DBLCLK          , /// ユーザーがコントロール内で左ダブルクリックした
		ENTER           = NM_RETURN          , /// コントロールが入力フォーカスを持った状態でユーザーがリターンキーを押した
		RCLICKED        = NM_RCLICK          , /// ユーザーがコントロール内で右クリックした
		RDBLCLK         = NM_RDBLCLK         , /// ユーザーがコントロール内で右ダブルクリックした
		SETFOCUS        = NM_SETFOCUS        , /// コントロールが入力フォーカスを受け取った
		KILLFOCUS       = NM_KILLFOCUS       , /// コントロールが入力フォーカスを失った
		CUSTOMDRAW      = NM_CUSTOMDRAW      , /// version 4.70 以降描画動作に関する通知
		HOVER           = NM_HOVER           , /// version 4.70 以降マウスがコントロールのアイテム上に停止した
		HITTEST         = NM_NCHITTEST       , /// version 4.71 以降コントロールが WM_NCHITTEST メッセージを受け取った
		KEYDOWN         = NM_KEYDOWN         , /// version 4.71 以降コントロールが入力フォーカスを持っているときに、ユーザーがキー入力をした
		RELEASEDCAPTURE = NM_RELEASEDCAPTURE , /// version 4.71 以降コントロールがマウスキャプチャを解放している
		SETCURSOR       = NM_SETCURSOR       , /// version 4.71 以降コントロールが WM_SETCURSOR メッセージに応じて、カーソルを設定している。
		CHAR            = NM_CHAR            , /// version 4.71 以降文字キーが押された
	}
}

enum HORIZON_ALIGN {
	LEFT,
	CENTER,
	RIGHT,
}
interface IHorizonAlign {
	void horizonAlign(HORIZON_ALIGN);
	HORIZON_ALIGN horizonAlign();
}
enum VERTICAL_ALIGN {
	TOP,
	CENTER,
	BOTTOM,
}
interface IVerticalAlign {
	void verticaAlign(VERTICAL_ALIGN);
	VERTICAL_ALIGN verticaAlign();
}

interface INotify {
	bool notify();
	void notify(bool Notify);
}

interface IOwnerDraw {
	bool ownerDraw();
	void ownerDraw(bool draw);
}

/// 非アクティブでの選択状態表示
interface INoHideSelect {
	bool noHideSelect();
	void noHideSelect(bool NoHideSelect);
}


string StructGetSetCallBack(T)(string GetSetMethod, string CallBackMethod, string Member, string CallBack) {
	invariant Arg=CallBackMethod ~ "Arg";
	
	return
	StructGetSet!(T)(GetSetMethod, Member)
	~ newline ~
	"
	bool " ~ CallBackMethod ~ "() {
		return " ~ Member ~ " == " ~ CallBack ~ ";
	}
	void " ~ CallBackMethod ~ "(bool " ~ Arg ~ ") {
		" ~ Member ~ " = " ~ Arg ~ " ? " ~ CallBack ~ ": " ~ Member ~ ".init;
	}
	"
	;
}

template ControlClass() {
	this(NeGui Owner, ITEM_ID Id)
	in {
		assert(Owner);
		assert(Id);
	}
	body {
		super(Owner, Id);
	}
	
	override this(GUIINFO* NeGuiInfo) {
		super(NeGuiInfo);
	}
}

///
struct CUSTOMDRAW {
	NMCUSTOMDRAW DrawInfo;
	mixin(SMixInStructHiddenOriginal!(NMCUSTOMDRAW)(q{DrawInfo}));

	const NOTIFY* notify() {
		return cast(NOTIFY*)&DrawInfo.hdr;
	}

	enum STAGE {
		GLOBAL_POST_ERACE = CDDS_POSTERASE, /// 消去サイクルが完了後
		GLOBAL_POST_PAINT = CDDS_POSTPAINT, /// 描画サイクル完了後
		GLOBAL_PRE_ERASE  = CDDS_PREERASE, /// 消去サイクルが始まる前
		GLOBAL_PRE_PAINT  = CDDS_PREPAINT, /// 描画サイクルが始まる前

		ITEM_ITEM = CDDS_ITEM, /// dwItemSpec, uItemState, lItemlParamメンバが有効であることを指し示す
		ITEM_POST_ERASE = CDDS_ITEMPOSTERASE, /// アイテムが消去された後
		ITEM_POST_PAINT = CDDS_ITEMPOSTPAINT, /// アイテムが描画された後
		ITEM_PRE_ERASE  = CDDS_ITEMPREERASE, /// アイテムが消去される前
		ITEM_PRE_PAINT  = CDDS_ITEMPREPAINT, /// アイテムが描画される前
		ITEM_SUBITEM    = CDDS_SUBITEM, /// Ver.4.71以降で有効。サブアイテムが描画されようとしているときCDDS_ITEMPREPAINTまたはCDDS_ITEMPOSTPAINTに結合したフラグ。CDDS_PREPAINTからCDRF_NOTIFYSUBITEMDRAWが返されたときのみセットされます。
	}
	mixin(StructGetSet!(STAGE)("stage", q{DrawInfo.dwDrawStage}));
	
	Canvas canvas() {
		return new Canvas(DrawInfo.hdc, false);
	}
	ref RECT rect() {
		return cast(RECT)DrawInfo.rc;
	}
	/// 型がよく分からないんで力技で。
	mixin(StructGetSet!(int)("item", q{DrawInfo.dwItemSpec}));

	/// 現在のアイテムの状態を示します。次の組み合わせで表します。
	enum STATE {
		CHECKED       = CDIS_CHECKED,       /// アイテムはチェックされています。
		DEFAULT       = CDIS_DEFAULT,       /// アイテムはデフォルト状態です。
		DISABLED      = CDIS_DISABLED,      /// アイテムは使用不可になっています。
		FOCUS         = CDIS_FOCUS,         /// アイテムはフォーカスされています。
		GRAYED        = CDIS_GRAYED,        /// アイテムは灰色表示になっています。
		HOT           = CDIS_HOT,           /// アイテムはhot状態になっています。
		INDETERMINATE = CDIS_INDETERMINATE, /// アイテムはinterminate状態になっています。
		MARKED        = CDIS_MARKED,        /// アイテムはマークされています。
		SELECTED      = CDIS_SELECTED,      /// アイテムは選択されています。		
	}
	mixin(StructGetSet!(STATE)("state", q{DrawInfo.uItemState}));
	mixin(StructGetSet!(void*)("data", q{DrawInfo.lItemlParam}));

	///
	enum RETURN {
		DODEFAULT       = CDRF_DODEFAULT       , /// コントロールは自分自身で描画します。この描画サイクルではもうNM_CUSTOMDRAW通知メッセージは送られません。このフラグ単独で使用します。
		NOTIFYITEMDRAW  = CDRF_NOTIFYITEMDRAW  , /// コントロールはNM_CUSTOMDRAW通知メッセージをアイテム描画の前後で送ってきます。
		NOTIFYPOSTPAINT = CDRF_NOTIFYPOSTPAINT , /// コントロールは描画サイクルが完了したらWM_CUSTOMDRAW を送ってきます。
		SKIPDEFAULT     = CDRF_SKIPDEFAULT     , /// コントロールは全く描画をしません。
		NEWFONT         = CDRF_NEWFONT,
		SUBITEM         = CDRF_NOTIFYSUBITEMDRAW
	}
}

private immutable NEGUICLASS = "NeGuiControl"w;
static this() {
	WNDCLASSEX WndClass;

	with(WndClass) {
		cbSize          = WndClass.sizeof;
		style           = CS_HREDRAW | CS_SAVEBITS | CS_VREDRAW;
		lpfnWndProc     = &NeControl.NeGuiEventProc;
		cbClsExtra      = 0;
		//cbWndExtra      = DLGWINDOWEXTRA;
		hInstance       = GetModuleHandle(null);
		hIcon = hIconSm = LoadIcon(hInstance, IDI_APPLICATION);
		hCursor         = LoadCursor(NULL, IDC_ARROW);
		hbrBackground   = cast(HBRUSH)COLOR_BTNFACE+1;
		lpszMenuName    = null;
		lpszClassName   = NEGUICLASS.ptr;
	}
	if(!RegisterClassEx(&WndClass)) {
		throw new ControlException(Text("ウィンドウクラス登録失敗, %s", Err.text));
	}
}

/**
何か物を載せるときに使用。
*/
class NeControl: Control {
	protected override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = NEGUICLASS;
		NeGuiInfo.Window    = true;
		
		super(NeGuiInfo);
	}

	mixin NeGuiDestructor;

	mixin MixInNeGuiEventProc!(NeControl);
}

