﻿/**

*/
module nemuxi.image.font;

debug import std.stdio: wl = writefln, pl = printf;


import win32.windows;

import nemuxi.base;
public import nemuxi.negui.draw.font;

///
enum SYSFONT {
	ICON, /// アイコンフォント
	
	NORMALCAPTION, /// 通常タイトルバー
	SMALLCAPTION,  /// ツールウィンドウタイトルバー
	MENU,          /// メニュー
	STATUS,        /// ステータスバー
	MESSAGE,       /// メッセージボックス
}
/**
Bugs:
	Fontに統合すべき。
*/
Font GetSystemFont(SYSFONT SysFont, bool Suicide=true) {
	if(SysFont == SYSFONT.ICON) {
		LOGFONT sFont=void;
		if(SystemParametersInfo(SPI_GETICONTITLELOGFONT, sFont.sizeof, &sFont, 0) == FALSE) {
			throw new NemuxiException("GetSystemFont:SystemParametersInfo:SYSFONT.ICON");
		}
		return new Font(CreateFontIndirect(&sFont), Suicide);
	} else {
		NONCLIENTMETRICS NCMetrics=void;
		NCMetrics.cbSize = NCMetrics.sizeof;

		if(SystemParametersInfo(SPI_GETNONCLIENTMETRICS, NCMetrics.sizeof, &NCMetrics, 0) == FALSE) {
			throw new NemuxiException("GetSystemFont:SystemParametersInfo");
		}

		LOGFONT* pFont=void;
		with(SYSFONT) switch(SysFont) {
			case NORMALCAPTION: pFont = &NCMetrics.lfCaptionFont;   break;
			case SMALLCAPTION:  pFont = &NCMetrics.lfSmCaptionFont; break;
			case MENU:          pFont = &NCMetrics.lfMenuFont;      break;
			case STATUS:        pFont = &NCMetrics.lfStatusFont;    break;
			case MESSAGE:       pFont = &NCMetrics.lfMessageFont;   break;
			default: assert(false);
		}
		return new Font(CreateFontIndirect(pFont), Suicide);
	}
}




