﻿/**

*/
module nemuxi.image.cursor;

debug import std.stdio: wl = writefln, pl = printf;


import win32.windows;

import nemuxi.base;
import nemuxi.negui.draw.draw;
import nemuxi.negui.negui;
public import nemuxi.negui.draw.cursor;

private enum {
	SPI_GETSNAPTODEFBUTTON = 95,
}

bool SetOver(lazy NeGui gui) {
	try {
		auto Rect=gui.itemRect();

		with(Rect) return Cursor.setPos(
			left + (right  - left) / 2,
			top  + (bottom - top)  / 2
		);
	} catch(Exception e) {
		return false;
	}
}

bool SetOverAuto(lazy NeGui gui) {
	BOOL Move;
	if(!SystemParametersInfo(SPI_GETSNAPTODEFBUTTON, 0, &Move, 0))
		return false;
	
	if(Move) {
		SetOver(gui);
	}
	
	return false;
}


