﻿/**

History:
	1.00β11:
		新規作成。
*/
module nemuxi.gui.window.nemuxiwindow.ver;

debug import std.stdio: wl = writefln, pl = printf;

import std.string;
//import dmd=std.compiler; // 実質そうだし。

import win32.core;

import etc.kareki.kareki;

public import nemuxi.gui.window.dialog.ver.ver;
import nemuxi.negui.window.newindow;
import nemuxi.image.icon;
import nemuxi.utility.simple.sysinfo;

/**
History:
	1.00β18:
		[@] author_environment.txt.datからauthor_comment.txt.datにファイル名変更。
		[P] author_comment.txt.datからBOMを除去。
		[P] やっぱりユーザー環境を表示。
		[@] author_comment.txt.datに色々記述。
		
	1.00β15:
		[P] メッセージ記述ファイルをversion.aki.datからauthor_environment.txt.datに変更。
		
	1.00β13:
		ユーザー環境ではなく作者の環境に変更。
*/
final class NemuxiVersion: VersionDialog {
	this(NeWindow Owner) {
		auto k=new AkiDocument(splitlines(import("version.aki.dat")));
		VersionDialog.STATUS Status;

		with(Status) {
			name    = k["Name"].get!(string);
			ver     = k["Version"].get!(string);

			website = k["WebSite"].get!(string);
			mail    = k["Mail"].get!(string);

			message ~= import("author_comment.txt.dat");
			message ~= Text.newline;
			message ~= Text.repeat(Text('-'), 40);
			message ~= Text.newline;
			message ~= Text("君の環境");
			message ~= Text.newline;
			message ~= Text.repeat(Text('-'), 40);
			message ~= Text.newline;
			message ~= toStringInfo;
			
			icon    = GetSystemIcon(SYSICON.NEMUXI, ICONSIZE.NORMAL);
		}
		

		super(Owner, Status);
	}
	/**
	History:
		1.00β19:
			[F] ♪
	*/
	void show() {
		MessageBeep(MB_ICONASTERISK);
		messageLoop(CENTER.WORKAREA);
	}
}

