﻿/**
ボタン型のあれこれ。

こいつの中にはprivate変数が独立できない感じで使用されているので何か呼び出すときは注意。
ボタン型ランチャの静的クラスっぽく使用すること前提。
*/
module nemuxi.gui.window.nemuxiwindow.toolbar;

debug(toolbar) import std.stdio: wl = writefln, pl = printf;

import std.string;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.negui.subclass;
import nemuxi.negui.draw.imagelist;
import nemuxi.file.file;
import nemuxi.file.items.item;
import nemuxi.image.icon;
import nemuxi.negui.window.window;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.window.menu.popup;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;
import nemuxi.gui.window.dialog.execdialog.execdialog;
import nemuxi.negui.window.dialog.system;
import nemuxi.file.shortcut;
import nemuxi.gui.gui;

package:

/**
History:
	1.00β16:
		[P] イメージリストの最終解放部分にstatic変数を使用していたのを廃止。
*/
final class NemuxiToolBar: ToolBar, ISubClass {
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.ProcTop!(NemuxiToolBar));
		switch(Message) {
			case WM_MBUTTONDOWN: mixin(EVENTLOOP.WM_MBUTTONDOWN());
			case WM_DESTROY:     mixin(EVENTLOOP.WM_DESTROY());
			case WM_DROPFILES:   mixin(EVENTLOOP.WM_DROPFILES());
			default:             mixin(EVENTLOOP.WM_LAST!(NemuxiToolBar));
		}
	}
	mixin(TSubClass);
	
	deprecated private static ImageList ImgList;

	private {
		Application application;
	}

	/**
	History:
		1.00β13:
			[S] ショートカットとD&Dへの対応のため引数追加。
	*/
	override this(NeGui Owner, ITEM_ID Id, Application application) {
		this.application = application;
		
		super(Owner, Id);
		dropFile = true;
		this.top = true;
		this.noDivider = true;
		this.noReSize = true;
		this.flat = true;
		this.wrapable = true;
		this.toolTips = true;
		
		SubClassOnNeGuiConstructor();
	}
	/+
	///
	static ~this() {
		delete ImgList;
	}
	+/


	/**
	ボタン変更。

	Params:
		BMItems = 必要情報配列。

		ShowText = テキスト表示フラグ。

		IconSize = アイコンサイズ。
	*/
	void buttonSet(BM_ITEM[] BMItems, bool ShowText, ICONSIZE IconSize) {
		super.buttonClear();
		super.initialize();
		
		super.barStyle(TBSTYLE_EX_DRAWDDARROWS);

		auto size=GetIconSize(IconSize);

		ImageList NewImageList;
		if(BMItems.length) {
			NewImageList = new ImageList(size, size, ImageList.ILC.COLOR32 | ImageList.ILC.MASK, BMItems.length, 0, false);
		}
		
		foreach(i, BMItem; BMItems) {
			NewImageList.add(BMItem.icon);
		}
		
		if(auto Image=super.imageListNormal(0, NewImageList)) {
			Image.kill;
		}
		if(!BMItems.length) {
			return;
		}
		
		super.initialize();

		auto ToolButtons=new TOOLBUTTON[BMItems.length];
		foreach(i, ref ToolButton; ToolButtons) {
			ToolButton.imageIndex   = i;
			ToolButton.command = cast(COMMAND_ID)(i+1);
			ToolButton.state   = (BMItems[i].live ? TOOLBUTTON.STATE.ENABLED: cast(TOOLBUTTON.STATE)0) | TOOLBUTTON.STATE.ELLIPSES;
			ToolButton.style   = TOOLBUTTON.STYLE.DROPDOWN | TOOLBUTTON.STYLE.SHOWTEXT;
			ToolButton.data    = cast(void*)BMItems[i].item; // 処理の流れとしては絶対に参照が有効のはず(nemuxi.negui.proc.nemuxiwnd.BMItems)。てかこの型変じゃね？
			ToolButton.stringIndex   = ShowText ? cast(INT)BMItems[i].name.ptr: 0;
		}
		super.buttonSet(ToolButtons);
		super.autoSize();
	}

	Item buttonGet(size_t ButtonIndex) {
		TOOLBUTTON ToolButton;
		super.buttonGet(ButtonIndex-1, ToolButton);
		return cast(Item)ToolButton.data;
	}
	
	void buttonWidth(bool ShowText, bool ListStyle, ICONSIZE IconSize)
	in {
		if(ListStyle) assert(ShowText);
	}
	body {
		ushort MinWidth=cast(ushort)GetIconSize(IconSize);
		if(ShowText) {
			MinWidth = ListStyle
				? cast(ushort)(GetSystemMetrics(SM_CXMIN) + MinWidth)
				: cast(ushort)(GetSystemMetrics(SM_CXMIN))
			;
		}
		super.setButtonWidth(MinWidth, MinWidth);
	}

	
	protected override {
		bool OnMouseMiddleDown(MOUSE_KEY Keys, int x, int y) {
			parent.send(WM_MBUTTONDOWN, Keys, MAKELONG(cast(ushort)x, cast(ushort)y));
			return true;
		}
		void OnDestroy() {
			if(auto Image=imageListNormal) {
				Image.kill;
			}
			SubClassOnNeGuiDestructor();
			super.OnDestroy();
		}
		
		void OnDropFiles(DropFile drop) {
			
			for(COMMAND_ID i=1; i <= buttonCount; i++) {
				auto Rect=buttonRect(i);
				if(
					Rect.left <= drop.point.x
					&& drop.point.x <= Rect.right
					&& Rect.top  <= drop.point.y
					&& drop.point.y <= Rect.bottom
				) {
					TOOLBUTTON ToolButton;
					ToolButton.initialize;
					super.buttonGet(i-1, ToolButton);
					if((ToolButton.state & TOOLBUTTON.STATE.ENABLED) == TOOLBUTTON.STATE.ENABLED) {
						auto item=cast(Item)ToolButton.data;
						// 処理開始！
						/+
						auto options =new Text[drop.length];
						for(auto j=0; j < options.length; j++) {
							if(application.AppData.shortcut && !PATH.cmp(PATH.getExtension(drop[j]), Text("lnk"))) {
								scope link=new Shortcut(cast(Window)parent);
								link.fileLoad(drop[j], STGM.READ);
								if(options.length > 1) {
									options[j] = link.address.quot('"');
								} else {
									options[0] = link.address;
								}
							} else {
								if(options.length > 1) {
									options[j] = drop[j].quot('"');
								} else {
									options[0] = drop[j];
								}
							}
						}
						Text option = options.join(Text(" "));
						+/
						Text option = DropFileJoin(drop[], application.AppData.shortcut, cast(Window)parent);
						if(application.AppData.exeButtonDialog) {
							//一旦ダイアログへ
							auto exec=new ExecDialog(cast(NeWindow)parent, item, application, &option);
							exec.select;
						} else {
							//そのまま起動
							OverrideInfo OverInfo;
							
							OverInfo.Mask   |= OverrideInfo.MASK.OPTION;
							OverInfo.Option =  option.toString();

							application.executeItem(item, &OverInfo);
						}
					}
				}
			}
			
		}
	}

}

