﻿/**

*/
module nemuxi.gui.window.nemuxiwindow.tasktray;

debug(apptray) import std.stdio: wl = writefln, pl = printf;
debug(apptray) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.image.icon;
public import nemuxi.negui.tasktray;
import nemuxi.negui.window.newindow;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;

package:

final class NemuxiTaskTray: TaskTray, IRaii {

	private Icon[] Icons;
	private DWORD  MessageID;
	private NeWindow window;
	
	override protected void Kill() {
		TASKTRAY Tray=void;
		
		Tray.sizeInit();
		Tray.window  = window;
		
		for(auto i=0; i < Icons.length; i++) {
			Tray.id = i;
			super.deleteTray(&Tray);
			delete Icons[i];
		}
		delete Icons;
	}

	this(NeWindow window, DWORD MessageID) {
		this.window    = window;
		this.MessageID = MessageID;

		super(true);

		this.add(GetSystemIcon(SYSICON.TASKTRAY, ICONSIZE.SMALL));
	}

	bool makeTray(size_t Id) {
		assert(Icons);
		
		TASKTRAY Tray;
		
		Tray.sizeInit;
		Tray.window  = window;
		Tray.id      = Id;
		Tray.flags   = TASKTRAY.NIF.MESSAGE | TASKTRAY.NIF.ICON;
		Tray.message = MessageID;
		Tray.icon    = Icons[Id];
		
		return super.addTray(&Tray, true);
	}
	
	/**
	アイコンの追加。

	Params:
		icon = 追加するアイコン。

	Return:
		追加されたアイコンのインデックス。
	*/
	size_t add(Icon icon) {
		Icons ~= icon;
		return Icons.length - 1;
	}
	
}
