﻿/**
メニュー型ランチャーのあれこれ。

次男。
*/
module nemuxi.gui.window.nemuxiwindow.menulauncher;

debug(menulauncher) import std.stdio: wl = writefln, pl = printf;
debug(menulauncher) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.system.raii;
import nemuxi.image.icon;
import nemuxi.file.items.item;
import nemuxi.file.items.group;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.menu.datamenu;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;

final class MenuLauncher {
	ExecuteMenu Executemenu;

	private BM_ITEM[] BMItems;
	COMMAND_ID SplitIndex;
	Application application;

	this(Application application)
	in {
		assert(application);
	}
	body {
		this.application = application;
	}

	void setNowState() {
		delete Executemenu;
		SplitIndex = 0;
		
		if(!application.MenuData.baseLength) {
			return;
		}
		BMItems = application.getExeMenuItems(application.getMenuGroupName());
		
		Executemenu = new ExecuteMenu(application.AppData.exeMenuIcon());
		SplitIndex=Executemenu.makeGroupMenu(application.MenuData, application.getMenuGroupName());
		Executemenu.makeItemMenu(SplitIndex, BMItems, application.AppData.exeMenuText());
	}

	~this() {
		delete Executemenu;
	}

	void show(NeWindow Owner, ref const(POINT) Point) {
		if(!Executemenu) {
			return;
		}
		
		auto Id=Executemenu.show(
			Owner,
			PopUp.TPM.CENTERALIGN | PopUp.TPM.RETURNCMD | PopUp.TPM.NONOTIFY,
			Point,
			null
		);

		if(!Id) {
			return;
		}
		
		if(SplitIndex <= Id) {
			application.executeItem(Executemenu.data(Id));
		} else {
			application.changeMenuGroup(application.MenuData.baseName(Id-1));
			setNowState();
			show(Owner, Point);
		}
	}
}

final class ExecuteMenu: DataMenu!(Item), IRaii {

	override this(ICONSIZE IconSize) {
		super(IconSize);
	}
	override void Kill() {
		super.Kill();
	}

	COMMAND_ID makeGroupMenu(Sub MenuGroup, Text DefaultName)
	in {
		assert(MenuGroup.baseLength);
		assert(DefaultName.length);
	}
	out(r) {
		assert(r > 0);
	}
	body {
		MENUITEM MenuItem;
		MenuItem.sizeInit();
		MenuItem.mask = MENUITEM.MIIM.ID | MENUITEM.MIIM.STATE | MENUITEM.MIIM.TYPE | MENUITEM.MIIM.DATA;
		MenuItem.type = MENUITEM.MFT.STRING;
		
		bool OnDefault;

		COMMAND_ID Id=1;
		foreach(GroupName; MenuGroup.baseNames()) {
			MenuItem.id = Id++;
			auto state = MenuGroup.inBaseName(GroupName) ? MENUITEM.MFS.ENABLED: MENUITEM.MFS.GRAYED;
			if(!OnDefault && GroupName == DefaultName) {
				state |=  MENUITEM.MFS.DEFAULT;
				OnDefault = true;
			}
			MenuItem.state = state;
			MenuItem.typeData = GroupName.ptr;
			MenuItem.itemData = null;

			this.insert(MenuItem, null, null);
		}
		return Id;
	}

	void makeItemMenu(COMMAND_ID StartID, BM_ITEM[] NoSaveBMItems, size_t TextLength)
	in {
		assert(StartID > 0);
	}
	body {
		MENUITEM MenuItem;
		MenuItem.sizeInit();
		MenuItem.mask = MENUITEM.MIIM.ID | MENUITEM.MIIM.STATE | MENUITEM.MIIM.TYPE| MENUITEM.MIIM.DATA;

		DRAWMENUITEM DrawMenuItem;

		auto Id=StartID;
		foreach(BMItem; NoSaveBMItems) {
			if(TextLength) {
				if(BMItem.name.length > TextLength) {
					DrawMenuItem.text = BMItem.name.text[0..TextLength] ~ "...";
				} else {
					DrawMenuItem.text = BMItem.name;
				}
			} else {
				DrawMenuItem.text = BMItem.name;
			}
			DrawMenuItem.icon = BMItem.icon;
			DrawMenuItem.key  = BMItem.key;
			
			MenuItem.type = MENUITEM.MFT.OWNERDRAW | (Id == StartID ? MENUITEM.MFT.MENUBARBREAK: cast(MENUITEM.MFT)0);
			MenuItem.id = Id++;
			MenuItem.state = BMItem.live ? MENUITEM.MFS.ENABLED: MENUITEM.MFS.DISABLED;
			MenuItem.itemData = cast(void*)MENUS.MENU;
			
			this.insert(MenuItem, &DrawMenuItem, BMItem.item);
		}
	}
}

