﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.nemuxidialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(nemuxidialog) void main() {}

import std.contracts;
import std.string;
static import std.algorithm;

import win32.windows;
import win32.commctrl;

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.file.exec;
import nemuxi.file.app;
import nemuxi.file.file;
import nemuxi.file.items.item;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.control.control;
import nemuxi.negui.control.group;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.label.label;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.button.group;
import nemuxi.negui.control.updown.updown;
import nemuxi.negui.control.hotkey.hotkey;
import nemuxi.gui.window.dialog.selectdialog;
import nemuxi.gui.control.combobox;
import nemuxi.gui.control.excombobox;
import nemuxi.gui.control.listview;
import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.dual;
import nemuxi.gui.window.dialog.settingdialog.settingif;


class NemuxiDialog: ModalDialog, ISettingInFrame {
	private enum CTRL: ITEM_ID {
		APP = 1,
		APP_SHORTCUT,
		
		WINDOW,
		WINDOW_POS,
		WINDOW_FRONT,
		WINDOW_,

		BUTTON,
		BUTTON_ICON_SMALL,
		BUTTON_ICON_NORMAL,
		BUTTON_TEXT,
		BUTTON_TEXT_LIST,
		BUTTON_DRAGDROP,
		BUTTON_,
		
		MENU,
		MENU_ICON_SMALL,
		MENU_ICON_NORMAL,
		MENU_TEXT_INFO,
		MENU_TEXT_INPUT,
		MENU_TEXT_UPDOWN,
		MENU_DESKTOP,
		MENU_,

		COMMAND,
		COMMAND_CALL_INFO,
		COMMAND_CALL_INPUT,
		COMMAND_FONT,
		COMMAND_TIMER_INFO,
		COMMAND_TIMER_INPUT,
		COMMAND_TIMER_UPDOWN,
		COMMAND_ICON_SMALL,
		COMMAND_ICON_NORMAL,
		COMMAND_COLOR,
		COMMAND_,

		FOLDER,
		FOLDER_NORAML,
		FOLDER_EXPLORER,
		FOLDER_ITEM,
		FOLDER_SELECT,
		FOLDER_,
	}
	private {
		App AppData;
		
		ItemIconPairs Pairs;
		
		Font CtrlFont;

		GroupBox AppGroup;
		CheckBox AppShortCutSelect;

		GroupBox WindowGroup;
		WindowPosComboBox WindowPosSelect;
		CheckBox FrontSelect;

		GroupBox ButtonGroup;
		Radio ButtonIconSmall;
		Radio ButtonIconNormal;
		CheckBox ButtonTextSelect;
		CheckBox ButtonTextList;
		CheckBox ButtonDragAndDrop;

		GroupBox MenuGroup;
		Radio MenuIconSmall;
		Radio MenuIconNormal;
		TextLabel MenuTextInfo;
		EditBox MenuTextInput;
		UpDown MenuTextSpin;
		CheckBox MenuDesktop;

		GroupBox CommandGroup;
		TextLabel CommandCallInfo;
		HotKey CommandCallInput;
		Font CommandFont;
		Push CommandFontSelect;
		TextLabel CommandHiddenInfo;
		EditBox CommandHiddenInput;
		UpDown CommandHiddenSpin;
		Radio CommandIconSmall;
		Radio CommandIconNormal;
		ColorList CommandColor;

		GroupBox FolderGroup;
		Radio FolderOpenNormal;
		Radio FolderOpenExplorer;
		Radio FolderOpenItem;
		ItemComboBox FolderOpenSelect;
	}
	
	this(NeWindow Owner, App AppData, ItemIconPairs Pairs)
	in {
		assert(AppData);
	}
	body {
		this.AppData = AppData;
		this.Pairs    = Pairs;
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner  = Owner;
		NeGuiInfo.Window = true;
		
		super(&NeGuiInfo);
	}

	/**
	History:
		1.00β19:
			[F] @フォントの指定不可。
	*/
	private void CommandFontSetting() {
		// 未実装
		scope dialog=new FontDialog();
		dialog.ownerWindow = this;
		dialog.font  = CommandFont;
		dialog.point = CommandFont.height;
		dialog.flags = FontDialog.FLAGS.SCREENFONTS | FontDialog.FLAGS.NOSCRIPTSEL | FontDialog.FLAGS.INITTOLOGFONTSTRUCT | FontDialog.FLAGS.NOVERTFONTS;

		if(dialog.select()) {
			CommandFont.kill();
			CommandFont = dialog.font;

			CommandFontSelect.text = CommandFont.faceName;
			CommandFontSelect.font = CommandFont;
			if(auto line=cast(Line)CommandGroup.layoutManager.basePanel.panel(1)) {
				if(auto button=cast(Push)line.gui(0)) {
					line.sizeInfo(0).absolute=button.minContentHeight;
					CommandGroup.layoutManager.reLoad;
				}
			}
		} else if(dialog.errCode) {
			throw new NemuxiException(Text("[FontDialog] ErrCode = %s", dialog.errCode));
		}
	}

	private void IconRadio(Radio Small, Radio Normal, ICONSIZE IconSize) {
	}

	/**
	History:
		1.00β18:
			[B] 選択アイテムが強制的に最上位に変更される。
			[B] フォルダオープン用アイテム選択状態でアイテム全削除で書き込み失敗。
	*/
	override void iiPairs(ItemIconPairs Pairs) {
		Text ItemID;
		if(Pairs.length && FolderOpenSelect.count) {
			ItemID=FolderOpenSelect.selectID;
		}
		
		this.Pairs = Pairs;
		auto Enable=FolderOpenItem.checked;
		FolderOpenSelect.iiPairs = Pairs;
		FolderOpenSelect.enable = Enable;
		if(ItemID.length && Pairs.length) {
			if(ItemID in Pairs) {
				FolderOpenSelect.selectID(ItemID);
			}
		}
		if(!Pairs.length) {
			FolderOpenItem.enable = false;
			FolderOpenSelect.enable = false;
			if(FolderOpenItem.checked) {
				FolderOpenNormal.checked= true;
				FolderOpenItem.checked = false;
			}
		} else {
			FolderOpenItem.enable = true;
		}
		if(AppData.folderProgram in Pairs) {
			FolderOpenSelect.selectID = AppData.folderProgram;
		}
		
	}
	override ItemIconPairs iiPairs() {
		return Pairs;
	}
	
	mixin MixInSettingInFrame;

	/**
	History:
		1.00β18:
			[S] 書き換え。
	
		1.00β17:
			[B] コマンド型フォントの高さが保持されない。
			[B] コマンド型キーが-releaseでサヨウナラ。
	*/
	override AkiDocument akiDocument() {
		/*
		auto aki=new AkiDocument;
		{
			//アプリケーション
			aki[App.TREE.APP, App.TREE.APP_SHORTCUT] = AppShortCutSelect.checked;
		}
		{
			//ウィンドウ
			aki[App.TREE.WINDOW]  = WindowPosSelect.select;
			aki[App.TREE.WINDOW, App.TREE.WINDOW_FRONT]  = FrontSelect.checked;
			aki[App.TREE.WINDOW, App.TREE.WINDOW_LEFT]   = AppData.barSize(App.POSITION.LEFT);
			aki[App.TREE.WINDOW, App.TREE.WINDOW_RIGHT]  = AppData.barSize(App.POSITION.RIGHT);
			aki[App.TREE.WINDOW, App.TREE.WINDOW_TOP]    = AppData.barSize(App.POSITION.TOP);
			aki[App.TREE.WINDOW, App.TREE.WINDOW_BOTTOM] = AppData.barSize(App.POSITION.BOTTOM);
			aki[App.TREE.WINDOW, App.TREE.WINDOW_FLOAT, App.TREE.WINDOW_FLOAT_POS]  = [AppData.floatPos.x, AppData.floatPos.y];
			aki[App.TREE.WINDOW, App.TREE.WINDOW_FLOAT, App.TREE.WINDOW_FLOAT_SIZE] = [AppData.floatSize.cx, AppData.floatSize.cy];
		}
		{
			//フォルダ
			auto group=new RadioGroup(FolderOpenNormal, FolderOpenExplorer, FolderOpenItem);
			aki[App.TREE.FOLDER]  = group.checkIndex;
			if(group.checked is FolderOpenItem) {
				aki[App.TREE.FOLDER, App.TREE.FOLDER_PROGRAM]  = FolderOpenSelect.selectID.toString;
			} else if([App.TREE.FOLDER, App.TREE.FOLDER_PROGRAM] in aki) {
				aki[App.TREE.FOLDER, App.TREE.FOLDER_PROGRAM].fileKill;
			}
		}
		{
			//ボタン
			auto group=new RadioGroup(ButtonIconSmall, ButtonIconNormal);
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_BUTTON, App.TREE.LAUNCHER_BUTTON_ICON] = group.checkIndex;
			
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_BUTTON, App.TREE.LAUNCHER_BUTTON_TEXT] = ButtonTextSelect.checked;
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_BUTTON, App.TREE.LAUNCHER_BUTTON_LIST] = ButtonTextList.checked;

			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_BUTTON, App.TREE.LAUNCHER_BUTTON_DROP] = ButtonDragAndDrop.checked;
			
		}
		{
			//メニュー
			auto group=new RadioGroup(MenuIconSmall, MenuIconNormal);
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_MENU, App.TREE.LAUNCHER_MENU_ICON] = group.checkIndex;

			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_MENU, App.TREE.LAUNCHER_MENU_TEXT] = MenuTextSpin.value;
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_MENU, App.TREE.LAUNCHER_MENU_DESKTOP] = MenuDesktop.checked;
		}
		{
			//コマンド
			auto group=new RadioGroup(CommandIconSmall, CommandIconNormal);
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_ICON] = group.checkIndex;

			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_FONT, App.TREE.LAUNCHER_COMMAND_FONT_NAME] = CommandFont.faceName.toString;
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_FONT, App.TREE.LAUNCHER_COMMAND_FONT_SIZE] = std.math.abs(CommandFont.height);

			auto value=CommandCallInput.value;
			Integer[] keys;
			/+
			if(value.Mod) {
				keys[0] = value.hotkeyToMod;
			}
			if(KEY.A <= value.Key && value.Key <= KEY.Z) {
				keys[1] = value.Key;
			}
			+/
			keys ~= value.hotkeyToMod;
			keys ~= value.Key;
			
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_KEYS] = keys;

			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_TIMER] = CommandHiddenSpin.value;

			// ひどすぎる
			{
				auto CommandTrees=[
					App.TREE.LAUNCHER_COMMAND_COLOR_ID,
					App.TREE.LAUNCHER_COMMAND_COLOR_NAME,
					App.TREE.LAUNCHER_COMMAND_COLOR_TAG
				];
				foreach(i, CommandTree; CommandTrees) {
					Binary[] bin;
					foreach(j; 0..1+1) {
						bin ~= cast(Binary)CommandColor.color(i, j+1).toRGBArray;
					}
					aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_COLOR, CommandTree] = bin;
				}
			}
		}
		*/
		auto aki=new AkiDocument;
		auto app=new App(aki);

		//アプリケーション
		app.shortcut = AppShortCutSelect.checked;

		//ウィンドウ
		app.position = WindowPosSelect.select;
		app.front    = FrontSelect.checked;

		with(App.POSITION) foreach(WindowPosition; [LEFT, RIGHT, TOP, BOTTOM]) {
			app.barSize(WindowPosition, AppData.barSize(WindowPosition));
		}
		app.floatSize = AppData.floatSize;
		app.floatPos  = AppData.floatPos;

		{
			//フォルダ
			auto group=new RadioGroup(FolderOpenNormal, FolderOpenExplorer, FolderOpenItem);
			app.folder = cast(FOLDER)group.checkIndex;
			
			if(group.checked is FolderOpenItem) {
				app.folderProgram = FolderOpenSelect.selectID;
			}
		}
		{
			//ボタン
			auto group=new RadioGroup(ButtonIconSmall, ButtonIconNormal);
			app.exeButtonIcon = cast(ICONSIZE)group.checkIndex;
			app.exeButtonText = ButtonTextSelect.checked;
			app.exeButtonList = ButtonTextList.checked;
			app.exeButtonDialog = ButtonDragAndDrop.checked;
		}
		{
			//メニュー
			auto group=new RadioGroup(MenuIconSmall, MenuIconNormal);
			app.exeMenuIcon = cast(ICONSIZE)group.checkIndex;

			app.exeMenuText    = MenuTextSpin.value;
			app.exeMenuDeskTop = MenuDesktop.checked;
		}
		{
			//コマンド
			auto group=new RadioGroup(CommandIconSmall, CommandIconNormal);
			app.exeCommandIcon= cast(ICONSIZE)group.checkIndex;

			app.exeCommandFont = CommandFont;

			auto value=CommandCallInput.value;
			app.exeCommandHotkey = [cast(Integer)value.hotkeyToMod, value.Key];
			app.exeCommandTimer  = CommandHiddenSpin.value;

			// ひどすぎる
			with(App.COMMANDCOLOR) foreach(i, cc; [ID, NAME, TAG]) {
				app.exeCommandColor(
					cc,
					CommandColor.color(i, 1),
					CommandColor.color(i, 2)
				);
			}
		}
		
		return aki;
	}
	
	protected override {
		void OnDestroy() {
			delete CtrlFont;
			delete CommandFont;
			
			super.OnDestroy();
		}
		/**
		History:
			1.00β15:
				[S] アクセラレータ使用準備。
		*/
		void OnCreate() {
			super.OnCreate();
			AcceleratorClear();

			CtrlFont = GetSystemFont(SYSFONT.MESSAGE);

			immutable FontHeight = GetFontHeightPx(CtrlFont);
			immutable CtrlHeight = GetDefaultControlHeight(CtrlFont);
			immutable CtrlPadding= GetControlPadding();

			// ぐろーばる ----------------------
			AppGroup = new GroupBox(this, CTRL.APP);
			//AppGroup.text = Text("アプリケーション");
			AppGroup.text = LanguageData.settingApplication(LD.SETTING_APPLICATION.APP);

			AppShortCutSelect = new CheckBox(AppGroup, CTRL.APP_SHORTCUT);
			//AppShortCutSelect.text  = Text("ショートカットファイルを展開する");
			AppShortCutSelect.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.APP_SHORTCUT);
			AppShortCutSelect.checked = AppData.shortcut;

			AppGroup.font = CtrlFont;

			auto AppPanel=new Line(DIRECTION.HORIZON);
			AppPanel += AppShortCutSelect;
			AppPanel.sizeInfo(0).absolute = -1;

			AppGroup.layoutManager.basePanel=AppPanel;

			// ウィンドウ ----------------------
			
			WindowGroup = new GroupBox(this, CTRL.WINDOW);
			//WindowGroup.text = Text("ウィンドウ表示");
			WindowGroup.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.WINDOW);
			
			WindowPosSelect = new WindowPosComboBox(WindowGroup, CTRL.WINDOW_POS);
			WindowPosSelect.initialize();
			WindowPosSelect.select = AppData.position;

			FrontSelect = new CheckBox(WindowGroup, CTRL.WINDOW_FRONT);
			//FrontSelect.text = Text("最前面表示");
			FrontSelect.text = LanguageData.window(LD.WINDOW.FRONT_SETTING);
			FrontSelect.checked = AppData.front;
			FrontSelect.verticaAlign = VERTICAL_ALIGN.CENTER;

			WindowGroup.font = CtrlFont;

			/+
			auto WindowPanel=new Line(DIRECTION.HORIZON);
			auto WindowPanelChild=new Dual(DIRECTION.HORIZON);
			WindowPanelChild[0] = WindowPosSelect;
			WindowPanelChild[1] = FrontSelect;
			WindowPanelChild.sizeInfo.percent = 50;
			WindowPanel += WindowPanelChild;
			WindowPanel.sizeInfo(0).absolute = -1;
			WindowGroup.layoutManager.basePanel=WindowPanel;
			+/
			auto WindowPanel=new Dual(DIRECTION.HORIZON);
			WindowPanel[0] = WindowPosSelect;
			WindowPanel[1] = FrontSelect;
			WindowPanel.sizeInfo.percent = 35;
			WindowPanel.centerSize = GetControlPadding.cx;
			WindowGroup.layoutManager.basePanel=WindowPanel;

			// フォルダ表示方法 ------------------------
			FolderGroup = new GroupBox(this, CTRL.FOLDER);
			//FolderGroup.text = Text("フォルダ表示");
			FolderGroup.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.FOLDER);
			
			FolderOpenNormal = new Radio(FolderGroup, CTRL.FOLDER_NORAML);
			//FolderOpenNormal.text = Text("デフォルト");
			FolderOpenNormal.text = LanguageData.folder(FOLDER.NORMAL);
			FolderOpenExplorer = new Radio(FolderGroup, CTRL.FOLDER_EXPLORER);
			//FolderOpenExplorer.text = Text("Explorer");
			FolderOpenExplorer.text = LanguageData.folder(FOLDER.EXPLORER);
			FolderOpenItem = new Radio(FolderGroup, CTRL.FOLDER_ITEM);
			//FolderOpenItem.text = Text("アイテム");
			FolderOpenItem.text = LanguageData.folder(FOLDER.PROGRAM);
			FolderOpenSelect = new ItemComboBox(FolderGroup, CTRL.FOLDER_SELECT);
			
			with(FOLDER) {
				bool SelectEnable=true;
				auto group=new RadioGroup(FolderOpenNormal, FolderOpenExplorer, FolderOpenItem);
				switch(AppData.folder()) {
					case NORMAL:   group.checked = FolderOpenNormal;   SelectEnable = false; break;
					case EXPLORER: group.checked = FolderOpenExplorer; SelectEnable = false; break;
					case PROGRAM:  group.checked = FolderOpenItem;     SelectEnable = cast(bool)FolderOpenSelect.count; break;
					default:       assert(false);
				}
				
			iiPairs(Pairs);
			}

			FolderGroup.font = CtrlFont;

			/+
			auto FolderPanel=new Line(DIRECTION.VERTICAL);
			FolderPanel.padding.bottom = FolderGroup.layoutManager.padding.bottom;
			FolderPanel += FolderOpenNormal;
			FolderPanel.sizeInfo(0).absolute = FontHeight;
			FolderPanel += FolderOpenExplorer;
			FolderPanel.sizeInfo(1).absolute = FontHeight;
			FolderPanel += FolderOpenItem;
			FolderPanel.sizeInfo(2).absolute = FontHeight;
			FolderPanel += FolderOpenSelect;
			FolderPanel.sizeInfo(3).absolute = -1;
			FolderGroup.layoutManager.basePanel=FolderPanel;
			+/
			auto FolderPanel=new Line(DIRECTION.HORIZON);
			FolderPanel += FolderOpenNormal;
			FolderPanel.sizeInfo(0).percent = 20;
			FolderPanel += FolderOpenExplorer;
			FolderPanel.sizeInfo(1).percent = 20;
			FolderPanel += FolderOpenItem;
			FolderPanel.sizeInfo(2).percent = 20;
			FolderPanel += FolderOpenSelect;
			FolderPanel.sizeInfo(3).absolute = -1;
			FolderGroup.layoutManager.basePanel=FolderPanel;
			
			// ボタン型 ------------------------
			ButtonGroup = new GroupBox(this, CTRL.BUTTON);
			//ButtonGroup.text = Text("ボタン型");
			ButtonGroup.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.BUTTON);
			
			ButtonIconSmall = new Radio(ButtonGroup, CTRL.BUTTON_ICON_SMALL);
			//ButtonIconSmall.text = Text("16px");
			ButtonIconSmall.text = LanguageData.icon(ICONSIZE.SMALL);
			ButtonIconNormal = new Radio(ButtonGroup, CTRL.BUTTON_ICON_NORMAL);
			//ButtonIconNormal.text = Text("32px");
			ButtonIconNormal.text = LanguageData.icon(ICONSIZE.NORMAL);
			with(ICONSIZE) {
				auto group=new RadioGroup(ButtonIconSmall, ButtonIconNormal);
				switch(AppData.exeButtonIcon()) {
					case SMALL:  group.checked = ButtonIconSmall;  break;
					case NORMAL: group.checked = ButtonIconNormal; break;
					default:    assert(false);
				}
			}

			ButtonTextSelect = new CheckBox(ButtonGroup, CTRL.BUTTON_TEXT);
			//ButtonTextSelect.text = Text("テキスト");
			ButtonTextSelect.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.BUTTON_TEXT);
			ButtonTextSelect.checked = AppData.exeButtonText();
			
			ButtonTextList   = new CheckBox(ButtonGroup, CTRL.BUTTON_TEXT_LIST);
			//ButtonTextList.text = Text("リスト表示");
			ButtonTextList.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.BUTTON_LIST);
			ButtonTextList.enable = ButtonTextSelect.checked;
			ButtonTextList.checked = AppData.exeButtonList();

			ButtonDragAndDrop = new CheckBox(ButtonGroup, CTRL.BUTTON_DRAGDROP);
			//ButtonDragAndDrop.text = Text("ファイルドロップ時にダイアログを表示");
			ButtonDragAndDrop.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.BUTTON_DROP);
			ButtonDragAndDrop.checked = AppData.exeButtonDialog();
			
			ButtonGroup.font = CtrlFont;

			/+
			auto ButtonPanel=new Line(DIRECTION.VERTICAL);
			ButtonPanel.padding.bottom = FolderGroup.layoutManager.padding.bottom;
			ButtonPanel += ButtonIconSmall;
			ButtonPanel.sizeInfo(0).absolute = FontHeight;
			ButtonPanel += ButtonIconNormal;
			ButtonPanel.sizeInfo(1).absolute = FontHeight;
			ButtonPanel += ButtonTextSelect;
			ButtonPanel.sizeInfo(2).absolute = FontHeight;
			ButtonPanel += ButtonTextList;
			ButtonPanel.sizeInfo(3).absolute = -1;
			ButtonPanel += ButtonDragAndDrop;
			ButtonPanel.sizeInfo(4).absolute = -1;
			ButtonGroup.layoutManager.basePanel=ButtonPanel;
			+/
			auto ButtonPanel=new Line(DIRECTION.VERTICAL);
			auto ButtonIconPanel=new Line(DIRECTION.HORIZON);
			ButtonIconPanel += ButtonIconSmall;
			ButtonIconPanel += ButtonIconNormal;
			ButtonIconPanel += ButtonTextSelect;
			ButtonIconPanel += ButtonTextList;
			ButtonIconPanel.sizeInfo(0).percent = 20;
			ButtonIconPanel.sizeInfo(1).percent = 20;
			ButtonIconPanel.sizeInfo(2).percent = 20;
			ButtonIconPanel.sizeInfo(3).percent = 20;
			ButtonPanel += ButtonIconPanel;
			ButtonPanel += ButtonDragAndDrop;
			ButtonPanel.sizeInfo(0).absolute = ButtonIconSmall.minContentHeight;
			ButtonPanel.sizeInfo(1).absolute = ButtonDragAndDrop.minContentHeight;
			
			ButtonGroup.layoutManager.basePanel=ButtonPanel;
			
			// メニュー型 ----------------------
			MenuGroup = new GroupBox(this, CTRL.MENU);
			//MenuGroup.text = Text("メニュー型");
			MenuGroup.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.MENU);

			MenuIconSmall = new Radio(MenuGroup, CTRL.MENU_ICON_SMALL);
			//MenuIconSmall.text = Text("16px");
			MenuIconSmall.text = LanguageData.icon(ICONSIZE.SMALL);
			MenuIconNormal = new Radio(MenuGroup, CTRL.MENU_ICON_NORMAL);
			//MenuIconNormal.text = Text("32px");
			MenuIconNormal.text = LanguageData.icon(ICONSIZE.NORMAL);
			with(ICONSIZE) {
				auto group=new RadioGroup(MenuIconSmall, MenuIconNormal);
				switch(AppData.exeMenuIcon()) {
					case SMALL:  group.checked = MenuIconSmall;  break;
					case NORMAL: group.checked = MenuIconNormal; break;
					default:    assert(false);
				}
			}

			MenuTextInfo = new TextLabel(MenuGroup, CTRL.MENU_TEXT_INFO);
			//MenuTextInfo.text = Text("文字列長");
			MenuTextInfo.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.MENU_TEXT);
			MenuTextInfo.horizonAlign = HORIZON_ALIGN.RIGHT;
			MenuTextInfo.verticalCenter = true;
			
			MenuTextInput = new EditLine(MenuGroup, CTRL.MENU_TEXT_INPUT);
			MenuTextInput.numberOnly=true;
			
			MenuTextSpin = new UpDown(MenuGroup, CTRL.MENU_TEXT_UPDOWN, UpDown.POSITION.RIGHT);
			MenuTextSpin.buddy = MenuTextInput;
			MenuTextSpin.range(0, Integer.max);
			MenuTextSpin.value = AppData.exeMenuText();
			
			MenuDesktop   = new CheckBox(MenuGroup, CTRL.MENU_DESKTOP);
			//MenuDesktop.text = Text("デスクトップで有効にする");
			MenuDesktop.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.MENU_DESKTOP);
			MenuDesktop.checked = AppData.exeMenuDeskTop();
			
			MenuGroup.font = CtrlFont;

			
			MenuGroup.tuneSize = delegate(int Width, int Height, int CtrlHeight, ref const RECT InSize) {
				MenuTextSpin.reBuddy;
			};
			/+
			auto MenuPanel=new Line(DIRECTION.VERTICAL);
			MenuPanel.padding.bottom = FolderGroup.layoutManager.padding.bottom;
			MenuPanel += MenuIconSmall;
			MenuPanel.sizeInfo(0).absolute = FontHeight;
			MenuPanel += MenuIconNormal;
			MenuPanel.sizeInfo(1).absolute = FontHeight;

			auto MenuTextPanel=new Dual(DIRECTION.HORIZON);
			MenuTextPanel[0] = MenuTextInfo;
			MenuTextPanel[1] = MenuTextInput;
			MenuTextPanel.sizeInfo.percent = 45;
			MenuTextPanel.centerSize = CtrlPadding.cx;
			MenuPanel += MenuTextPanel;
			MenuPanel.sizeInfo(2).absolute = CtrlHeight;
			
			MenuPanel += MenuDesktop;
			MenuPanel.sizeInfo(3).absolute = -1;
			MenuGroup.layoutManager.basePanel=MenuPanel;
			+/
			auto MenuPanel=new Line(DIRECTION.VERTICAL);
			auto MenuIconPanel=new Line(DIRECTION.HORIZON);
			MenuIconPanel += MenuIconSmall;
			MenuIconPanel += MenuIconNormal;
			MenuIconPanel.sizeInfo(0).percent = 20;
			MenuIconPanel.sizeInfo(1).percent = 20;
			auto MenuTextPanel=new Dual(DIRECTION.HORIZON);
			MenuTextPanel[0] = MenuTextInfo;
			MenuTextPanel[1] = MenuTextInput;
			MenuTextPanel.centerSize = GetControlPadding.cx;
			MenuTextPanel.sizeInfo.percent = 45;
			MenuIconPanel += MenuTextPanel;
			MenuIconPanel.sizeInfo(2).percent = 40;
			MenuPanel += MenuIconPanel;
			MenuPanel += MenuDesktop;
			MenuPanel.sizeInfo(0).absolute = MenuTextInput.minContentHeight;
			MenuPanel.sizeInfo(1).absolute = MenuDesktop.minContentHeight;
			MenuGroup.layoutManager.basePanel=MenuPanel;
			

			// コマンド型 ----------------------
			CommandGroup = new GroupBox(this, CTRL.COMMAND);
			//CommandGroup.text = Text("コマンド型");
			CommandGroup.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.COMMAND);
			
			CommandIconSmall = new Radio(CommandGroup, CTRL.COMMAND_ICON_SMALL);
			//CommandIconSmall.text = Text("16px");
			CommandIconSmall.text = LanguageData.icon(ICONSIZE.SMALL);
			CommandIconNormal = new Radio(CommandGroup, CTRL.COMMAND_ICON_NORMAL);
			//CommandIconNormal.text = Text("32px");
			CommandIconNormal.text = LanguageData.icon(ICONSIZE.NORMAL);
			with(ICONSIZE) {
				auto group=new RadioGroup(CommandIconSmall, CommandIconNormal);
				switch(AppData.exeCommandIcon()) {
					case SMALL:  group.checked = CommandIconSmall;  break;
					case NORMAL: group.checked = CommandIconNormal; break;
					default:    assert(false);
				}
			}

			CommandCallInfo = new TextLabel(CommandGroup, CTRL.COMMAND_CALL_INFO);
			//CommandCallInfo.text = Text("ホットキー");
			CommandCallInfo.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.COMMAND_HOTKEY);
			CommandCallInfo.horizonAlign = HORIZON_ALIGN.RIGHT;
			CommandCallInfo.verticalCenter = true;

			CommandCallInput = new HotKey(CommandGroup, CTRL.COMMAND_CALL_INPUT);
			HOTKEYVALUE HotKeyValue;
			auto keys = AppData.exeCommandHotkey();
			HotKeyValue.modToHotkey = cast(MOD)keys[0];
			HotKeyValue.Key         = cast(KEY)keys[1];
			CommandCallInput.value  = HotKeyValue;

			CommandFont = AppData.exeCommandFont();
			CommandFontSelect = new Push(CommandGroup, CTRL.COMMAND_FONT);
			CommandFontSelect.text = CommandFont.faceName;

			CommandHiddenInfo = new TextLabel(CommandGroup, CTRL.COMMAND_TIMER_INFO);
			//CommandHiddenInfo.text = Text("消滅時間");
			CommandHiddenInfo.text  = LanguageData.settingApplication(LD.SETTING_APPLICATION.COMMAND_HIDDEN);
			CommandHiddenInfo.horizonAlign = HORIZON_ALIGN.RIGHT;
			CommandHiddenInfo.verticalCenter = true;
			
			CommandHiddenInput = new EditLine(CommandGroup, CTRL.COMMAND_TIMER_INPUT);
			CommandHiddenInput.numberOnly=true;
			
			CommandHiddenSpin = new UpDown(CommandGroup, CTRL.COMMAND_TIMER_UPDOWN, UpDown.POSITION.RIGHT);
			CommandHiddenSpin.buddy = CommandHiddenInput;
			CommandHiddenSpin.range(-1, Integer.max);
			CommandHiddenSpin.value = AppData.exeCommandTimer();

			CommandColor = new ColorList(CommandGroup, CTRL.COMMAND_COLOR);
			/+
			CommandColor.columns = Texts("", "前景色", "背景色");
			CommandColor.lines   = Texts("ID", "NAME", "TAGS");
			+/
			CommandColor.columns = [
				Text.emptyText,
				LanguageData.settingApplication(LD.SETTING_APPLICATION.COMMAND_LIST_COLOR_FORE),
				LanguageData.settingApplication(LD.SETTING_APPLICATION.COMMAND_LIST_COLOR_BACK)
			];
			CommandColor.lines   = [
				LanguageData.settingApplication(LD.SETTING_APPLICATION.COMMAND_LIST_ID),
				LanguageData.settingApplication(LD.SETTING_APPLICATION.COMMAND_LIST_NAME),
				LanguageData.settingApplication(LD.SETTING_APPLICATION.COMMAND_LIST_TAG)
			];


			auto CommandColors = [
				AppData.exeCommandColor(App.COMMANDCOLOR.ID),
				AppData.exeCommandColor(App.COMMANDCOLOR.NAME),
				AppData.exeCommandColor(App.COMMANDCOLOR.TAG)
			];
			foreach(i, Colors; CommandColors) {
				foreach(j, color; Colors) {
					CommandColor.color(i, j+1, color);
				}
			}

			
			CommandGroup.font = CtrlFont;
			CommandFontSelect.font = CommandFont;

			
			CommandGroup.tuneSize = delegate(int Width, int Height, int CtrlHeight, ref const RECT InSize) {
				CommandHiddenSpin.reBuddy;
			};
			/+
			auto CommandPanel=new Line(DIRECTION.VERTICAL);
			CommandPanel.padding.bottom = FolderGroup.layoutManager.padding.bottom;
			CommandPanel += CommandIconSmall;
			CommandPanel.sizeInfo(0).absolute = FontHeight;
			CommandPanel += CommandIconNormal;
			CommandPanel.sizeInfo(1).absolute = FontHeight;
			CommandPanel += CommandCallInput;
			CommandPanel.sizeInfo(2).absolute = CtrlHeight;
			CommandPanel += CommandFontSelect;
			CommandPanel.sizeInfo(3).absolute = CtrlHeight;
			
			auto CommandHiddenPanel=new Dual(DIRECTION.HORIZON);
			CommandHiddenPanel[0] = CommandHiddenInfo;
			CommandHiddenPanel[1] = CommandHiddenInput;
			CommandHiddenPanel.sizeInfo.percent = 45;
			CommandHiddenPanel.centerSize = CtrlPadding.cx;
			CommandPanel += CommandHiddenPanel;
			CommandPanel.sizeInfo(4).absolute = CtrlHeight;
			
			CommandPanel += CommandColor;
			CommandPanel.sizeInfo(5).absolute = -1;
			
			CommandGroup.layoutManager.basePanel=CommandPanel;
			+/
			auto CommandPanel=new Dual(DIRECTION.HORIZON);
			CommandPanel.sizeInfo.percent = 50;
			CommandPanel.centerSize = GetControlPadding.cx;
			auto CommandLeftPanel=new Line(DIRECTION.VERTICAL);
			auto CommandRightPanel=new Line(DIRECTION.VERTICAL);
			CommandPanel[0] = CommandLeftPanel;
			CommandPanel[1] = CommandRightPanel;
			CommandLeftPanel.padding.bottom = GetControlPadding.cy;
			CommandRightPanel.padding.bottom = GetControlPadding.cy;
			auto CommandIconPanel=new Line(DIRECTION.HORIZON);
			CommandIconPanel += CommandIconSmall;
			CommandIconPanel += CommandIconNormal;
			CommandIconPanel.sizeInfo(0).percent = 40;
			CommandIconPanel.sizeInfo(1).percent = 40;
			CommandLeftPanel += CommandIconPanel;
			CommandLeftPanel.sizeInfo(0).absolute = CommandIconNormal.minContentHeight;
			auto CommandCallPanel=new Dual(DIRECTION.HORIZON);
			CommandCallPanel.centerSize = GetControlPadding.cx;
			CommandCallPanel.sizeInfo.percent = 40;
			CommandCallPanel[0] = CommandCallInfo;
			CommandCallPanel[1] = CommandCallInput;
			CommandLeftPanel += CommandCallPanel;
			CommandLeftPanel.sizeInfo(1).absolute = CommandCallInput.minContentHeight;
			auto CommandHiddenPanel=new Dual(DIRECTION.HORIZON);
			CommandHiddenPanel.sizeInfo.percent = 40;
			CommandHiddenPanel.centerSize = GetControlPadding.cx;
			CommandHiddenPanel[0] = CommandHiddenInfo;
			CommandHiddenPanel[1] = CommandHiddenInput;
			CommandLeftPanel += CommandHiddenPanel;
			CommandLeftPanel.sizeInfo(2).absolute = CommandHiddenInput.minContentHeight;

			CommandRightPanel += CommandFontSelect;
			CommandRightPanel.sizeInfo(0).absolute = CommandFontSelect.minContentHeight;
			CommandRightPanel += CommandColor;
			CommandRightPanel.sizeInfo(1).absolute = -1;
			
			CommandGroup.layoutManager.basePanel=CommandPanel;

			// グループの結合
			int GetContentHeight(Panel panel, size_t index=0) {
				// 適当な大きさを割り出し
				auto Height=new int[panel.length];
				for(auto i=0; i < panel.length; i++) {
					auto Content=panel[i];
					final switch(Content.type) {
						case CONTENT.TYPE.NONE:
							Height[i] = 0;//GetDefaultControlHeight(CtrlFont);
							break;
						case CONTENT.TYPE.PANEL:
							Height[i] = GetContentHeight(Content.panel, index+1);
							break;
						case CONTENT.TYPE.GUI:
							if(auto ctrl=cast(Control)Content.gui) {
								if(auto combo=cast(ComboBox)ctrl) {
									Height[i] = combo.editerHeight + GetControlPadding.cy*2;
								} else {
									Height[i] = ctrl.minContentHeight;
								}
							} else {
								Height[i] = GetDefaultControlHeight(CtrlFont);
							}
							break;
					}
				}
				if(auto direction=cast(IDirection)panel) {
					if(direction.direction == DIRECTION.HORIZON) {
						auto height=Height.sort[$-1];
						if(index) {
							return height;
						} else {
							return height + GetDefaultControlHeight(CtrlFont);
						}
					}
				}
				assert(index == 0);
				return std.algorithm.reduce!("a + b")(Height) + GetDefaultControlHeight(CtrlFont) + GetControlPadding.cy*2;
			}
			auto BasePanel=new Line(DIRECTION.VERTICAL);
			BasePanel += AppGroup;
			BasePanel += WindowGroup;
			BasePanel += FolderGroup;
			BasePanel += ButtonGroup;
			BasePanel += MenuGroup;
			BasePanel += CommandGroup;
			BasePanel.sizeInfo(0).absolute = GetContentHeight(BasePanel.gui(0).layoutManager.basePanel);//AppShortCutSelect.minContentHeight + GetDefaultControlHeight(CtrlFont);//GetContentHeight(BasePanel.gui(0).layoutManager.basePanel);
			BasePanel.sizeInfo(1).absolute = GetContentHeight(BasePanel.gui(1).layoutManager.basePanel);
			BasePanel.sizeInfo(2).absolute = GetContentHeight(BasePanel.gui(2).layoutManager.basePanel);
			BasePanel.sizeInfo(3).absolute = GetContentHeight(BasePanel.gui(3).layoutManager.basePanel);
			BasePanel.sizeInfo(4).absolute = GetContentHeight(BasePanel.gui(4).layoutManager.basePanel);
			BasePanel.sizeInfo(5).absolute = -1;//GetContentHeight(BasePanel.gui(5).layoutManager.basePanel);

			layoutManager.basePanel = BasePanel;
		}
		/**
		History:
			1.00β15:
				[S] アクセラレータ使用準備。
		*/
		void OnCreated() {
			auto hooker=StaticData.dllHooker;
			MenuDesktop.enable = FILE.isExistence(hooker) && FILE.isFile(hooker);
		}
		
		/+
		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			invariant CtrlHeight=GetDefaultControlHeight(CtrlFont);
			SIZE Padding=GetControlPadding();

			auto group=160;
			
			WindowGroup.move(0, 0, group, CtrlHeight*3+Padding.cy*4);
			ButtonGroup.move(0, CtrlHeight*3+Padding.cy*5, group, CtrlHeight*5+Padding.cy*6);

			MenuGroup.move(0, CtrlHeight*3+Padding.cy*5 + CtrlHeight*5+Padding.cy*7, group, CtrlHeight*6+Padding.cy*6);

			CommandGroup.move(group+10, 0, group, CtrlHeight*10+Padding.cy*11);
			FolderGroup.move(group+10, CtrlHeight*10+Padding.cy*11, group, CtrlHeight*5+Padding.cy*5);

			return true;
		}
		+/

		/**
		History:
			1.00β19:
				[B] リスト表示のUIが変になってバグる。
		*/
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(MessageType == Button.EVENT.CLICKED) {
				switch(Id) {
					case CTRL.BUTTON_TEXT:
						ButtonTextList.enable = ButtonTextSelect.checked;
						if(!ButtonTextSelect.checked) {
							ButtonTextList.checked = false;
						}
						return true;
					case CTRL.COMMAND_FONT:
						CommandFontSetting();
						return true;
					case CTRL.FOLDER_NORAML:
					case CTRL.FOLDER_EXPLORER:
						FolderOpenSelect.enable = false;
						return true;
					case CTRL.FOLDER_ITEM:
						FolderOpenSelect.enable = true;
						return true;
					default:
						return false;
				}
			}
			
			return false;
		}
		int OnNotify(ITEM_ID ItemID, NOTIFY* Notify) {
			if(ItemID == CTRL.COMMAND_COLOR && CommandColor) {
				return CommandColor.onNotify(Notify);
			}
			return 0;
		}
	}
}

