﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.itemdialog.itemdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(itemdialog) void main() {}

import std.string;
import std.conv;
import std.array;
import std.contracts;

import win32.windows;

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.linkitem;
import nemuxi.file.file;
import nemuxi.file.folder;
import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.negui.window.dialog.system;
import nemuxi.gui.window.dialog.selectdialog;
import nemuxi.negui.control.listbox.listbox;
//import nemuxi.gui.control.listbox;
import nemuxi.gui.control.listview;
import nemuxi.gui.control.combobox;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.button.group;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.label.label;
import nemuxi.gui.control.iteminput;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.dual;
import nemuxi.gui.control.button;
import nemuxi.negui.control.time.datetimepicker;
import nemuxi.negui.control.updown.updown;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.window.menu.popup;
import nemuxi.system.raii;
import nemuxi.gui.window.dialog.settingdialog.itemdialog.commanddata;
import nemuxi.gui.window.dialog.settingdialog.itemdialog.datasetctrl;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.gui.window.dialog.settingdialog.settingif;
import nemuxi.utility.convert.item;
import nemuxi.utility.convert.env;
import nemuxi.file.shortcut;

///
class ItemDataException: SettingException {
	mixin MixInNeGuiException;
}

/**
History:
	1.00β13:
		ショートカット処理判別用のフラグ追加。
*/
class ItemDialog: SelectDialog, ISettingInFrame {
	protected enum CTRL: ITEM_ID {
		ITEMLIST = 1,

		ITEM_MENU,

		ID_INFO,
		ID_INPUT,

		TYPE_INFO,
		TYPE_SELECT,

		NAME_INFO,
		NAME_INPUT,

		ADDRESS_INFO,
		ADDRESS_INPUT,
		//ADDRESS_SELECT_FILE,
		//ADDRESS_SELECT_FOLDER,

		WORKFOLDER_INFO,
		WORKFOLDER_INPUT,
		//WORKFOLDER_SELECT_FOLDER,

		OPTION_INFO,
		OPTION_INPUT,
		//OPTION_SELECT_FILE,
		//OPTION_SELECT_FOLDER,

		ICON_INFO,
		ICON_INPUT,
		//ICON_INDEX_SELECT,
		//ICON_SELECT,

		SHOW_INFO,
		SHOW_SELECT,

		KEY_INFO,
		KEY_SELECT,

		INFORMATION,
		INFORMATION_TAGS_INFO,
		INFORMATION_TAGS_LIST,
		INFORMATION_INFO,
		INFORMATION_INPUT,

		HISTORY,
		HISTORY_REGIST_INFO,
		HISTORY_REGIST_DATE,
		HISTORY_REGIST_TIME,
		HISTORY_USE_INFO,
		HISTORY_USE_DATE,
		HISTORY_USE_TIME,
		HISTORY_USE_COUNT,
		HISTORY_USE_COUNT_UD,
		HISTORY_WORKFOLDERS_INFO,
		HISTORY_WORKFOLDERS_LIST,
		HISTORY_OPTIONS_INFO,
		HISTORY_OPTIONS_LIST,
	}
	protected {
		Font CtrlFont;

		//ItemListBox Itemlist;
		ItemListView Itemlist;

		ToolBar ItemMenu;

		Push IdInfo;
		EditLine IdInput;

		TextLabel TypeInfo;
		TypeComboBox TypeSelect;

		Push NameInfo;
		EditLine NameInput;

		Push AddressInfo;
		ItemAddress AddressInput;

		Push WorkFolderInfo;
		EditLine WorkFolderInput;
		
		Push OptionInfo;
		EditLine OptionInput;

		Push IconInfo;
		EditLine IconInput;

		Push ShowInfo;
		ShowComboBox ShowSelect;

		Push KeyInfo;
		KeyComboBox KeySelect;

		GroupBox Information;
		ListBox InformationTagsList;
		Push InformationTagsInput;
		Push InformationInfo;
		MultiEdit InformationInput;
		
		GroupBox History;
		Push HistoryRegistInfo;
		DatePicker HistoryRegistDate;
		TimePicker HistoryRegistTime;
		Push HistoryUseInfo;
		DatePicker HistoryUseDate;
		TimePicker HistoryUseTime;
		EditLine HistoryUseCount;
		UpDown HistoryUseCountSpin;
		Push HistoryWorkFoldersInfo;
		ListBox HistoryWorkFoldersList;
		Push HistoryOptionsInfo;
		ListBox HistoryOptionsList;
	}
	protected {
		Item CurrentItem;
		Kareha ItemBase;
	//Item[] items;
		ItemIconPairs Pairs;
		bool ShortcutFlag;
	}
	//this(NeWindow Owner, Kareha ItemBase, Item[] items, bool ShortcutFlag) {//}
	this(NeWindow Owner, Kareha ItemBase, ItemIconPairs Pairs, bool ShortcutFlag) {
		//this.items   = items;
		this.Pairs   = Pairs;
		this.ItemBase  = ItemBase;
		this.ShortcutFlag = ShortcutFlag;
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner  = Owner;
		NeGuiInfo.Window = true;
		
		super(&NeGuiInfo, DIALOG_ID.init, CENTER.DESKTOP);
	}

	override {
		/+
		void setItemList(Item[] items) {
			assert(false);
		}
		Item[] getItemList() {
			return items;
		}
		+/
		void iiPairs(ItemIconPairs Pairs) {
			assert(false);
		}
		ItemIconPairs iiPairs() {
			return Pairs;
		}
	}
	mixin MixInSettingInFrame;
	override AkiDocument akiDocument() {
		auto aki = new AkiDocument;
		/+
		aki[`Item`] = __TIMESTAMP__;
		foreach(key; ItemBase.keys) {
			aki[`Item`][key]=ItemBase[key];
			aki[`Item`][key].comment=ItemBase[key].comment;
		}
		//aki[`Item`].fileKill;
		+/
		aki[`Item`] = __TIMESTAMP__;
		//auto list=Itemlist.getItemList;
		auto list=Itemlist.iiPairs;
		//for(auto i=0; i < list.length; i++) {//}
		foreach(i; 0 .. list.length) {
			/+
			aki[`Item`][list[i].itemID]=ItemBase[list[i].itemID];
			aki[`Item`][list[i].itemID].comment=ItemBase[list[i].itemID].comment;
			+/
			//aki[`Item`][list[i].itemID.toString]=ItemBase[list[i].itemID.toString];
			//aki[`Item`][list[i].itemID.toString].comment=ItemBase[list[i].itemID.toString].comment;
			aki[`Item`][list[i].left.itemID.toString]=ItemBase[list[i].left.itemID.toString];
			aki[`Item`][list[i].left.itemID.toString].comment=ItemBase[list[i].left.itemID.toString].comment;
		}
		return aki;
	}

	/+
	private void InitItem(Item[] items) {
		this.items=items;
		AddressInput.items=items;
		Itemlist.setItemList=items;
	}
	+/
	private void InitItem(ItemIconPairs Pairs) {
		this.Pairs=Pairs;
		
		AddressInput.iiPairs = Pairs;
		Itemlist.iiPairs = Pairs;
	}

	protected void ChangeItem(Item item) {
		if(item && item !is CurrentItem) {
			CurrentItem = item;
			Itemlist.selectID(item.itemID);
			SetItemData(CurrentItem);
		} else if(!item) {
			CurrentItem = null;
			SetItemData(null);
		}
	}

	private {
		void SetDataId(Item item) {
			SetData(item, true, item.itemID, IdInput);
		}
		void SetDataName(Item item) {
			SetData(item, true, item.name, NameInput);
		}
		void SetDataTypeAndAddress(Item item) {
			TypeSelect.initialize;
			if(item) {
				TypeSelect.select = item.type;
			} else {
				TypeSelect.select = Item.TYPE.NORMAL;
			}
			AddressInput.setItem(item);
		}
		void SetDataWorkFolder(Item item) {
			SetData(item, item.haveWorkFolder, item.workFolder, WorkFolderInput);
		}
		void SetDataOption(Item item) {
			SetData(item, item.haveOption, item.option, OptionInput);
		}
		void SetDataIconAddress(Item item) {
			SetData(item, item.haveIconAddress, item.iconAddress, IconInput);
			if(item && item.haveIconIndex) {
				IconInput.userData = new Kareha(item.iconIndex);
			} else {
				IconInput.userData = null;
			}
		}
		void SetDataShow(Item item) {
			SetDataLimited!(SHOW)(item, item.haveShow, item.show, ShowSelect);
		}
		void SetDataKey(Item item) {
			SetDataLimited!(KEY)(item, true, item.key, KeySelect);
		}
		void SetDataTags(Item item) {
			SetData(item, true, item.tags, InformationTagsList);
		}
		void SetDataInformation(Item item) {
			SetData(item, true, item.information, InformationInput);
		}
		void SetDataRegistDate(Item item) {
			SetData(item, item.historyResist, HistoryRegistDate, HistoryRegistTime);
		}
		void SetDataLastDate(Item item) {
			SetData(item, item.historyLast, HistoryUseDate, HistoryUseTime);
		}
		void SetDataUseCount(Item item) {
			SetData(item, item.historyUse, HistoryUseCount);
		}
		void SetDataWorkFolders(Item item) {
			SetData(item, item.haveHistoryWorkFolders, item.historyWorkFolders, HistoryWorkFoldersList);
		}
		void SetDataOptions(Item item) {
			SetData(item, item.haveHistoryOptions, item.historyOptions, HistoryOptionsList);
		}
	}

	protected void SetItemData(Item item) {
		SetDataId(item);
		SetDataName(item);
		SetDataTypeAndAddress(item);
		SetDataWorkFolder(item);
		SetDataOption(item);
		SetDataIconAddress(item);
		SetDataShow(item);
		SetDataKey(item);
		SetDataTags(item);
		SetDataInformation(item);
		SetDataRegistDate(item);
		SetDataLastDate(item);
		SetDataUseCount(item);
		SetDataWorkFolders(item);
		SetDataOptions(item);
	}

	protected override {
		void OnDestroy() {
			delete CtrlFont;
			super.OnDestroy();
		}
		/**
		History:
			1.00β15:
				[S] アクセラレータ使用準備。
		
			1.00β11:
				IconInputを書き込み可能に。
		*/
		void OnCreate() {
			super.OnCreate();
			AcceleratorClear();
			
			dropFile = true;
			
			CtrlFont = GetSystemFont(SYSFONT.MESSAGE);

			immutable CtrlPadding= GetControlPadding();
			
			auto BasePanel=new Dual(DIRECTION.HORIZON);
			BasePanel.centerSize = CtrlPadding.cx;
			BasePanel.sizeInfo.percent = 20;

			auto Contents=new Line(DIRECTION.VERTICAL);
			Contents.padding.top    = CtrlPadding.cy / 2;
			Contents.padding.bottom = CtrlPadding.cy - Contents.padding.top;

			// アイテム一覧
			Itemlist = new ItemListView(this, CTRL.ITEMLIST);
			//Itemlist.setItemList = items;
			//Itemlist.iiPairs = Pairs;
			Itemlist.font = CtrlFont;
			
			BasePanel[0] = Itemlist;
			BasePanel[1] = Contents;

			layoutManager.basePanel = BasePanel;

			//コントロール作成------------------

			auto ctrls=new Group!(Control);

			// アイテム
			ctrls += ItemMenu = new ToolBar(this, CTRL.ITEM_MENU);
			/+
			auto texts = Texts(
				"保存",
				"初期状態",
				"新規作成",
				"削除"
			);
			+/
			auto texts = [
				LanguageData.message(LD.MESSAGE.SAVE),
				LanguageData.message(LD.MESSAGE.INITIAL),
				LanguageData.message(LD.MESSAGE.NEW),
				LanguageData.message(LD.MESSAGE.DELETE)
			];
			auto images = [
				TOOLBUTTON.STANDARD.FILESAVE,
				TOOLBUTTON.STANDARD.UNDO,
				TOOLBUTTON.STANDARD.FILENEW,
				TOOLBUTTON.STANDARD.DELETE
			];
			
			ItemMenu.initialize;
			immutable ImageIndex=ItemMenu.bitmapAdd(ToolBar.SYSTEM_IMAGE.STANDARD_SMALL);
			
			auto ToolButtons=new TOOLBUTTON[texts.length];
			foreach(i, ref ToolButton; ToolButtons) {
				ToolButton.initialize;
				ToolButton.state = TOOLBUTTON.STATE.ENABLED;
				ToolButton.style = TOOLBUTTON.STYLE.BUTTON | TOOLBUTTON.STYLE.SHOWTEXT;
				
				ToolButton.systemImage = cast(TOOLBUTTON.IMAGE)(ImageIndex+images[i]);
				ToolButton.command = cast(COMMAND_ID)(ITEM_COMMAND.APPLY + i);
				ToolButton.text = texts[i];
			}

		ItemMenu.top = true;
		ItemMenu.noDivider = true;
		ItemMenu.noReSize = true;
			ItemMenu.autoSize;
			ItemMenu.buttonSet(ToolButtons);
			ItemMenu.list = true;
			
			//ID
			ctrls += IdInfo = new Push(this, CTRL.ID_INFO);
			ctrls += IdInput = new EditLine(this, CTRL.ID_INPUT);
			//IdInfo.text = Text("ID");
			IdInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.ID);
			
			//タイプ
			ctrls += TypeInfo = new TextLabel(this, CTRL.TYPE_INFO);
			ctrls += TypeSelect= new TypeComboBox(this, CTRL.TYPE_SELECT);
			//TypeInfo.text = Text("タイプ");
			TypeInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.TYPE);
			TypeInfo.horizonAlign = HORIZON_ALIGN.CENTER;
			TypeInfo.verticalCenter = true;
			
			//名前
			ctrls += NameInfo = new Push(this, CTRL.NAME_INFO);
			ctrls += NameInput = new EditLine(this, CTRL.NAME_INPUT);
			//NameInfo.text = Text("名前");
			NameInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.NAME);

			//アドレス
			ctrls += AddressInfo = new Push(this, CTRL.ADDRESS_INFO);
			ctrls += AddressInput = new ItemAddress(this, CTRL.ADDRESS_INPUT, null, null);
			//AddressInfo.text = Text("アドレス");
			AddressInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.ADDRESS);

			//作業フォルダ
			ctrls += WorkFolderInfo = new Push(this, CTRL.WORKFOLDER_INFO);
			ctrls += WorkFolderInput = new EditLine(this, CTRL.WORKFOLDER_INPUT);
			//WorkFolderInfo.text = Text("作業フォルダ");
			WorkFolderInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.WORK);

			//オプション
			ctrls += OptionInfo = new Push(this, CTRL.OPTION_INFO);
			ctrls += OptionInput = new EditLine(this, CTRL.OPTION_INPUT);
			//OptionInfo.text = Text("オプション");
			OptionInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.OPTION);

			//アイコン
			ctrls += IconInfo = new Push(this, CTRL.ICON_INFO);
			ctrls += IconInput = new EditLine(this, CTRL.ICON_INPUT);
			//IconInfo.text = Text("アイコン");
			IconInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.ICON);
			//IconInput.readOnly = true;

			//表示
			ctrls += ShowInfo = new Push(this, CTRL.SHOW_INFO);
			ctrls += ShowSelect = new ShowComboBox(this, CTRL.SHOW_SELECT);
			//ShowInfo.text = Text("表示");
			ShowInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.SHOW);

			//キー
			ctrls += KeyInfo = new Push(this, CTRL.KEY_INFO);
			ctrls += KeySelect = new KeyComboBox(this, CTRL.KEY_SELECT);
			//KeyInfo.text = Text("キー");
			KeyInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.KEY);

			//情報
			Information = new GroupBox(this, CTRL.INFORMATION);
			InformationTagsInput = new Push(Information, CTRL.INFORMATION_TAGS_INFO);
			InformationTagsList = new ListBox(Information, CTRL.INFORMATION_TAGS_LIST);
			InformationInfo = new Push(Information, CTRL.INFORMATION_INFO);
			InformationInput = new MultiEdit(Information, CTRL.INFORMATION_INPUT);
			/+
			Information.text = Text("情報");
			InformationTagsInput.text = Text("タグ");
			InformationInfo.text = Text("情報");
			+/
			Information.text = LanguageData.settingItem(LD.SETTING_ITEM.INFO);
			InformationTagsInput.text = LanguageData.settingItem(LD.SETTING_ITEM.INFO_TAG);
			InformationInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.INFO_MEMO);
			
			//履歴
			History = new GroupBox(this, CTRL.HISTORY);
			HistoryRegistInfo      = new Push(History, CTRL.HISTORY_REGIST_INFO);
			HistoryRegistDate      = new DatePicker(History, CTRL.HISTORY_REGIST_DATE);
			HistoryRegistTime      = new TimePicker(History, CTRL.HISTORY_REGIST_TIME);
			HistoryUseInfo         = new Push(History, CTRL.HISTORY_USE_INFO);
			HistoryUseDate         = new DatePicker(History, CTRL.HISTORY_USE_DATE);
			HistoryUseTime         = new TimePicker(History, CTRL.HISTORY_USE_TIME);
			HistoryUseCount        = new EditLine(History, CTRL.HISTORY_USE_COUNT);
			HistoryUseCount.numberOnly = true;
			HistoryUseCountSpin     = new UpDown(History, CTRL.HISTORY_USE_COUNT_UD);
			HistoryUseCountSpin.buddy = HistoryUseCount;
			HistoryUseCountSpin.range(0, int.max);
			HistoryWorkFoldersInfo = new Push(History, CTRL.HISTORY_WORKFOLDERS_INFO);
			HistoryWorkFoldersList = new ListBox(History, CTRL.HISTORY_WORKFOLDERS_LIST);
			HistoryOptionsInfo     = new Push(History, CTRL.HISTORY_OPTIONS_INFO);
			HistoryOptionsList     = new ListBox(History, CTRL.HISTORY_OPTIONS_LIST);
			/+
			History.text = Text("履歴");
			HistoryRegistInfo.text = Text("登録日時");
			HistoryUseInfo.text = Text("使用日時");
			HistoryWorkFoldersInfo.text = Text("作業フォルダ");
			HistoryOptionsInfo.text = Text("オプション");
			+/
			History.text = LanguageData.settingItem(LD.SETTING_ITEM.HISTORY);
			HistoryRegistInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.HISTORY_REGIST);
			HistoryUseInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.HISTORY_LAST);
			HistoryWorkFoldersInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.HISTORY_WORKS);
			HistoryOptionsInfo.text = LanguageData.settingItem(LD.SETTING_ITEM.HISTORY_OPTIONS);

			//フォント設定
			ctrls.font = CtrlFont;
			Information.font = CtrlFont;
			History.font = CtrlFont;

			// さーパネルがんばるかー -----------------------------
			
			// 固定値
			immutable FontHeight = GetFontHeightPx(CtrlFont);
			immutable CtrlHeight = GetDefaultControlHeight(CtrlFont);
			immutable ComboHeight= TypeSelect.editerHeight;

			immutable SINGLEDUAL_SIZE = 38;
			immutable DOUBLEDUAL_SIZE = 45;
			immutable DUALDUAL_SIZE   = 50;

			//ID+タイプ-------------------------

			//ID
			auto IdPanel=new Dual(DIRECTION.HORIZON);
			IdPanel[0] = IdInfo;
			IdPanel[1] = IdInput;
			IdPanel.sizeInfo.percent = DOUBLEDUAL_SIZE;

			//タイプ
			auto TypePanel=new Dual(DIRECTION.HORIZON);
			TypePanel[0] = TypeInfo;
			TypePanel[1] = TypeSelect;
			TypePanel.sizeInfo.percent = DUALDUAL_SIZE;

			//ID+タイプ
			auto IdTypePanel=new Dual(DIRECTION.HORIZON);
			IdTypePanel[0] = IdPanel;
			IdTypePanel[1] = TypePanel;
			IdTypePanel.sizeInfo.percent = DUALDUAL_SIZE;

			//名前
			auto NamePanel=new Dual(DIRECTION.HORIZON);
			NamePanel[0] = NameInfo;
			NamePanel[1] = NameInput;
			NamePanel.sizeInfo.percent = SINGLEDUAL_SIZE;

			//アドレス--------------------------
			auto AddressPanel=new Dual(DIRECTION.HORIZON);
			AddressPanel[0] = AddressInfo;
			AddressPanel[1] = AddressInput;
			AddressPanel.sizeInfo.percent = SINGLEDUAL_SIZE;

			//作業フォルダ----------------------
			auto WorkFolderPanel=new Dual(DIRECTION.HORIZON);
			WorkFolderPanel[0] = WorkFolderInfo;
			WorkFolderPanel[1] = WorkFolderInput;
			WorkFolderPanel.sizeInfo.percent = SINGLEDUAL_SIZE;

			//オプション------------------------
			auto OptionPanel=new Dual(DIRECTION.HORIZON);
			OptionPanel[0] = OptionInfo;
			OptionPanel[1] = OptionInput;
			OptionPanel.sizeInfo.percent = SINGLEDUAL_SIZE;

			//アイコン--------------------------
			auto IconPanel=new Dual(DIRECTION.HORIZON);
			IconPanel[0] = IconInfo;
			IconPanel[1] = IconInput;
			IconPanel.sizeInfo.percent = SINGLEDUAL_SIZE;

			//表示------------------------------
			auto ShowPanel=new Dual(DIRECTION.HORIZON);
			ShowPanel[0] = ShowInfo;
			ShowPanel[1] = ShowSelect;
			ShowPanel.sizeInfo.percent = DOUBLEDUAL_SIZE;

			//キー------------------------------
			auto KeyPanel=new Dual(DIRECTION.HORIZON);
			KeyPanel[0] = KeyInfo;
			KeyPanel[1] = KeySelect;
			KeyPanel.sizeInfo.percent = DOUBLEDUAL_SIZE;

			// 表示+キー
			auto ShowKeyPanel=new Dual(DIRECTION.HORIZON);
			ShowKeyPanel[0] = ShowPanel;
			ShowKeyPanel[1] = KeyPanel;
			ShowKeyPanel.sizeInfo.percent = DUALDUAL_SIZE;

			//情報 + 履歴 ----------------------

			//情報
			auto InformationPanel=new Line(DIRECTION.VERTICAL);
			InformationPanel += InformationTagsInput;
			InformationPanel += InformationTagsList;
			InformationPanel += InformationInfo;
			InformationPanel += InformationInput;
			InformationPanel.sizeInfo(0).absolute= CtrlHeight;
			InformationPanel.sizeInfo(1).percent = 35;
			InformationPanel.sizeInfo(2).absolute= CtrlHeight;
			InformationPanel.sizeInfo(3).absolute= -1;
			
			Information.layoutManager.basePanel = InformationPanel;

			//履歴
			immutable GROUP_IN_SIZE = 18;
			//登録
			auto HistoryRegistInputPanel = new Tansu(DIRECTION.HORIZON);
			HistoryRegistInputPanel += HistoryRegistDate;
			HistoryRegistInputPanel += HistoryRegistTime;
			HistoryRegistInputPanel += null;
			HistoryRegistInputPanel.sizeInfo.percent = 40;
			auto HistoryRegistPanel=new Dual(DIRECTION.HORIZON);
			HistoryRegistPanel[0] = HistoryRegistInfo;
			HistoryRegistPanel[1] = HistoryRegistInputPanel;
			HistoryRegistPanel.sizeInfo.percent = GROUP_IN_SIZE;

			//使用
			auto HistoryUseInputPanel = new Tansu(DIRECTION.HORIZON);
			HistoryUseInputPanel += HistoryUseDate;
			HistoryUseInputPanel += HistoryUseTime;
			HistoryUseInputPanel += HistoryUseCount;
			HistoryUseInputPanel.sizeInfo.percent = 40;
			auto HistoryUsePanel=new Dual(DIRECTION.HORIZON);
			HistoryUsePanel[0] = HistoryUseInfo;
			HistoryUsePanel[1] = HistoryUseInputPanel;
			HistoryUsePanel.sizeInfo.percent = GROUP_IN_SIZE;

			//作業フォルダ
			auto HistoryWorkFoldersPanel=new Dual(DIRECTION.VERTICAL);
			HistoryWorkFoldersPanel[0] = HistoryWorkFoldersInfo;
			HistoryWorkFoldersPanel[1] = HistoryWorkFoldersList;
			HistoryWorkFoldersPanel.sizeInfo.absolute = CtrlHeight;

			//オプション
			auto HistoryOptionsPanel=new Dual(DIRECTION.VERTICAL);
			HistoryOptionsPanel[0] = HistoryOptionsInfo;
			HistoryOptionsPanel[1] = HistoryOptionsList;
			HistoryOptionsPanel.sizeInfo.absolute = CtrlHeight;

			//作業フォルダ+オプション
			auto HistoryListpanel=new Dual(DIRECTION.HORIZON);
			HistoryListpanel[0] = HistoryWorkFoldersPanel;
			HistoryListpanel[1] = HistoryOptionsPanel;
			HistoryListpanel.sizeInfo.percent = DUALDUAL_SIZE;

			//履歴
			auto HistoryPanel=new Line(DIRECTION.VERTICAL);
			HistoryPanel += HistoryRegistPanel;
			HistoryPanel += HistoryUsePanel;
			HistoryPanel += HistoryListpanel;
			HistoryPanel.sizeInfo(0).absolute= CtrlHeight;
			HistoryPanel.sizeInfo(1).absolute= CtrlHeight;
			HistoryPanel.sizeInfo(2).absolute= -1;
			
			History.layoutManager.basePanel = HistoryPanel;
			History.tuneSize = delegate(int Width, int Height, int CtrlHeight, ref const RECT InSize) {
				HistoryUseCountSpin.reBuddy;
			};
			//情報+履歴,長…
			auto InformationHistoryPanel=new Dual(DIRECTION.HORIZON);
			InformationHistoryPanel[0] = Information;
			InformationHistoryPanel[1] = History;
			InformationHistoryPanel.sizeInfo.percent = SINGLEDUAL_SIZE;

			Contents += ItemMenu;
			Contents += IdTypePanel;
			Contents += NamePanel;
			Contents += AddressPanel;
			Contents += WorkFolderPanel;
			Contents += OptionPanel;
			Contents += IconPanel;
			Contents += ShowKeyPanel;
			Contents += InformationHistoryPanel;
			Contents.sizeInfo(0).absolute = ItemMenu.buttonSize.cy;
			Contents.sizeInfo(1).absolute = ComboHeight;
			Contents.sizeInfo(2).absolute = ComboHeight;
			Contents.sizeInfo(3).absolute = ComboHeight;
			Contents.sizeInfo(4).absolute = CtrlHeight;
			Contents.sizeInfo(5).absolute = CtrlHeight;
			Contents.sizeInfo(6).absolute = CtrlHeight;
			Contents.sizeInfo(7).absolute = CtrlHeight;
			Contents.sizeInfo(8).absolute = -1;
		}
		
		/**
		History:
			1.00β15:
				[S] アクセラレータ使用準備。
		*/
		void OnCreated() {
			TypeSelect.initialize;
			KeySelect.initialize;
			ShowSelect.initialize;
			HistoryUseCount.number=0;
			
			//InitItem(items);
			InitItem(Pairs);
			//ChangeItem(items.length ? items[0]: null);
			ChangeItem(Pairs.length ? Pairs[0].left: null);
		}

		/**
		History:
			1.00β16:
				[B] リストへのD&D時にリストの選択が解除されない不具合を修正。
		
			1.00β14:
				[P] D&D時にポインタが左のリストっぽいやつの上にあれば新規作成処理。

			1.00β13:
				[F] ショートカット(*.lnk)に半対応。
		*/
		void OnDropFiles(DropFile drop) {
			try {
				enforce(drop.length == 1, new ItemDataException(Text("D&Dファイルは一つまで")));

				auto File=drop[0];

				enforce(FILE.isExistence(File), new ItemDataException(Text("え？")));

				
				if(this.child(drop.point) is Itemlist) {
					// アイテムの新規追加
					Itemlist.select(-1, false);
					LISTITEM ListItem;
					ListItem.index = Itemlist.next(ListView.NEXT.ALL | ListView.NEXT.SELECTED);
					if(ListItem.index >= 0) {
		ListItem.mask      = LISTITEM.MASK.STATE;
//		ListItem.stateMask = LISTITEM.STATE.SELECTED;
						Itemlist.set(&ListItem);
					}
					ChangeItem(null);
				} else {
					// 現状維持して項目設定。
					TypeSelect.select = Item.TYPE.NORMAL;
					OnCommand(CTRL.TYPE_SELECT, ComboBox.EVENT.LISTCHANGE, TypeSelect);
				}
				assert(AddressInput.type == Item.TYPE.NORMAL);
				
				if(ShortcutFlag && !PATH.cmp(PATH.getExtension(File), Text("lnk"))) {
					// ショートカット
					scope link=new Shortcut(this);
					link.fileLoad(File, STGM.READ);
					
					// とりあえずID残して全部消す
					const id=IdInput.text;
					SetItemData(null);
					
					NameInput.text = PATH.getName(File);;
					AddressInput.text = link.address;;
					WorkFolderInput.text = link.workFolder;
					OptionInput.text = link.option;
					int Index;
					IconInput.text = link.getIcon(Index);
					IconInput.userData = new Kareha(Index);

					ShowSelect.select = link.show;
					InformationInput.text = link.comment;
					
					KeySelect.select = GetKeyFromText(NameInput.text);

					if(CurrentItem && id.length) {
						IdInput.text = id;
					} else {
						IdInput.text = GetIdFromFileAddress(File);
					}
				} else {
					// ファイル
					AddressInput.text = File;
					OnMenuCommand(ITEM_COMMAND.CHANGE_ADDRESSBASE);
				}
			}catch(Exception e) {
				ShowExceptionDialog(this, e);
			}
		}
		
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) {
			if(Id == CTRL.ITEMLIST) {
				switch(Notify.code) {
					case ListView.EVENT.ITEMCHANGED:
						auto ListViewMessage=cast(LISTVIEWMESSAGE*)Notify.ptr;
						if(auto pPair=(cast(size_t)ListViewMessage.data in iiPairs)) {
							ChangeItem(pPair.left);
						}
						return 0;
					default:
						return 0;
				}
			}
			return 0;
		}
		
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Sender is ItemMenu) {
				return OnMenuCommand(cast(COMMAND_ID)Id);
			} /+else if(Id == CTRL.ITEMLIST) {
				assert(Sender is Itemlist);
				+//+
				if(MessageType == ListBox.EVENT.SELCHANGE) {
					if(Itemlist.isSelect)
					ChangeItem(Itemlist.selectItem);
					return true;
				}
				return false;
				+/
			//}
			else switch(MessageType) {
				case Button.EVENT.CLICKED: {
					MENUITEMDATA[] MenuItemDatas;
					
					with(ITEM_COMMAND) switch(Id) {
						case CTRL.ID_INFO:
							MenuItemDatas = InitMenuData.id;
							//---------------------
							MenuItemDatas[0].enable = AddressInput.type == Item.TYPE.NORMAL;
							break;
						
						case CTRL.NAME_INFO:
							MenuItemDatas = InitMenuData.name;
							//---------------------
							MenuItemDatas[0].enable = AddressInput.type == Item.TYPE.NORMAL;
							break;
						
						case CTRL.ADDRESS_INFO:
							MenuItemDatas = InitMenuData.address;
							//---------------------
							auto Type=AddressInput.type;
							auto Enable=Type == Item.TYPE.NORMAL || Type == Item.TYPE.URI;
							MenuItemDatas[0].enable = Enable;
							MenuItemDatas[1].enable = Enable;
							MenuItemDatas[3].enable = Type == Item.TYPE.NORMAL;
							break;
						
						case CTRL.WORKFOLDER_INFO:
							MenuItemDatas = InitMenuData.wrokFolder;
							//---------------------
							MenuItemDatas[2].enable = AddressInput.type == Item.TYPE.NORMAL;
							break;
						
						case CTRL.OPTION_INFO:
							MenuItemDatas = InitMenuData.option;
							break;
						
						case CTRL.ICON_INFO:
							MenuItemDatas = InitMenuData.icon;
							//---------------------
							MenuItemDatas[2].enable = AddressInput.type == Item.TYPE.NORMAL;
							break;
						
						case CTRL.SHOW_INFO:
							MenuItemDatas = InitMenuData.show;
							break;
						
						case CTRL.KEY_INFO:
							MenuItemDatas = InitMenuData.key;
							//---------------------
							MenuItemDatas[0].enable=cast(bool)NameInput.text.length;
							MenuItemDatas[1].enable=cast(bool)IdInput.text.length;
							break;
						
						case CTRL.INFORMATION_TAGS_INFO:
							MenuItemDatas = InitMenuData.tags;
							//---------------------
							auto Selected=InformationTagsList.isSelect();
							MenuItemDatas[1].enable=Selected;
							MenuItemDatas[2].enable=Selected;
							MenuItemDatas[3].enable=InformationTagsList.count != 0;
							break;
						
						case CTRL.INFORMATION_INFO:
							MenuItemDatas = InitMenuData.information;
							break;
						
						case CTRL.HISTORY_REGIST_INFO:
							MenuItemDatas = InitMenuData.regist;
							break;
						
						case CTRL.HISTORY_USE_INFO:
							MenuItemDatas = InitMenuData.use;
							break;
						
						case CTRL.HISTORY_WORKFOLDERS_INFO:
							MenuItemDatas = InitMenuData.historyWorkFolders;
							//---------------------
							MenuItemDatas[0].enable=HistoryWorkFoldersList.isSelect;
							MenuItemDatas[1].enable=cast(bool)HistoryWorkFoldersList.count != 0;
							break;
						
						case CTRL.HISTORY_OPTIONS_INFO:
							MenuItemDatas = InitMenuData.historyOptions;
							//---------------------
							MenuItemDatas[0].enable=HistoryOptionsList.isSelect;
							MenuItemDatas[1].enable=cast(bool)HistoryOptionsList.count != 0;
							break;
						
						default:
							return false;
					}
					
					
					scope menu=new PopUp();
					
					foreach(MenuItemData; MenuItemDatas) {
						if(MenuItemData.id) {
							//menu.insertText(MenuItemData.id, MenuItemData.name.toText, MenuItemData.enable);
							menu.insertText(MenuItemData.id, MenuItemData.name, MenuItemData.enable);
						} else {
							menu.insertSeparator(-1);
						}
					}
					menu.attach(this, Sender, PopUp.ATTACH.RIGHT, PopUp.MESSAGE.OWNER);
					
					return true;
				}
				
				case ComboBox.EVENT.LISTCHANGE: {
					if(Id == CTRL.TYPE_SELECT) {
						assert(Sender is TypeSelect);
						AddressInput.changeType = TypeSelect.select;
						return true;
					}
					break;
				}

				
				default:
					break;
			}
			return false;
		}

		/**
		Bugs:
			初期値未実装

		History:
			1.00β15:
				[P] ファイル選択時初期値実装。
				[P] フォルダ選択時初期値実装。
				[P] 作業フォルダ選択時初期値実装。
				[P] アイコン選択時初期値実装。
				
			
			1.00β12:
				アイテムに合わせる機能を実装。
		*/
		bool OnMenuCommand(COMMAND_ID Id) {
			immutable CommandID = cast(ITEM_COMMAND)Id;
			with(ITEM_COMMAND) switch(CommandID) {
				case APPLY: {
					try {
						ApplyCeck();
						ApplySave();
					} catch(ItemSetException e) {
						ShowExceptionDialog(this, e);
					}
					return true;
				}
				
				case INIT: {
					if(CurrentItem)
						SetItemData(CurrentItem);
					return true;
				}

				case NEW: {
					//SetItemData(null);
					//Itemlist.select = -1;
/+
					LISTITEM ListItem;
					ListItem.index = Itemlist.next(ListView.NEXT.ALL | ListView.NEXT.SELECTED);
					if(ListItem.index >= 0) {
		ListItem.mask      = LISTITEM.MASK.STATE;
//		ListItem.stateMask = LISTITEM.STATE.SELECTED;
						Itemlist.set(&ListItem);
					}
+/
					Itemlist.select(-1, false);

					ChangeItem(null);
					return true;
				}

				case DEL: {
					if(CurrentItem)
					DelItem(CurrentItem);
					return true;
				}

				// アドレスからIDを設定
				case CHANGE_ID_ADDRRES: {
					assert(AddressInput.type == Item.TYPE.NORMAL);
					/+
					const Name = PATH.getName(AddressInput.text);
					if(Item.isID(Name.toString())) {
						IdInput.text = Name;
					} else {
						MessageDialog.show(Name ~ "からの変換に失敗");
					}
					+/
					try {
						IdInput.text = GetIdFromFileAddress(AddressInput.text);
					} catch(ConvertException e) {
						ShowExceptionDialog(this, e);
					}
					return true;
				}

				//アドレスから名前を設定
				case CHANGE_NAME_ADDRESS: {
					assert(AddressInput.type == Item.TYPE.NORMAL);
					//NameInput.text = PATH.getName(AddressInput.text);
					try {
						NameInput.text = GetNameFromFileAddress(AddressInput.text);
					} catch(ConvertException e) {
						ShowExceptionDialog(this, e);
					}
					
					return true;
				}

				//IDから名前を設定
				case CHANGE_NAME_ID: {
					NameInput.text = IdInput.text;
					return true;
				}

				//ファイル選択
				case SELECT_ADDRESS_FILE: {
					assert(AddressInput.type == Item.TYPE.NORMAL || AddressInput.type == Item.TYPE.NORMAL.URI);
					scope dialog=new OpenDialog();
					dialog.initialize();
					dialog.ownerWindow=this;
					OpenDialog.FILTER[] filter;
					auto FiltersList=StaticData.fileFilter;
					foreach(Filters; FiltersList) {
						filter ~= OpenDialog.FILTER(Filters[0], Filters[1..$]);
					}
					dialog.filter = filter;
					dialog.flags = OpenDialog.FLAGS.DEFAULT;
					//初期値
					const Address=AddressInput.text;
					if(FILE.isExistence(Address) && FILE.isFile(Address)) {
						dialog.currentFolder = PATH.getOwnerFolder(Address);
					} else {
						dialog.currentFolder = GetSystemFolder(SYS_FOLDER.PERSONAL);
					}
					
					if(dialog.select()) {
						AddressInput.text = dialog.fileAddress;
						if(AddressInput.type == Item.TYPE.NORMAL) {
							try {
								ChangeAddressBase();
							} catch(Exception e) {
								ShowExceptionDialog(this, e);
							}
						}
					}
					return true;
				}

				//フォルダ選択
				case SELECT_ADDRESS_FOLDER: {
					assert(AddressInput.type == Item.TYPE.NORMAL || AddressInput.type == Item.TYPE.NORMAL.URI);
					scope dialog=new FolderDialog();
					dialog.ownerWindow=this;
					dialog.flags = FolderDialog.FLAGS.DEFAULT;
					//初期値
					const Folder=AddressInput.text;
					if(FILE.isExistence(Folder)) {
						if(FILE.isFolder(Folder)) {
							dialog.folderAddress = Folder;
						} else {
							dialog.folderAddress = PATH.getOwnerFolder(Folder);
						}
					}
					try {
						if(dialog.select()) {
							AddressInput.text = dialog.folderAddress;
							if(AddressInput.type == Item.TYPE.NORMAL) {
								try {
									ChangeAddressBase();
								} catch(Exception e) {
									throw new ItemDataException(Text("だめぽ"), NGEC.NONE, e);
								}
							}
						}
					} catch(Exception e) {
						Logger.write(e);
						ShowExceptionDialog(this, e);
					}
					return true;
				}

				case CHANGE_ADDRESSBASE: {
					assert(AddressInput.type == Item.TYPE.NORMAL);

					//MessageDialog.show(Text(`未実装`));

					try {
						ChangeAddressBase();
					} catch(Exception e) {
						Logger.write(e);
						ShowExceptionDialog(this, e);
						return false;
					}
					return true;
				}

				//作業フォルダ選択
				case SELECT_WORKFOLDER_FOLDER: {
					scope dialog=new FolderDialog();
					dialog.ownerWindow=this;
					dialog.flags = FolderDialog.FLAGS.DEFAULT;
					//初期値
					const Folder=WorkFolderInput.text;
					if(FILE.isExistence(Folder) && FILE.isFolder(Folder)) {
						dialog.folderAddress = Folder;
					}
					try {
						if(dialog.select()) {
							WorkFolderInput.text = dialog.folderAddress;
						}
					} catch(Exception e) {
						Logger.write(e);
						ShowExceptionDialog(this, e);
					}
					return true;
				}
				
				case CHANGE_WORKFOLDER_ADDRESS: {
					assert(AddressInput.type == Item.TYPE.NORMAL);
					WorkFolderInput.text = PATH.getOwnerFolder(AddressInput.text);
					return true;
				}

				case INPUT_OPTION: {
					INPUTSTATUS Status;
					Status.InputText = true;
					Status.FileSelect = true;
					Status.FolderSelect = true;
					Status.CanselSelect = true;
					Status.InitText = OptionInput.text;
					//Status.FileTitleText = ;
					//Status.FolderTitleText = ;
					
					OpenDialog.FILTER[] filter;
					auto FiltersList=StaticData.fileFilter;
					foreach(Filters; FiltersList) {
						filter ~= OpenDialog.FILTER(Filters[0], Filters[1..$]);
					}
					Status.Filter = filter;
					scope dialog=new InputDialog(cast(NeWindow)parent, Status);
					if(dialog.select) {
						OptionInput.text = dialog.inputText;
					}
					return true;
				}

				//アイコン選択
				case SELECT_ICON_ICON: {
					scope dialog=new IconDialog();
					dialog.ownerWindow=this;
					//初期値
					const IconAddress=IconInput.text;
					auto IconIndex=0;
					if(FILE.isExistence(toPlain(IconAddress))) {
						if(auto data=IconInput.userData) {
							if(auto index=cast(Kareha)data) {
								IconIndex = index.get!(Integer);
							}
						}
					}
					dialog.iconAddress = IconAddress;
					dialog.iconIndex   = IconIndex;
					if(dialog.select) {
						IconInput.text = dialog.iconAddress;
						IconInput.userData = new Kareha(dialog.iconIndex);
					}
					return true;
				}

				case CHANGE_ICON_ADDRESS: {
					IconInput.text = AddressInput.text;
					IconInput.userData = null;
					return true;
				}

				case CHANGE_KEY_NAME, CHANGE_KEY_ID: {
					EditLine edit;
					if(Id == CHANGE_KEY_NAME) {
						edit = NameInput;
					} else {
						edit = IdInput;
					}
					try {
						KeySelect.select = GetKeyFromText(edit.text);
					} catch(Exception e) {
						Logger.write(e);
						ShowExceptionDialog(this, e);
					}
					return true;
				}

				case INPUT_TAGS, EDIT_TAGS: {
					INPUTSTATUS Status;
					Status.InputText = true;
					//Status.FileSelect = true;
					//Status.FolderSelect = true;
					Status.CanselSelect = true;
					int EditNumber=-1;
					if(Id == EDIT_TAGS) {
						assert(InformationTagsList.isSelect());
						EditNumber = InformationTagsList.select;
						Status.InitText = InformationTagsList.listText(EditNumber);
					}
					scope dialog=new InputDialog(cast(NeWindow)parent, Status);
					if(dialog.select) {
						if(EditNumber != -1) {
							InformationTagsList[EditNumber] = dialog.inputText;
						} else {
							InformationTagsList += dialog.inputText;
						}
					}
					return true;
				}
				
				case CHANGE_LASTUSE_REGIST: {
					auto t=HistoryRegistDate.value;
					auto d=HistoryRegistTime.value;
					auto dt=new DateTime(
						t.year, t.month, t.day,
						d.hour, d.minute, d.second, d.ms
					);
					ChangeData(dt, HistoryUseDate, HistoryUseTime);
					return true;
				}

				case CHANGE_LASTUSE_COUNT: {
					ChangeData(0, HistoryUseCount);
					return true;
				}

				case CLEAR_TAGS_SELECT, CLEAR_HISTORY_WORKFOLDERS_SELECT, CLEAR_HISTORY_OPTIONS_SELECT: {
					ListBox ctrl;
					switch(Id) {
						case CLEAR_TAGS_SELECT:                ctrl = InformationTagsList;    break;
						case CLEAR_HISTORY_WORKFOLDERS_SELECT: ctrl = HistoryWorkFoldersList; break;
						case CLEAR_HISTORY_OPTIONS_SELECT:     ctrl = HistoryOptionsList;     break;
						default: assert(false);
					}
					assert(ctrl.isSelect());
					ctrl.del(ctrl.select);
					
					return true;
				}
				
				case CLEAR_TAGS_ALL, CLEAR_HISTORY_WORKFOLDERS_ALL, CLEAR_HISTORY_OPTIONS_ALL: {
					ListBox ctrl;
					switch(Id) {
						case CLEAR_TAGS_ALL:                ctrl = InformationTagsList;    break;
						case CLEAR_HISTORY_WORKFOLDERS_ALL: ctrl = HistoryWorkFoldersList; break;
						case CLEAR_HISTORY_OPTIONS_ALL:     ctrl = HistoryOptionsList;     break;
						default: assert(false);
					}
					assert(ctrl.count != 0);
					ctrl.clear;
					return true;
				}

				case CHANGE_REGIST_NOW, CHANGE_LASTUSE_NOW: {
					/+
					auto time=new DateTime;
					HistoryRegistDate.value = time;
					HistoryRegistTime.value = time;
					+/
					DatePicker d = (Id == CHANGE_REGIST_NOW) ? HistoryRegistDate: HistoryUseDate;
					TimePicker t = (Id == CHANGE_REGIST_NOW) ? HistoryRegistTime: HistoryUseTime;
					ChangeData(new DateTime, d, t);
					return true;
				}

				case
				INIT_ID,
				INIT_NAME,
				INIT_ADDRESS,
				INIT_WORKFOLDER,
				INIT_OPTION,
				INIT_ICON,
				INIT_SHOW,
				INIT_KEY,
				INIT_INFORMATION,
				INIT_TAGS,
				INIT_REGIST,
				INIT_LASTUSE,
				INIT_HISTORY_WORKFOLDERS,
				INIT_HISTORY_OPTIONS
				:
				switch(Id) {
					case INIT_ID:
						SetDataId(CurrentItem);
						break;
					case INIT_NAME:
						SetDataName(CurrentItem);
						break;
					case INIT_ADDRESS:
						SetDataTypeAndAddress(CurrentItem);
						break;
					case INIT_WORKFOLDER:
						SetDataWorkFolder(CurrentItem);
						break;
					case INIT_OPTION:
						SetDataOption(CurrentItem);
						break;
					case INIT_ICON:
						SetDataIconAddress(CurrentItem);
						break;
					case INIT_SHOW:
						SetDataShow(CurrentItem);
						break;
					case INIT_KEY:
						SetDataKey(CurrentItem);
						break;
					case INIT_INFORMATION:
						SetDataInformation(CurrentItem);
						break;
					case INIT_TAGS:
						SetDataTags(CurrentItem);
						break;
					case INIT_REGIST:
						SetDataRegistDate(CurrentItem);
						break;
					case INIT_LASTUSE:
						SetDataLastDate(CurrentItem);
						SetDataUseCount(CurrentItem);
						break;
					case INIT_HISTORY_WORKFOLDERS:
						SetDataWorkFolders(CurrentItem);
						break;
					case INIT_HISTORY_OPTIONS:
						SetDataOptions(CurrentItem);
						break;
					default:
						assert(false);
				}
				return true;

				
				default:
					return false;
			}
		}

	}

	/**
	とりあえずチェック。

	History:
		1.00β14:
			[F] アドレスが環境変数を含んでいる場合の対処。
			[P] アドレスの有効チェックを若干変更。

		1.00β12:
			IDチェック時に長さチェックと有効チェックを分けた。
			作業フォルダ・アイコンのチェックを緩めに。
	*/
	private void ApplyCeck() {
		ItemSetException[] es;

		//ID
		if(!IdInput.textLength) {
			es ~= new ItemSetException("ID未入力");
		} else if(!Item.isID(IdInput.text)) {
			es ~= new ItemSetException(IdInput.text ~ "はIDに使用不可");
		}
		if(!CurrentItem) {
			//新規作成
			//foreach(value; items) {
			foreach(value; 0 .. Pairs.length) {
				//if(IdInput.text == value.itemID) {
				if(IdInput.text == Pairs[value].left.itemID) {
					//es ~= new ItemSetException(value.itemID ~ "は既に存在する");
					es ~= new ItemSetException(Pairs[value].left.itemID ~ "は既に存在する");
				}
			}
		}
		//名前
		if(!NameInput.textLength) {
			es ~= new ItemSetException("名前未入力");
		}

		//アドレス
		with(Item.TYPE) switch(AddressInput.type) {
			case NORMAL:
				if(!AddressInput.addr.textLength) {
					es ~= new ItemSetException("アドレス未記入");
				} else if(!FILE.isExistence(toPlain(AddressInput.addr.text))) {
					es ~= new ItemSetException("指定アドレス無効");
				}
				break;
			case URI:
				if(!AddressInput.uri.textLength) {
					es ~= new ItemSetException("URI未記入");
				}
				break;
			case MULTI:
				break;
			case LINK:
				break;
			default:
				assert(false);
		}

		//作業フォルダ
		const Folder=toPlain(WorkFolderInput.text);
		if(Folder.length) {
			if(!FILE.isExistence(Folder)) {
				es ~= new ItemSetException("フォルダが変");
			} else if(!FILE.isFolder(Folder)) {
				es ~= new ItemSetException("フォルダじゃない");
			}
		}
		
		//アイコン
		if(IconInput.textLength && !FILE.isExistence(toPlain(IconInput.text))) {
			es ~= new ItemSetException("アイコンが変");
		}
		

		if(es.length) {
			for(auto i=0; i < es.length - 1; i++) {
				es[i].next = es[i+1];
			}
			throw es[0];
		}
	}

	private void ApplySave()
	in {
		try {
			ApplyCeck();
		} catch(Throwable e) {
			assert(false, e.toString);
		}
	}
	body {
		auto k=new Kareki;
		immutable ID=IdInput.text.toString;
		
		k[ID] = NameInput.text.toString;
		k[ID].comment=InformationInput.text.toString;
		
		k[ID, Item.TREE.TYPE] = AddressInput.type;
		with(Item.TYPE) switch(AddressInput.type) {
			case NORMAL: k[ID, Item.TREE.ADDRESS] = AddressInput.addr.text.toString;     break;
			case URI:    k[ID, Item.TREE.ADDRESS] = AddressInput.uri.text.toString;      break;
			case MULTI:  k[ID, Item.TREE.ADDRESS] = Strings(AddressInput.multi.getItemId); break;
			//case LINK:   k[ID, Item.TREE.ADDRESS] = AddressInput.link.selectItem.itemID.toString; break;
			case LINK:   k[ID, Item.TREE.ADDRESS] = AddressInput.link.selectID.toString; break;
			default: assert(false);
		}
		k[ID, Item.TREE.WORKFOLDER] = WorkFolderInput.text.toString;
		k[ID, Item.TREE.OPTION]     = OptionInput.text.toString;
		k[ID, Item.TREE.ICON, Item.TREE.ICON_ADDRESS] = IconInput.text.toString;
		k[ID, Item.TREE.ICON, Item.TREE.ICON_INDEX]   = IconInput.userData ? (cast(Kareha)IconInput.userData).get!(Integer): 0;
		k[ID, Item.TREE.SHOW]     = ShowSelect.select;
		if(auto list = InformationTagsList[]) {
			k[ID, Item.TREE.TAGS]     = Strings(list);
		}
		k[ID, Item.TREE.KEY]     = KeySelect.select;
		
		if(auto list = HistoryWorkFoldersList[]) {
			k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_WORKFOLDERS] = Strings(list);
		} else {
			k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_WORKFOLDERS] = cast(string[])null;
		}
		if(auto list = HistoryOptionsList[]) {
			k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_OPTIONS] = Strings(list);
		} else {
			k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_OPTIONS] = cast(string[])null;
		}

		auto t=HistoryRegistDate.value;
		auto d=HistoryRegistTime.value;
		auto Regist=new ItemDateTime(
			t.year, t.month, t.day,
			d.hour, d.minute, d.second, d.ms
		);
		k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_REGIST] = Regist.toString;
		t=HistoryUseDate.value;
		d=HistoryUseTime.value;
		auto Last=new ItemDateTime(
			t.year, t.month, t.day,
			d.hour, d.minute, d.second, d.ms
		);
		k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_LAST] = Last.toString;

		k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_USE] = HistoryUseCountSpin.value;//to!(Integer)(HistoryUseCount.text.toString);

		auto item=new Item(ID.toText, k);
		//wl("%s",join(k.toStrings,"\n"));
		if(CurrentItem/* && item.itemID == CurrentItem.itemID*/) {
			//上書き
			CurrentItem.name = k[ID].get!(string).toText;
			CurrentItem.information = k[ID].comment.toText;
			switch(cast(Item.TYPE)k[ID, Item.TREE.TYPE].get!(Integer)) {
				case Item.TYPE.NORMAL: CurrentItem.address = k[ID, Item.TREE.ADDRESS].get!(string).toText;   break;
				case Item.TYPE.URI:    CurrentItem.uri     = k[ID, Item.TREE.ADDRESS].get!(string).toText;   break;
				case Item.TYPE.MULTI:  CurrentItem.multi   = Texts(k[ID, Item.TREE.ADDRESS].get!(string[])); break;
				case Item.TYPE.LINK:   CurrentItem.link    = k[ID, Item.TREE.ADDRESS].get!(string).toText;   break;
				default: assert(false);
			}
			CurrentItem.workFolder = k[ID, Item.TREE.WORKFOLDER].get!(string).toText;
			CurrentItem.option = k[ID, Item.TREE.OPTION].get!(string).toText;
			CurrentItem.iconAddress = k[ID, Item.TREE.ICON, Item.TREE.ICON_ADDRESS].get!(string).toText;
			CurrentItem.iconIndex = k[ID, Item.TREE.ICON, Item.TREE.ICON_INDEX].get!(Integer);
			CurrentItem.show = cast(SHOW)k[ID, Item.TREE.SHOW].get!(Integer);
			
			CurrentItem.tags = Texts(k[ID, Item.TREE.TAGS].get!(string[]));
			CurrentItem.key = cast(KEY)k[ID, Item.TREE.KEY].get!(Integer);
			
			CurrentItem.historyWorkFolders=Texts(k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_WORKFOLDERS].get!(string[]));
			CurrentItem.historyOptions=Texts(k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_OPTIONS].get!(string[]));
			
			CurrentItem.historyResist=Regist;
			CurrentItem.historyLast=Last;
			CurrentItem.historyUse=k[ID, Item.TREE.HISTORY, Item.TREE.HISTORY_USE].get!(Integer);


			if(CurrentItem.itemID.toString in ItemBase && CurrentItem.itemID != ID) {
				//既存IDを変更
				//for(auto i=0; i < items.length; i++) {//}
				foreach(i; 0 .. Pairs.length) {
					//if(items[i].itemID == CurrentItem.itemID) {//}
					if(Pairs[i].left.itemID == CurrentItem.itemID) {
						auto n=CurrentItem.itemID;
						ItemBase.reName(CurrentItem.itemID.toString, ID);
						//items[i] = item;
						//Pairs[i].left = item;
						Pairs.changeItem(n, item, ItemBase);
						//InitItem(items);
						InitItem(Pairs);
						//ChangeItem(items[i]);
						ChangeItem(Pairs[i].left);
						//Itemlist.selectID(ID.toText);
						
						break;
					}
				}
			} else {
				//既存IDはそのまま
				ItemBase[CurrentItem.itemID.toString] = k[CurrentItem.itemID.toString];
				Pairs.changeItem(CurrentItem.itemID, CurrentItem, ItemBase);
				//InitItem(items);
				InitItem(Pairs);
				ChangeItem(CurrentItem);
				Itemlist.selectID(ID.toText);
			}
		} else {
			//新規追加
			//items ~= item;
			Pairs.addItem(item, ItemBase);
			ItemBase[ID] = k[ID];
			//InitItem(items);
			InitItem(Pairs);
			ChangeItem(item);
			Itemlist.selectID(ID.toText);
		}
/+
		+/

		//
	}

	private void DelItem(Item item)
	in {
		assert(item);
	}
	body {
		/+
		foreach(i, value; items) {
			if(value.itemID == item.itemID) {
				if(items.length != 1) {
					items = items[0..i] ~ items[i+1 .. $];
				} else {
					items = null;
				}
				InitItem(items);
				ChangeItem(items.length ? items[0]: null);
				return;
			}
		}
		+/
		if(Pairs.del(item.itemID)) {
			InitItem(Pairs);
		}
		ChangeItem(Pairs.length ? Pairs[0].left: null);
	}


	private void ChangeAddressBase() {
					assert(AddressInput.type == Item.TYPE.NORMAL);
					try {
						const Address = AddressInput.text;
						if(!FILE.isExistence(Address)) {
							// クラスがすごく変だ…。
							enforce(Address.length, new ItemSetException("アドレスが凄く空白です"));
							throw new ItemSetException("とりあえずアドレス無効っぽいんで処理しない, " ~ Address.toString);
						}

						// 全ての項目を初期化
						IdInput         .text=Text.emptyText;
						NameInput       .text=Text.emptyText;
						WorkFolderInput .text=Text.emptyText;
						OptionInput     .text=Text.emptyText;
						IconInput       .text=Text.emptyText;
						
						IdInput.text = GetIdFromFileAddress(Address);
						NameInput.text = GetNameFromFileAddress(Address);
						WorkFolderInput.text = PATH.getOwnerFolder(Address);
						IconInput.text = Address;
						IconInput.userData = null;
						
						KeySelect.select = GetKeyFromText(NameInput.text);

					} catch(Exception e) {
						throw new ItemDataException(Text("アドレスからの設定に失敗"), NGEC.NONE, e);
					}
	}

	
}

