﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.groupdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(groupdialog) void main() {}

import std.contracts;

import etc.kareki.kareki;

//import nemuxi.file.items.item;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.control.treeview.treeview;
import nemuxi.negui.control.listbox.listbox;
import nemuxi.image.font;
import nemuxi.negui.layout.panel.dual;
import nemuxi.file.items.group;
import nemuxi.gui.control.listview;
import nemuxi.negui.draw.cursor;
import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.negui.window.menu.popup;
import nemuxi.gui.window.dialog.settingdialog.settingif;
import nemuxi.negui.event;
import nemuxi.utility.convert.item;

/**
History:
	1.00β15:
		[P] アイテム選択部分をリストボックスからコンボボックスへ。
*/
class GroupDialog: ModalDialog, ISettingInFrame {
	enum COMMAND: COMMAND_ID {
		ITEM_DELETE = ACCELERATOR_DEFKEY.SAFE_START,
	}
	
	protected enum CTRL: ITEM_ID {
		GROUP = 1,
		ITEM,
	}
	protected enum TYPE {
		NONE,
		MENU,
		MAIN,
		SUB,
		ITEM
	}
	protected {
		TreeView GroupTree;
		ItemListView ItemSelect;
	}
	protected {
		Font CtrlFont;
		
		Kareha GroupBase;
	}
	this(NeWindow Owner, Kareha GroupBase) {
		this.GroupBase  = GroupBase;
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner  = Owner;
		NeGuiInfo.Window = true;
		
		super(&NeGuiInfo, DIALOG_ID.init);
	}

	/**
	History:
		1.00β18:
			[B] 選択アイテムが強制的に最上位に変更される。
	*/
	override void iiPairs(ItemIconPairs Pairs) {
		auto TreeItem=GroupTree.get(GroupTree.nodeCaret());
		ItemSelect.iiPairs = Pairs;
		auto Enable=ItemSelect.enable && cast(TYPE)TreeItem.data == TYPE.ITEM;
		ItemSelect.enable = Enable;
		if(Enable) {
			auto ItemID=Text(TreeItem.text);
			if(ItemID in Pairs)
			ItemSelect.selectID(ItemID);
		}
	}
	override ItemIconPairs iiPairs() {
		return ItemSelect.iiPairs;
	}
	
	mixin MixInSettingInFrame;
	override AkiDocument akiDocument() {
		auto aki=new AkiDocument;

		string[] MainGroupNames;
		TREE_NODE MainGroupNode=GroupTree.nodeRoot(TREE_NODE.init);
		do {
			auto MainItem=GroupTree.get(MainGroupNode);
			auto MainGroupName=Text(MainItem.text).toString;
			if(cast(TYPE)MainItem.data != TYPE.MENU) {
				MainGroupNames ~= MainGroupName;
			}

			string[] SubGroupNames;
			TREE_NODE SubGroupNode=GroupTree.nodeChild(MainGroupNode);
			while(SubGroupNode) {
				auto SubItem=GroupTree.get(SubGroupNode);
				auto SubGroupName=Text(SubItem.text).toString;
				SubGroupNames ~= SubGroupName;

				string[] ItemIDs;
				TREE_NODE ItemNode=GroupTree.nodeChild(SubGroupNode);
				while(ItemNode) {
					auto ItemItem=GroupTree.get(ItemNode);
					auto ItemID=Text(ItemItem.text).toString;
					ItemIDs ~= ItemID;
					
					ItemNode = GroupTree.nodeNext(ItemNode);
				}
				aki[`Group`, MainGroupName, SubGroupName] = ItemIDs;

				SubGroupNode = GroupTree.nodeNext(SubGroupNode);
			}
			
			aki[`Group`, MainGroupName] = SubGroupNames;
			
		} while(cast(bool)(MainGroupNode=GroupTree.nodeNext(MainGroupNode)));
		
		aki[`Group`] = MainGroupNames;
		
		return aki;
	}

	protected override {
		void OnDestroy() {
			delete CtrlFont;
			
			super.OnDestroy();
		}
		/**
		History:
			1.00β15:
				[P] layoutManager.basePanelの配置、方向を変更。
				[S] アクセラレータ使用準備。
		*/
		void OnCreate() {
			super.OnCreate();
			AcceleratorClear();
			
			CtrlFont = GetSystemFont(SYSFONT.MESSAGE);
			
			GroupTree = new TreeView(this, CTRL.GROUP);
			GroupTree.font = CtrlFont;

			ItemSelect = new ItemListView(this, CTRL.ITEM);
			ItemSelect.font = CtrlFont;

			auto panel=new Dual(DIRECTION.HORIZON);
			panel.sizeInfo.percent=60;
			panel[0] = GroupTree;
			panel[1] = ItemSelect;

			layoutManager.basePanel=panel;
		}

		
		/**
		History:
			1.00β15:
				[S] アクセラレータ使用準備。
		*/
		void OnCreated() {
			InitTree;
			ItemSelect.enable=false;

			ACCELERATOR Accels;
			Accels.command = COMMAND.ITEM_DELETE;
			Accels.type    = ACCELERATOR.TYPE.VIRTKEY;
			Accels.key     = KEY.D;

			super.accelerator = new Accelerator(Accels);
		}

		void OnContexMenu(NeGui CatchItem, int x, int y) {
			if(CatchItem !is GroupTree) {
				return;
			}
			
			auto TreeItem=GetTreeItem(x, y);
			if(!TreeItem) {
				TreeItem = new TREEITEM;
				TreeItem.data = cast(void*)TYPE.NONE;
				TreeItem.item = GroupTree.nodeRoot(TREEINSERTITEM.ROOT);
			}

			enum COMMAND: COMMAND_ID {
				MOVE_UP=1,
				MOVE_DOWN,
				EDIT,
				DEL,
				MAIN_ADD,
				MAIN_INSERT,
				SUB_ADD,
				SUB_INSERT,
				ITEM_ADD,
				ITEM_INSERT,
			}
			
			scope menu=new PopUp();
			/+
			menu.insertText(COMMAND.MOVE_UP, Text("上へ"), cast(bool)GroupTree.nodePrevious(TreeItem.item));
			menu.insertText(COMMAND.MOVE_DOWN, Text("下へ"), cast(bool)GroupTree.nodeNext(TreeItem.item));
			menu.insertSeparator();
			menu.insertText(COMMAND.EDIT, Text("編集"));
			menu.insertText(COMMAND.DEL, Text("削除"));
			menu.insertSeparator();
			+/
			menu.insertText(COMMAND.MOVE_UP,   LanguageData.settingGroup(LD.SETTING_GROUP.UP),   cast(bool)GroupTree.nodePrevious(TreeItem.item));
			menu.insertText(COMMAND.MOVE_DOWN, LanguageData.settingGroup(LD.SETTING_GROUP.DOWN), cast(bool)GroupTree.nodeNext(TreeItem.item));
			menu.insertSeparator();
			menu.insertText(COMMAND.EDIT, LanguageData.message(LD.MESSAGE.EDIT));
			menu.insertText(COMMAND.DEL,  LanguageData.message(LD.MESSAGE.DELETE));
			menu.insertSeparator();
			auto DISABLE=cast(MENU_FLAG)(MENU_FLAG.GRAYED | MENU_FLAG.DISABLED);
			
			with(COMMAND) switch(cast(TYPE)TreeItem.data) {
				case TYPE.MAIN:
					/+
					menu.insertText(MAIN_INSERT, Text("メイングループ挿入"));
					menu.insertText(MAIN_ADD, Text("メイングループ追加"));
					+/
					menu.insertText(MAIN_INSERT, LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_INSERT));
					menu.insertText(MAIN_ADD,    LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_ADD));
					menu.insertSeparator();
					//menu.insertText(SUB_ADD, Text("サブグループ追加"));
					menu.insertText(SUB_ADD, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_ADD));
					if(!GroupTree.nodeNext(GroupTree.nodeNext(TreeItem.item))) {
						//最後が<Menu>なんでその次がnullだったら×。
						menu.enable(MOVE_DOWN, DISABLE);
					}
					break;
				case TYPE.SUB:
					/+
					menu.insertText(SUB_INSERT, Text("サブグループ挿入"));
					menu.insertText(ITEM_ADD, Text("アイテム追加"));
					+/
					menu.insertText(SUB_INSERT, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_INSERT));
					menu.insertText(ITEM_ADD,   LanguageData.settingGroup(LD.SETTING_GROUP.ITEM_ADD));
					break;
				case TYPE.ITEM:
					//menu.insertText(ITEM_INSERT, Text("アイテム挿入"));
					menu.insertText(ITEM_INSERT,   LanguageData.settingGroup(LD.SETTING_GROUP.ITEM_INSERT));
					break;
				case TYPE.MENU:
					//menu.insertText(SUB_ADD, Text("サブグループ追加"));
					menu.insertText(SUB_ADD, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_ADD));
					menu.enable(MOVE_UP, DISABLE);
					menu.enable(MOVE_DOWN, DISABLE);
					menu.enable(EDIT, DISABLE);
					menu.enable(DEL, DISABLE);
					break;
				case TYPE.NONE:
					//menu.insertText(MAIN_ADD, Text("メイングループ追加"));
					menu.insertText(MAIN_ADD,    LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_ADD));
					menu.enable(MOVE_UP, DISABLE);
					menu.enable(MOVE_DOWN, DISABLE);
					menu.enable(EDIT, DISABLE);
					menu.enable(DEL, DISABLE);
					break;
				default:
					assert(false);
			}
			if(cast(TYPE)TreeItem.data != TYPE.NONE) {
				GroupTree.select(TreeItem.item, TreeView.SELECT.CARET);
			}
			if(auto id=menu.show(this, PopUp.FLAGS.NONOTIFY | PopUp.FLAGS.RETURNCMD)) {
				TREEINSERTITEM TreeInsertItem;
				bool InsertFlag=true;
				
				with(COMMAND) switch(id) {
					case MOVE_UP:
						GroupTree.nodeMove(TreeItem.item, +1);
						InsertFlag = false;
						break;
					case MOVE_DOWN:
						GroupTree.nodeMove(TreeItem.item, -1);
						InsertFlag = false;
						break;
					case EDIT:
						if(cast(TYPE)TreeItem.data == TYPE.ITEM) {
							ItemSelect.setFocus;
						} else {
							InputContent(*TreeItem);
						}
						InsertFlag = false;
						break;
					case DEL:
						GroupTree.del(TreeItem.item);
						InsertFlag = false;
						break;
					case MAIN_ADD:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.MAIN, Text("MainGroup"), false);
						if(cast(TYPE)TreeItem.data != TYPE.NONE) {
							TreeInsertItem.insertAfter = GroupTree.nodePrevious(GroupTree.nodeTail(TreeItem.item));
						} else {
							TreeInsertItem.insertAfter = TREEINSERTITEM.FIRST;
						}
						break;
					case MAIN_INSERT:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.MAIN, Text("Main Group"), true);
						break;
					case SUB_ADD:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.SUB, Text("Sub Group"), false);
						TreeInsertItem.parent = TreeItem.item;
						break;
					case SUB_INSERT:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.SUB, Text("Sub Group"), true);
						break;
					case ITEM_ADD:
						Text Name = "New Item";
						if(ItemSelect.count) {
							//Name = ItemSelect.getItemList[0].itemID;
							Name = ItemSelect.iiPairs[0].left.itemID;
						}
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.ITEM, Name, false);
						TreeInsertItem.parent = TreeItem.item;
						break;
					case ITEM_INSERT:
						Text Name = "New Item";
						if(ItemSelect.count) {
							Name = ItemSelect.iiPairs[0].left.itemID;
						}
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.ITEM, Name, true);
						break;
					default:
						assert(false);
				}

				if(InsertFlag) {
					GroupTree.select(GroupTree.insert(TreeInsertItem), TreeView.SELECT.CARET);
				}
			}
		}

		/**
		History:
			1.00β15:
				ほいさぁ！
		*/
		bool OnAccelerator(COMMAND_ID Id) {
			return false;
		}

		/**
		History:
			1.00β14:
				[P] ツリービューのダブルクリックを無視。
		*/
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) {
			switch(Id) {
				case CTRL.GROUP:
					switch(Notify.code) {
					case TreeView.EVENT.SELCHANGED:
						auto TreeViewMessage=cast(TREEVIEWMESSAGE*)Notify;
						if(*TreeViewMessage.itemNew != TREEITEM.init) {
							// アイテムの編集可不可 setItemListとの統一が必要。
							auto IsItem=cast(TYPE)TreeViewMessage.itemNew.data == TYPE.ITEM;
							ItemSelect.enable=IsItem;
							if(IsItem) {
								auto CopyItem=GetTreeItem(TreeViewMessage.itemNew.item);
								auto NowID=Text(CopyItem.text);
								if(NowID in ItemSelect)
								ItemSelect.selectID(NowID);
							}
							return 0;
						}
					default:
						return 0;
					}
					assert(false);

				case CTRL.ITEM:
					switch(Notify.code) {
						case ListView.EVENT.ITEMCHANGED:
							auto ListViewMessage=cast(LISTVIEWMESSAGE*)Notify.ptr;
							auto TreeItem=GroupTree.get(GroupTree.nodeCaret());
						
							if(TreeItem.item) if(auto pPair=(cast(size_t)ListViewMessage.data in iiPairs)) {
								TreeItem.text = pPair.left.itemID;
								GroupTree.set=TreeItem;
							}
						
							return 0;
						default:
							return 0;
					}
				
				default:
					return 0;
			}
			assert(false);
		}
	}

	private TREEITEM* GetTreeItem(int x, int y, in size_t TextLength=TreeView.TEXTLENGTH) {
		TREEHITTEST TreeHitTest;
		TreeHitTest.point.x = x;
		TreeHitTest.point.y = y;
		if(GroupTree.pointToClient(TreeHitTest.point)) {
			auto Item = GroupTree.hitTest(TreeHitTest);
			
			if(Item) {
				return GetTreeItem(Item, TextLength);
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
	private TREEITEM* GetTreeItem(TREE_ITEM Item, in size_t TextLength=TreeView.TEXTLENGTH) {
		auto TreeItem=new TREEITEM;
		auto str=new wchar[TextLength];
		TreeItem.mask = TREEITEM.MASK.HANDLE | TREEITEM.MASK.TEXT | TREEITEM.MASK.USERDATA;
		TreeItem.item = Item;
		TreeItem.text = str.ptr;
		TreeItem.textLength=str.length;
		if(GroupTree.get(*TreeItem)) {
			return TreeItem;
		} else {
			return null;
		}
	}

	bool InputContent(const ref TREEITEM TreeItem) {
		TREEITEM CopyItem=cast(TREEITEM)TreeItem;
		INPUTSTATUS InputStatus;
		
		with(InputStatus) {
			InputText = true;
			CanselSelect = true;
			InitText  = CopyItem.text;
			dg = delegate(in Text text) {
				enforce(Convert.isTreeName(text.toString), new SettingException(text ~ "はむり"));
			};
		}
		scope dialog=new InputDialog(cast(NeWindow)parent, InputStatus);

		if(dialog.select) {
			if(dialog.inputText != Text(CopyItem.text)) {
				CopyItem.text = dialog.inputText;
				enforce(GroupTree.set(CopyItem), new NemuxiException(Err.toString));
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	ref TREEINSERTITEM GetInsertItem(TREE_NODE BaseNode, TYPE Type, in Text text, bool Insert) {
		auto TreeInsertItem = new TREEINSERTITEM;
		
		TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.DATA;
		TreeInsertItem.item.text = text;
		TreeInsertItem.item.data = cast(void*)Type;
		TreeInsertItem.parent = GroupTree.nodeParent(BaseNode);
		
		if(Insert) {
			TreeInsertItem.insertAfter = BaseNode;
		} else {
			TreeInsertItem.insertAfter = TREEINSERTITEM.LAST;
		}

		return *TreeInsertItem;
	}


	private void InitTree() {
		
		auto main=new Main(GroupBase);
		auto Groups=main.baseNames ~ Main.menuGroupName;
		foreach(i, MainName; Groups) {
			TREEINSERTITEM TreeInsertItem;
			
			TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.HANDLE | TREEITEM.MASK.USERDATA;
			TreeInsertItem.insertAfter = TREEINSERTITEM.LAST;
			TreeInsertItem.item.text = MainName;
			if(i == Groups.length-1) {
				TreeInsertItem.item.data = cast(void*)TYPE.MENU;
			} else {
				TreeInsertItem.item.data = cast(void*)TYPE.MAIN;
			}
			TreeInsertItem.parent = GroupTree.insert(TreeInsertItem);
			
			if(MainName.toString in GroupBase) {//}
				auto subs=main.subGroup(MainName);
			
				if(subs) foreach(j, SubName; subs.baseNames) {
					TreeInsertItem.item.text = SubName;
					auto SubParent = TreeInsertItem.parent;
					scope(exit)TreeInsertItem.parent = SubParent;
					TreeInsertItem.item.data = cast(void*)TYPE.SUB;
					TreeInsertItem.parent = GroupTree.insert(TreeInsertItem);
					if(subs.haveItems(SubName)) {
						foreach(ItemName; subs.childNames(SubName)) {
							TreeInsertItem.item.text = ItemName;
							TreeInsertItem.item.data = cast(void*)TYPE.ITEM;
							GroupTree.insert(TreeInsertItem);
						}
					}
				}
			}
		}
	}


}


