﻿/**

BUGS:
	フォルダを実行できない。
*/
module nemuxi.gui.window.dialog.execdialog.execdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(execdialog) void main() {}

import std.string;
import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.file;
import nemuxi.file.folder;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.linkitem;
import nemuxi.image.font;
import nemuxi.image.icon;
import nemuxi.negui.draw.unit;
import nemuxi.image.cursor;
import nemuxi.negui.window.newindow;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.combobox.combobox;
import nemuxi.gui.control.combobox;
import nemuxi.utility.simple.his;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.gui.window.dialog.selectdialog;
import nemuxi.gui.gui;

import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.dual;


class ExecDialog: SelectDialog {
	private {
		enum CTRL: ITEM_ID {
			ADDRESS=1,
			WORK_SELECT,
			WORK_INPUT,
			OPTION_SELECT,
			OPTION_INPUT,
			SHOW,
			EXECUTE,
			CLOSE,
		}

		BM_ITEM BMItem;
		Font CtrlFont;
		//bool SelectFlag;

		Application application;
		
		EditLine Address;
		Push WorkSelect, OptionSelect, Execute, Close;
		ComboBox WorkInput, OptionInput;
		ShowComboBox ShowSelect;

		Text* option;
	}
	/**
	History:
		1.00β13:
			[F] オプション引数を追加。
	*/
	this(NeWindow Owner, Item item, Application application, Text* option=null)
	in {
		assert(Owner);
		assert(item);
		assert(application);
	}
	body {
		this.application = application;
		this.option = option;
		
		BMItem = ItemToButtonMenuItem(item, true, ICONSIZE.SMALL);
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner   = Owner;
		NeGuiInfo.Style   = WS_DLGFRAME | WS_CAPTION | WS_THICKFRAME | WS_SYSMENU;

		super(&NeGuiInfo);
		
		defButton = Execute;

		this.Center = CENTER.DESKTOP;
	}

	override protected {
		/**
		History:
			1.00β19:
				[F] ダイアログの初期横幅を拡張。
		
			1.00β13:
				[S] オプション引数追加によるオプション項目の変更。
		*/
		void OnCreate() {
			super.OnCreate();
			dropFile=true;
			auto item=BMItem.item;
			//text=Text(item.itemID);
			auto TitleText=LanguageData.dialog(LD.DIALOG.EX);
			text = Text(TitleText, item.toTextLine.text);
			CtrlFont = GetSystemFont(SYSFONT.MESSAGE, true);
			
			setIcon(ICONSIZE.SMALL, BMItem.icon);

			// アイテムアドレス(Item.TYPE依存)
			Address=new EditLine(this, CTRL.ADDRESS);
			with(Item.TYPE) switch(item.type()) {
				case NORMAL: Address.text = item.address; break;
				case URI:    Address.text = item.uri;     break;
				case MULTI:  Address.text = join(item.multi, Text(", ")); break;
				default:     assert(false);
			}
			Address.readOnly=true;
			Address.font = CtrlFont;

			// 作業フォルダ選択コントロール
			WorkSelect=new Push(this, CTRL.WORK_SELECT);
			WorkSelect.font = CtrlFont;
			//WorkSelect.text = Text("作業フォルダ...");
			WorkSelect.text = LanguageData.ex(LD.EX.WORK);

			// 作業フォルダ入力コントロール
			WorkInput=new ComboBox(this, CTRL.WORK_INPUT, ComboBox.TYPE.DROPEDIT);
			WorkInput.font = CtrlFont;
			Text WorkText = Text(GetWorkFolder(item));
			if(item.historyWorkFolders.length) {
				WorkInput.add(Texts(item.historyWorkFolders));
			}
			WorkInput.add(WorkText);
			WorkInput.text = WorkText;

			// オプション選択コントロール
			OptionSelect=new Push(this, CTRL.OPTION_SELECT);
			OptionSelect.font = CtrlFont;
			//OptionSelect.text = Text("オプション...");
			OptionSelect.text = LanguageData.ex(LD.EX.OPTION);

			// オプション入力コントロール
			OptionInput=new ComboBox(this, CTRL.OPTION_SELECT, ComboBox.TYPE.DROPEDIT);
			OptionInput.font = CtrlFont;
			Text OptionText = Text(item.option);
			if(item.historyOptions.length) {
				OptionInput.add(Texts(item.historyOptions));
			}
			if(option) {
				OptionInput.text = *option;
			} else {
				OptionInput.text = OptionText;
			}
			OptionInput.add(OptionText);
			
			// 表示方法選択コントロール
			ShowSelect=new ShowComboBox(this, CTRL.SHOW);
			ShowSelect.font = CtrlFont;
			ShowSelect.initialize();
			ShowSelect.select(item.show);

			// 表示方法選択コントロール
			Execute=new Push(this, CTRL.EXECUTE);
			Execute.font = CtrlFont;
			//Execute.text = Text("実行");
			Execute.text = LanguageData.message(LD.MESSAGE.EXECUTE);
			Execute.def = true;
			Execute.setFocus;

			// 表示方法選択コントロール
			Close=new Push(this, CTRL.CLOSE);
			Close.font = CtrlFont;
			//Close.text = Text("閉じる");
			Close.text = LanguageData.message(LD.MESSAGE.CLOSE);

			immutable Padding=GetControlPadding();
				
			auto Rows=new Tansu(DIRECTION.VERTICAL);
			Rows.sizeInfo.absolute = WorkInput.editerHeight();
			Rows.padding.bottom = Rows.padding.top    = Padding.cy / 2;
			Rows += Address;
			
			auto Works=new Dual(DIRECTION.HORIZON);
			Works[0] = WorkSelect;
			Works[1] = WorkInput;
			Works.centerSize = Padding.cx;
			Works.sizeInfo.percent = 35;
			Rows += Works;
			
			auto Options=new Dual(DIRECTION.HORIZON);
			Options[0] = OptionSelect;
			Options[1] = OptionInput;
			Options.centerSize = Padding.cx;
			Options.sizeInfo.percent = 35;
			Rows += Options;

			auto Selects=new Dual(DIRECTION.HORIZON);
			Selects[0] = Execute;
			Selects[1] = Close;
			Selects.centerSize = Padding.cx;
			Selects.sizeInfo.percent = 50;
			
			auto Others=new Line(DIRECTION.HORIZON);
			Others += ShowSelect;
			Others += null;
			Others += Selects;
			Others.sizeInfo(0).percent = 30;
			Others.sizeInfo(1).percent = 25;
			Others.sizeInfo(2).absolute = -1;
			Rows += Others;
			
			layoutManager.basePanel = Rows;
			
			SIZE Size=void;
			Size.cx = 412;
			Size.cy = WorkInput.editerHeight() * 4 + Padding.cy/2 * 5*2;

			adjustSize(Size.cx, Size.cy);
		}
		void OnDestroy() {
			delete BMItem.icon;
			delete CtrlFont;
			
			super.OnDestroy();
		}
		HT OnNcHitTest(HT HitFlag, int x, int y) {
			with(HT) switch(HitFlag) {
				case TOP, BOTTOM:
					return CLIENT;
				case BOTTOMLEFT, TOPLEFT:
					return LEFT;
				case BOTTOMRIGHT, TOPRIGHT:
					return RIGHT;
				default:
					return HitFlag;
			}
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(MessageType == Button.EVENT.CLICKED) {
				switch(Id) {
					case CTRL.WORK_SELECT: {
						WorkSelectDialog();
						return true;
					}
					case CTRL.OPTION_SELECT: {
						OptionSelectDialog();
						return true;
					}
					case CTRL.EXECUTE: {
						ExecuteSelect();
						destroy();
						return true;
					}
					case CTRL.CLOSE: {
						destroy();
						return true;
					}
					default:
						return false;
				}
			} else {
				return false;
			}
		}

		void OnDropFiles(DropFile drop) {
			OptionInput.text = DropFileJoin(drop[], application.AppData.shortcut, this);
		}
	}

	private {
		void WorkSelectDialog() {
			auto WorkFolder=WorkInput.text;

			auto Folder=new FolderDialog();
			Folder.ownerWindow = this;
			if(WorkFolder.length && FILE.isExistence(WorkFolder) && FILE.isFolder(WorkFolder)) {
				Folder.folderAddress = WorkFolder;
			}
			with(FolderDialog.BIF) Folder.flags = RETURNSANCESTORS|RETURNNONLYFSDIRS|USENEWUI;
			
			try {
				if(Folder.select()) {
					WorkInput.text = Folder.folderAddress;
				}
			} catch(Exception e) {
				Logger.write(e);
				ShowExceptionDialog(this, e);
			}
		}

		void OptionSelectDialog() {
			auto OptionFolder=OptionInput.text;

			auto File=new OpenDialog();
			File.ownerWindow = this;
			if(OptionFolder.length && FILE.isExistence(OptionFolder)) {
				File.currentFolder = PATH.getOwnerFolder(OptionFolder);
			} else {
				File.currentFolder = GetSystemFolder(SYS_FOLDER.PERSONAL);
			}
			File.flags = FileDialog.FLAGS.DEFAULT;
			
			OpenDialog.FILTER[] filter;
			auto FiltersList=StaticData.fileFilter;
			foreach(Filters; FiltersList) {
				filter ~= OpenDialog.FILTER(Filters[0], Filters[1..$]);
			}
			
			File.filter = filter;
			
			if(File.select()) {
				OptionInput.text = File.fileAddress;
			}
		}



		void ExecuteSelect() {
			// 実行
			try {
				OverrideInfo* OverInfo;
				void OverSet() {
					if(OverInfo is null) {
						OverInfo = new OverrideInfo;
					}
				}
				enforce(BMItem.live, new NemuxiException("あれれ"));
				if(WorkInput.text != BMItem.item.workFolder) {
					OverSet();
					OverInfo.Mask       |= OverrideInfo.MASK.WORK;
					OverInfo.WorkFolder =  WorkInput.text.toString();
				}
				if(OptionInput.text != BMItem.item.option) {
					OverSet();
					OverInfo.Mask   |= OverrideInfo.MASK.OPTION;
					OverInfo.Option =  OptionInput.text.toString();
				}
				if(ShowSelect.select != BMItem.item.show) {
					OverSet();
					OverInfo.Mask |= OverrideInfo.MASK.SHOW;
					OverInfo.Show =  ShowSelect.select;
				}
				/*synchronized(BMItem.item)*/ application.executeItem(BMItem.item, OverInfo);
			} catch(Exception e) {
				Logger.write(e);
				ShowExceptionDialog(this, e);
			}


			// 履歴設定
			invariant HISTORY_MAX=application.AppData.historyMax();
			if(!HISTORY_MAX) {
				return;
			}

			/// 履歴設定
			void HistoryList(ComboBox Target, void delegate(Text[]) dg) {
				if(Target.count > 1) {
					Text[] TempStrs;
					if(Target.count-1 == 1) {
						// 登録はひとつだけ
						TempStrs=[Target[0]];
					} else {
						TempStrs=Target[0..Target.count-2];
					}
					auto AddStr  =Target.text.strip;

					if(Target[Target.count-1].strip == AddStr) {
						return;
					}
					
					auto TempList=HistorySort(TempStrs, AddStr);
					
					if(TempList.length > HISTORY_MAX) {
						TempList.length = HISTORY_MAX;
					}
					dg(TempList);
				} else if(Target[0] != Target.text) {
					dg([Target.text]);
				}
			}


			HistoryList(WorkInput, &BMItem.item.historyWorkFolders);
			HistoryList(OptionInput, &BMItem.item.historyOptions);
		}
	}
}

