﻿/**
ふるい・・・
*/
module nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(exceptiondialog) void main() {}

import std.conv;
import std.string;

import win32.windows;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.negui.window.window;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.gui.window.dialog.selectdialog;
//import nemuxi.negui.proc.exceptionwnd.exceptionwnd;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.label.label;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.treeview.treeview;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.negui.control.group;
import nemuxi.utility.simple.sysinfo;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.dual;

package enum CTRL {
	WARNIG=1,
	MESSAGE,
	//ERRCODE,
	//DETAILS,
	WEB,
	CLOSE,
	COPY,
	FILE,
	UPLOAD,
	//SELECT_MSG,
	LIST
}
/**
History:
	1.00β19:
		[F] ダイアログサイズを一回り大きく。
*/
final scope class ExceptionDialog: SelectDialog {
	private {
		//Throwable Throwables;
		Throwable FirstThrowable;
		//Window Owner;
		
		Font MessageFont;
		Font CtrlFont;
		Font TreeFont;

		ControlGroup Msgs, Buttons;

		enum CTRL {
			WARNIG=1,
			MESSAGE,
			//ERRCODE,
			//DETAILS,
			WEB,
			CLOSE,
			COPY,
			FILE,
			UPLOAD,
			//SELECT_MSG,
			LIST
		}
	}
	package {
		IconLabel Warnig;
		EditBox Message;
		//EditBox ErrCode;
		Push Web, Close, Copy, File, UpLoad;
		//EditBox SelectMsg;
		TreeView List;

		
	}

	this(Window OwnerWindow, Throwable e) {
		FirstThrowable = e;
		GUIINFO NeGuiInfo;
		NeGuiInfo.Style        = WS_DLGFRAME | WS_CAPTION | WS_SYSMENU;
		NeGuiInfo.Style        |= WS_SIZEBOX;
		NeGuiInfo.Owner=OwnerWindow;

		super(&NeGuiInfo);
			SIZE Size;
			Size.cx = GetSystemMetrics(SM_CXSCREEN) / 3;
			Size.cy = GetSystemMetrics(SM_CYSCREEN) / 4;
			super.adjustSize(&Size);

		defButton = Close;

		super.Center = CENTER.DESKTOP;
	}

//	private mixin Modal;
	
	override bool select() {
		/+
		try {
			if(Owner) {
				Owner.enable = false;
			}
			SIZE Size;
			Size.cx = GetSystemMetrics(SM_CXSCREEN) / 4;
			Size.cy = GetSystemMetrics(SM_CYSCREEN) / 6;;
			super.adjustSize(&Size);
			super.toCenter(CENTER.DESKTOP, null);
			super.setShow(SW.SHOW);
			SetOverAuto(Close);
			MessageBeep(MB_ICONEXCLAMATION);
			modal;

			return true;
		} catch(Exception e) {
			Logger.write(e);
			return false;
		} finally {
			if(Owner) {
				Owner.enable = true;
				Owner.foreGround();
				Owner.send(WM_NULL, NONE, NONE);
			}
		}
		+/
		try {
			MessageBeep(MB_ICONEXCLAMATION);
			
			return super.select();
		} catch(Throwable e) {
			Logger.write(e);
			return false;
		}
	}
	


	private {
		void CommandWeb() {
		}
		void CommandCopy() {
		}
		void CommandFile() {
		}
		void CommandUpLoad() {
		}
	}
	
	protected override {
		void OnDestroy() {
			delete MessageFont;
			delete CtrlFont;
			delete TreeFont;
			
			super.OnDestroy();
		}
		/*
		History:
			1.00β11:
				メッセージ欄にシステム情報の書き出し。
				メッセージ欄のフォントをSYSFONT.MESSAGEへ変更。
		*/
		void OnCreate() {
			super.OnCreate();
			MessageFont = GetSystemFont(SYSFONT.MESSAGE);
			CtrlFont    = GetSystemFont(SYSFONT.MESSAGE);
			TreeFont    = GetSystemFont(SYSFONT.ICON);

			text = LanguageData.dialog(LD.DIALOG.ERROR);
			
			{ // コントロール
				//Warnig=new IconLabel(child(CTRL.WARNIG));
				Warnig=new IconLabel(this, CTRL.WARNIG);
				Warnig.image(GetSystemIcon(SYSICON.HAND, ICONSIZE.NORMAL));
				Warnig.position = PictureLabel.POSITION.CENTER;

				//Message=new TextLabel(child(CTRL.MESSAGE));
				//Message=new TextLabel(this, CTRL.MESSAGE);
				Message=new MultiEdit(this, CTRL.MESSAGE);

				//ErrCode  = new TextLabel(child(CTRL.ERRCODE));
				//ErrCode  = new EditBox(this, CTRL.ERRCODE);

				//
				/+
				Msgs = new ControlGroup(
					Message, ErrCode
				);
				Msgs.font = MessageFont;
				+/
				Message.font = MessageFont;

				/+
				Web    = new Push(child(CTRL.WEB));
				Close  = new Push(child(CTRL.CLOSE));
				Copy   = new Push(child(CTRL.COPY));
				File   = new Push(child(CTRL.FILE));
				UpLoad = new Push(child(CTRL.UPLOAD));
				+/
				Web    = new Push(this, (CTRL.WEB));
				Close  = new Push(this, (CTRL.CLOSE));
				Copy   = new Push(this, (CTRL.COPY));
				File   = new Push(this, (CTRL.FILE));
				UpLoad = new Push(this, (CTRL.UPLOAD));

				Buttons = new ControlGroup(
					Web, File, UpLoad, Copy, Close
				);
				Buttons.font = CtrlFont;
				Close.def = true;

				//SelectMsg = new EditBox(child(CTRL.SELECT_MSG));
				//SelectMsg = new EditBox(this, (CTRL.SELECT_MSG));
				//SelectMsg.font = CtrlFont;

				List = new TreeView(this, CTRL.LIST);
				List.clientEdge = true;
				List.button =true;
				List.rootLine = true;
				List.button = true;
				List.reLoad;
			}

			{ // 固定文字列の設定
				Web   .text = Text("Web");
				//Close .text = Text("閉じる");
				Close .text = LanguageData.message(LD.MESSAGE.CLOSE);
				Copy  .text = Text("コピー");
				File  .text = Text("出力");
				UpLoad.text = Text("アップロード");
			}

			{ // 未実装部分非表示
				Buttons.setShow(SHOW.HIDE);
				Close.setShow(SHOW.SHOW);
			}

			{ // レイアウト設定
				auto MessagePanel=new Dual(DIRECTION.HORIZON);
				MessagePanel[0] = Warnig;
				MessagePanel[1] = Message;
				MessagePanel.sizeInfo.absolute = GetIconSize(ICONSIZE.NORMAL);
				auto ButtonsPanel=new Tansu(DIRECTION.HORIZON);
				ButtonsPanel += Web;
				ButtonsPanel += UpLoad;
				ButtonsPanel += File;
				ButtonsPanel += Copy;
				ButtonsPanel += Close;
				ButtonsPanel.sizeInfo.percent = 20;
				auto BasePanel=new Line(DIRECTION.VERTICAL);
				BasePanel += MessagePanel;
				BasePanel += List;
				BasePanel += ButtonsPanel;
				BasePanel.sizeInfo(0).absolute = -1;
				BasePanel.sizeInfo(1).absolute = -1;
				BasePanel.sizeInfo(2).absolute = Close.minContentHeight;
				BasePanel.padding.top = GetControlPadding.cy;

				layoutManager.basePanel = BasePanel;
			}

			{ // リスト構築
				Throwable NowThrowable=FirstThrowable;
				string[] msgs;
				
				while(NowThrowable) {
					TREEINSERTITEM TreeInsertItem;
					TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.HANDLE | TREEITEM.MASK.USERDATA;
					
					TreeInsertItem.insertAfter(TREEINSERTITEM.LAST);

					invariant string[] Title   = [
						"File",
						"Line",
						"Code",
						"Time",
					];
					// 新規ツリー構築
					TreeInsertItem.item.text     = Text(NowThrowable.classinfo.name);
					TreeInsertItem.item.data = cast(void*)NowThrowable;
					TreeInsertItem.parent = List.insert(TreeInsertItem);

					// 詳細の出力
					TreeInsertItem.item.text = Text(NowThrowable.msg);
					List.insert(TreeInsertItem);

					// NemuxiExceptionであれば派生。
					// NeGuiExceptionであれば派生。
					if(auto ne=cast(NeGuiException)NowThrowable) {
						// ファイル・行出力
						invariant string[] Messages = [
							ne.file,
							to!(string)(ne.line),
							to!(string)(cast(uint)ne.code),
							ne.time.toString
						];
						assert(Title.length == Messages.length);
						for(auto i=0; i < Title.length; i++) {
							Text msg = format("%s: %s", Title[i], Messages[i]);
							TreeInsertItem.item.text = msg;
							List.insert(TreeInsertItem);
						}
					} else {
						// ファイル・行があれば出力
						if(NowThrowable.file) {
							Text file = format("%s: %s", Title[0], NowThrowable.file);
							TreeInsertItem.item.text = file;
							List.insert(TreeInsertItem);
							if(NowThrowable.line) {
								Text line = format("%s: %s", Title[1], NowThrowable.line);
								TreeInsertItem.item.text = line;
								List.insert(TreeInsertItem);
							}
						}
					}
					
					msgs ~= NowThrowable.msg;
					
					NowThrowable = NowThrowable.next;
				}

				// 上位メッセージ設定。
				Message.text = Text(msgs.join(newline)) ~ newline ~ repeat("-", 50) ~ newline  ~ toStringInfo;
				Message.readOnly = true;
			}
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(MessageType == BN_CLICKED) {
				switch(Id) {
					case CTRL.WEB:
						CommandWeb();
				return true;
					case CTRL.CLOSE:
						destroy();
				return true;
					case CTRL.COPY:
						CommandCopy();
				return true;
					case CTRL.FILE:
						CommandFile();
				return true;
					case CTRL.UPLOAD:
						CommandUpLoad();
					return true;
				default:
				}
			}
			
			return super.OnCommand(Id, MessageType, Sender);
		}
	}
}

void ShowExceptionDialog(Window Owner, Throwable e) {
	scope Ed=new ExceptionDialog(Owner, e);
	Ed.select;
}
void ShowThrowables(T: Throwable)(Window Owner, T e) {
	scope Ed=new ExceptionDialog(Owner, e);
	Ed.select;
}
alias ShowThrowables ShowError;

alias ShowThrowables!(Error)     ShowErrorDialog;
alias ShowThrowables!(Exception) ShowExceptionDialog;


