﻿/**
特別仕様のEditLine。

すごくごちゃごちゃ、そして汎用性無い。
*/
module nemuxi.gui.window.dialog.commanddialog.commandedit;

debug import std.stdio: wl = writefln, pl = printf;
debug(commandedit) void main() {}

static import std.algorithm;
import std.uni;

import win32.core;
import win32.commctrl;

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.negui.subclass;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.control.editbox.editbox;
//import nemuxi.negui.control.listbox.listview;
import nemuxi.negui.control.listbox.listbox;
import nemuxi.negui.draw.icon;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.unit;
import nemuxi.image.icon;
import nemuxi.file.items.item;
import nemuxi.file.items.items;
import nemuxi.system.type;

package:

enum WM_MY {
	ITEM = WM_APP+1,
	HIDE,
}

struct COMMANDVALUE {
	enum TYPE {
		ITEM,
		TEXT,
	}
	TYPE type;
	
	CITEM CItem;
}

alias PAIR!(COLOR, COLOR) COMMANDCOLOR;

class CommandEdit: EditLine, ISubClass {
	protected class ListDialog: ModelessDialog {
		private enum CTRL: ITEM_ID {
			LIST = 1,
		}
		protected {
			COMMANDVALUE[] CommandValues;
			class CommandList: ListBox, ISubClass {
				private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
					mixin(EVENTLOOP.WM_TOP!(CommandList));
					switch(Message) {
						case WM_DESTROY: mixin(EVENTLOOP.WM_DESTROY);
						case WM_CHAR:    mixin(EVENTLOOP.WM_CHAR);
						case WM_KEYUP:   mixin(EVENTLOOP.WM_KEYUP);
						default:         mixin(EVENTLOOP.WM_LAST!(CommandList));
					}
				}
				mixin(TSubClass);

				this(ListDialog Owner, ITEM_ID Id) {
					GUIINFO GuiInfo;
					GuiInfo.Owner = Owner;
					GuiInfo.Id    = Id;
					GuiInfo.Style = LBS_OWNERDRAWFIXED;
					super(&GuiInfo, ListBox.SELECT.SINGLE, ListBox.TYPE.LIST);

					SubClassOnNeGuiConstructor;
				}

				protected override {
					void OnDestroy() {
						SubClassOnNeGuiDestructor;
						super.OnDestroy();
					}
					bool OnChar(KEY Key, KEYDATA KeyData) {
						if(toCharacter(Key)) {
							this.outer.outer.post(WM_CHAR, Key, KeyData.data);
							return true;
						}
						return true;
					}
					bool OnKeyUp(KEY Key, KEYDATA KeyData) {
						this.outer.outer.send(WM_KEYUP, Key, KeyData.data);
						return false;
					}
				}
			}
			CommandList list;
		}
		this(CommandEdit Owner, DIALOG_ID DialogId) {
			GUIINFO GuiInfo;
			GuiInfo.Owner = Owner;
			super(&GuiInfo, DialogId);
		}
		override void font(in Font font) {
			list.font = font;
			super.font(font);
		}
		protected override {
			void OnActive(WINDOW_ACTIVE Active, bool NotSmall, HWND NextWnd) {
				super.OnActive(Active, NotSmall, NextWnd);
			}
			
			void OnCreate() {
				super.OnCreate();
				border = true;
				
				GUIINFO GuiInfo;
				GuiInfo.Owner = this;
				GuiInfo.Id    = CTRL.LIST;
				GuiInfo.Style = LBS_OWNERDRAWFIXED;
				//list = new ListBox(&GuiInfo, ListBox.SELECT.SINGLE, ListBox.TYPE.LIST);
				list = new CommandList(this, CTRL.LIST);
			}
			bool OnClose() {
				setShow(SHOW.HIDE);
				return false;
			}
			void OnDestroy() {
				super.OnDestroy();
			}
			bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
				list.move(0, 0, Width, Height);

				return false;
			}
			void OnDrawItem(ITEM_ID Id, DRAWITEM* DrawItem) {
				if(Id == CTRL.LIST) {
					if(DrawItem.commandID == -1) {
						return;
					}
					auto Padding = GetControlPadding;
					
					auto CommandValue=cast(COMMANDVALUE*)list.getItemData(DrawItem.commandID);
					auto canvas=DrawItem.canvas;
					auto DrawRect=DrawItem.rect;

					auto IconPx=Searcher.pairs.iconPx;

					auto NormalFont=list.font;

					if(CommandValue.type == COMMANDVALUE.TYPE.ITEM) {
						//アイテムの場合
						
						//背景描画
						scope BackBrush=new Brush(Colors[CommandValue.CItem.type].right);
						canvas.setBrush(BackBrush);
						scope(exit) canvas.delBrush;
						canvas.fillRect(DrawRect, null);

						//アイコン描画
						POINT IconPos;
						IconPos.x = Padding.cx;
						IconPos.y = (DrawRect.top + (DrawRect.bottom - DrawRect.top) / 2) - IconPx / 2;
						canvas.drawIcon(CommandValue.CItem.icon, &IconPos, IconPx, BackBrush);

						//テキスト描画
						canvas.textColor= Colors[CommandValue.CItem.type].left;
						canvas.backColor= Colors[CommandValue.CItem.type].right;
						canvas.backMode = Canvas.BACKMODE.OP;
						
						scope StrongFont=NormalFont.dup;
						StrongFont.weight = Font.WEIGHT.BLACK;
						//StrongFont.underLine = true;
						
						RECT TextRect; //描画用
						RECT TextArea; //計算用
						auto BaseLeft = IconPos.x*2 + IconPx;
						TextRect.left   = BaseLeft;
						TextRect.top    = DrawRect.top;
						TextRect.right  = DrawRect.right;
						TextRect.bottom = DrawRect.bottom;

						auto Format=Canvas.FORMAT.LEFT | Canvas.FORMAT.VCENTER | Canvas.FORMAT.SINGLELINE;

						auto DrawText=CommandValue.CItem.ShowName;
						auto Hit     =CommandValue.CItem.Hit;

						alias PAIR!(Text, Font) TEXTFONTPAIR;

						//くるくる回す
						scope TEXTFONTPAIR[] TextFontPairs;
						{
							TEXTFONTPAIR TextFontPair;
							
							TextFontPair.left  = DrawText[0 .. Hit.left];
							TextFontPair.right = NormalFont;
							TextFontPairs ~= TextFontPair;
							
							TextFontPair.left  = DrawText[Hit.left .. Hit.right];
							TextFontPair.right = StrongFont;
							TextFontPairs ~= TextFontPair;
							
							TextFontPair.left  = DrawText[Hit.right .. DrawText.length];
							TextFontPair.right = NormalFont;
							TextFontPairs ~= TextFontPair;
						}
						size_t TotalWidth=BaseLeft;
						foreach(i, TextFontPair; TextFontPairs) {
							if(i) {
								canvas.drawText(TextFontPairs[i-1].left, TextArea, Format | Canvas.FORMAT.CALCRECT);
								TotalWidth += TextArea.right;
								TextRect.left = TotalWidth;
							}
							canvas.setFont(TextFontPair.right);
							canvas.drawText(TextFontPair.left, TextRect, Format);

							if(i == TextFontPairs.length-1) {
								canvas.delFont;
							}
						}
						
					} else {
						assert(false);
					}

					// 状態の描画
					if((DrawItem.state & DRAWITEM.STATE.SELECTED) == DRAWITEM.STATE.SELECTED) {
						canvas.drawFocusRect(DrawRect);
					}
				}
			}
			bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
				if(Sender is list) {
					if(MessageType == ListBox.EVENT.DBLCLK) {
						if(list.isSelect) {
							sendCommand(cast(COMMANDVALUE*)list.getItemData(list.select));
						}
					}
				}

				return super.OnCommand(Id, MessageType, Sender);
			}
		}
		void SetValues(COMMANDVALUE[] CommandValues)
		in {
			assert(CommandValues);
		}
		body {
			list.clear;
			this.CommandValues = CommandValues;

			auto IconPx=GetIconControlSize(Searcher.pairs.iconSize).cy;
			auto FontPx=GetDefaultControlHeight(GetSafeFont(list));
			list.setHeight(0, std.algorithm.max(IconPx, FontPx));
			foreach(i, ref CommandValue; CommandValues) {
				list.add(Text.emptyText);
				list.setItemData(i, &CommandValue);
			}
			list.select(0);
			
			this.setShow(SHOW.SHOWNOACTIVATE);
		}
	}
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.WM_TOP!(CommandEdit));
		switch(Message) {
			case WM_DESTROY: mixin(EVENTLOOP.WM_DESTROY);
			case WM_KEYDOWN: mixin(EVENTLOOP.WM_KEYDOWN);
			case WM_KEYUP:   mixin(EVENTLOOP.WM_KEYUP);
			case WM_SIZE:    mixin(EVENTLOOP.WM_SIZE);
			case WM_MY.HIDE: NeGuiObject.toHide(); goto default;
			default:         mixin(EVENTLOOP.WM_LAST!(CommandEdit));
		}
	}
	mixin(TSubClass);

	package {
		ListDialog List;
		ItemSearcher Searcher;
		COMMANDCOLOR[] Colors;
	}
	this(NeWindow Owner, ITEM_ID Id, DIALOG_ID DialogId, Kareha ItemTree, ICONSIZE IconSize, COMMANDCOLOR[] Colors) {
		super(Owner, Id);
		SubClassOnNeGuiConstructor;

		// リスト用のウィンドウ作成
		GUIINFO GuiInfo;
		List = new ListDialog(this, DialogId);
		
		Searcher = new ItemSearcher(ItemTree, IconSize);
		this.Colors = Colors;

		//----
		SIZE Size;
		Size.cx=100;
		Size.cy=100;
		List.adjustSize(Size.cx, Size.cy);
	}
	override void font(in Font font) {
		List.font = font;
		super.font(font);
	}
	alias EditLine.font font;

	void upDate(in Text text) {
		if(text.length) {
			try {
				if(auto CItems=Searcher.find(text, cast(bool)isUniUpper(text[0]), ItemSearcher.FLAGS.ALL)) {
					auto Commands=new COMMANDVALUE[CItems.length];
					foreach(i, ref Command; Commands) {
						Command.CItem = CItems[i];
						Command.type  = COMMANDVALUE.TYPE.ITEM;
					}
					List.SetValues(Commands);
				} else {
					List.setShow(SHOW.HIDE);

					foreGround;
					setFocus;
				}
			} catch(Exception e) {
				//wl("%s", e);
			}
		} else {
			List.setShow(SHOW.HIDE);
		}
	}

	private {
		enum GO {
			ME,
			LIST,
		}
		pure nothrow GO GoTo(KEY Key) {
			switch(Key) {
				case KEY.UP, KEY.DOWN, KEY.PAGEUP, KEY.PAGEDOWN:
					return GO.LIST;
				default:
					return GO.ME;
			}
		}
	}

	void tuneList() {
		auto Rect=itemRect;
		List.position(Rect.left, Rect.bottom);

		auto Size=List.itemSize;
		Size.cx = Rect.right - Rect.left;
		List.adjustSize(Size.cx, Size.cy);
	}
	
	protected override {
		void OnDestroy() {
			SubClassOnNeGuiDestructor;
			List.destroy;
			delete Searcher;
			super.OnDestroy();
		}
		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			tuneList;
			return false;
		}
		
		bool OnKeyDown(KEY Key, KEYDATA KeyData) {
			final switch(GoTo(Key)) {
				case GO.ME:
					//upDate(this.text);
					return false;
				case GO.LIST:
					List.list.send(WM_KEYDOWN, Key, KeyData.data);
					return true;
			}
		}
		bool OnKeyPress(KEY Key, KEYDATA KeyData) {
			final switch(GoTo(Key)) {
				case GO.ME:
					if(toCharacter(Key)) {
						upDate(this.text ~ Key);
					}
					return false;
				
				case GO.LIST:
					List.list.send(WM_KEYDOWN, Key, KeyData.data);
					return true;
			}
		}
		bool OnKeyUp(KEY Key, KEYDATA KeyData) {
			if(Key == KEY.ENTER && List.isVisible) {
				if(List.list.isSelect) {
					auto Command=cast(COMMANDVALUE*)List.list.getItemData(List.list.select);
					sendCommand(Command);
				}

				return true;
			}
			if(GoTo(Key) == GO.ME) {
				if(modify) {
					upDate(this.text);
					modify = false;
				}
			}
			return false;
		}
	}
	void toHide() {
		List.setShow(SHOW.HIDE);
	}

	void sendCommand(COMMANDVALUE* CommandValue) {
		parent.send(WM_MY.ITEM, NONE, cast(LPARAM)CommandValue);
	}

}

