﻿/**
あ
*/
module nemuxi.gui.window.dialog.commanddialog.commanddialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(commanddialog) void main() {}

import win32.windows;

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.app;
import nemuxi.file.items.item;
import nemuxi.file.items.items;
import nemuxi.file.items.itemfunc;
import nemuxi.negui.draw.unit;
import nemuxi.negui.draw.imagelist;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.listbox.listbox;
import nemuxi.negui.control.label.label;
import nemuxi.gui.control.titlebar;
import nemuxi.negui.subclass;
import nemuxi.gui.window.dialog.commanddialog.commandedit;
import nemuxi.system.raii;

/**
History:
	1.00β18:
		[P] サイズ変更制限。
		[S] ModelessDialogに合わせてちょろちょろ変更。
		[F] 自動非表示の実装。
*/
class CommandDialog: ModelessDialog {
	private enum CTRL: ITEM_ID {
		TITLE = 1,
		INPUT,
	}
	private enum TIMER: TIMER_ID {
		HIDE = WM_MY.max+1,
	}
	debug(commanddialog) unittest {
		wl("%s", CommandDialog.TIMER.HIDE);
	}
	private {
		TitleBar Titlebar;
		CommandEdit Input;
	}
	private {
		Application application;
		Font CtrlFont;
		ICONSIZE IconSize;
		Kareha ItemTree;
		COMMANDCOLOR[] CommandColors;
		int HideTime;
	}
	this(NeWindow Owner, Application application) {
		this.application = application;
		/+
		GUIINFO NeGuiInfo;
		NeGuiInfo.Style        = WS_DLGFRAME | WS_SIZEBOX;
		NeGuiInfo.ExStyle      = WS_EX_DLGMODALFRAME | WS_EX_TOOLWINDOW;
		NeGuiInfo.Owner = Owner;
		+/

		// application
		CtrlFont = application.AppData.exeCommandFont();
		IconSize = application.AppData.exeCommandIcon();
		ItemTree = application.itemBase;
		HideTime = application.AppData.exeCommandTimer;

		
		for(auto i=App.COMMANDCOLOR.min; i < App.COMMANDCOLOR.max+1; i++) {
			auto Colors=application.AppData.exeCommandColor(i);
			COMMANDCOLOR CommandColor;
			CommandColor.left  = Colors[0];
			CommandColor.right = Colors[1];
			CommandColors ~= CommandColor;
		}
		
		super(Owner, MAINLOOP_KEY);
	}
	
	protected override {
		/**
		History:
			1.00β18:
				[B] 自身は非アクティブだけどリストダイアログがアクティブな場合に誤作動。
		*/
		void OnActive(WINDOW_ACTIVE Active, bool NotSmall, HWND NextWnd) {
			super.OnActive(Active, NotSmall, NextWnd);
			Titlebar.onActive(Active);

			if(Active == WINDOW_ACTIVE.INACTIVE) {
				if(Input.List != NextWnd) {
					Input.toHide;
					startTimer(TIMER.HIDE, HideTime);
				}
			} else {
				Input.upDate(Input.text);
				stopTimer(TIMER.HIDE);
			}
		}
		/**
		自分で作ってて初めてOnTimerを使って思った。
		なんでstartTimerのTIMER_IDってWM_APP以上を求めてるんだろ。
		*/
		void OnTimer(in TIMER_ID Id) {
			final switch(cast(TIMER)Id) {
				case TIMER.HIDE:
					OnClose();
					break;
			}
		}
		
		void OnCreate() {
			super.OnCreate();

			text ~ LanguageData.dialog(LD.DIALOG.COMMAND);

			frameSize = true;
			taskBar   = false;

			
			Titlebar = new TitleBar(this, CTRL.TITLE);
			Titlebar.Position = TitleBar.POSITION.LEFT;


			Input = new CommandEdit(this, CTRL.INPUT, loopOwnerID, ItemTree, IconSize, CommandColors);
			Input.font = CtrlFont;
			Input.text = Text.emptyText;
			
			adjustSize(120, GetDefaultControlHeight(CtrlFont));
		}

		bool OnClose() {
			setShow(SHOW.HIDE);
			return false;
		}
		void OnShowWindow(bool Show, SHOW_FLAG Flag) {
			if(Show) {
				Input.tuneList;
				
				foreGround;
				Input.setFocus;
			} else {
				Input.text = Text.emptyText;
				Input.toHide;
			}
		}
		
		void OnDestroy() {
			Titlebar.destroy;
			Input.destroy;
			delete CtrlFont;
			super.OnDestroy();
		}
		void OnExitSizeMove() {
			Input.tuneList;
			
			foreGround;
			Input.setFocus;
		}

		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			Titlebar.onSize();

			Input.move(Titlebar.getSize, 0, Width - Titlebar.getSize, Height);
			Input.tuneList;

			return false;
		}

		void OnDrawItem(ITEM_ID Id, DRAWITEM* DrawItem) {
			switch(DrawItem.type) {
				case CONTROL_TYPE.BUTTON: // タイトルボタン
					assert(DrawItem.id == CTRL.TITLE);
					Titlebar.draw(DrawItem);
					break;
				default:
					assert(false);
			}
		}
		
		HT OnNcHitTest(HT HitFlag, int x, int y) {
			with(HT) switch(HitFlag) {
				case TOP, BOTTOM:
					return CLIENT;
				case BOTTOMLEFT, TOPLEFT:
					return LEFT;
				case BOTTOMRIGHT, TOPRIGHT:
					return RIGHT;
				default:
					return HitFlag;
			}
		}

		bool OnOtherEvent(UINT Message, WPARAM wParam, LPARAM lParam) {
			if(Message == WM_MY.ITEM) {
				if(auto pCommand = cast(COMMANDVALUE*)lParam) {
					final switch(pCommand.type) {
						case COMMANDVALUE.TYPE.ITEM:
							application.executeItem(pCommand.CItem.item);
							break;
						case COMMANDVALUE.TYPE.TEXT:
							assert(false);
					}

					//スマートにしないと
					this.setShow(SHOW.HIDE);
					
					return true;
				}
			}
			
			return super.OnOtherEvent(Message, wParam, lParam);
		}
	}
}


