﻿/**
ぼったん
*/
module nemuxi.gui.gui;

debug import std.stdio: wl = writefln, pl = printf;

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.negui;
import nemuxi.file.file;
import nemuxi.file.shortcut;
import nemuxi.negui.window.window;


///
class NemuxiGuiException: NeGuiException {
	mixin MixInNeGuiException;
}

/**
Params:
	Files = D&Dされたファイル。

	ShortCut = Files[n]がショートカットの場合に展開を行うか。

Return:
	結合された文字列。

History:
	1.00β18:
		新規追加。
*/
Text DropFileJoin(in Text[] Files, bool ShortCut, Window Parent) {
	auto JoinFiles=new Text[Files.length];
	
	for(auto j=0; j < Files.length; j++) {
		if(ShortCut && !PATH.cmp(PATH.getExtension(Files[j]), Text("lnk"))) {
			scope link=new Shortcut(Parent);
			link.fileLoad(Files[j], STGM.READ);
			if(Files.length > 1) {
				JoinFiles[j] = link.address.quot('"');
			} else {
				JoinFiles[0] = link.address;
			}
		} else {
			if(Files.length > 1) {
				JoinFiles[j] = Files[j].quot('"');
			} else {
				JoinFiles[0] = Files[j];
			}
		}
	}

	return JoinFiles.join(Text(' '));
}








