/**
あ
*/
module nemuxi.gui.control.titlebar;

debug import std.stdio: wl = writefln, pl = printf;
debug(titlebar) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.negui.window.newindow;
import nemuxi.negui.subclass;
import nemuxi.negui.draw.brush;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.canvas;
public import nemuxi.negui.control.button.button;
public import nemuxi.gui.gui;

/**
メインウィンドウとコマンドウィンドウで使用するクラス。

とりあえず汎用性0。

<pre>
TitleBar.POSITION.TOP
+--------------+
|##############|
|              |
|              |
+--------------+

TitleBar.POSITION.LEFT
+--------------+
|#             |
|#             |
|#             |
+--------------+
</pre>
*/
class TitleBar: Push, ISubClass {
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.ProcTop!(TitleBar));
		switch(Message) {
			case WM_LBUTTONDOWN:
				mixin(EVENTLOOP.WM_LBUTTONDOWN());
			case WM_DESTROY:
				mixin(EVENTLOOP.WM_DESTROY());
			default:
				mixin(EVENTLOOP.WM_LAST!(TitleBar));
		}
	}
	mixin(TSubClass);

	this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id);
		super.ownerDraw = true;
		SubClassOnNeGuiConstructor();
	}
	
	private void Draw(bool ActiveFlag, Canvas canvas, ref const(RECT) Rect) {
		version(none) {
			Color StartColor = ActiveFlag ? SYSTEMCOLOR.ActiveCaption(): SYSTEMCOLOR.InActiveCaption();
			Color EndColor   = ActiveFlag ? SYSTEMCOLOR.ActiveCaptionGradation(): SYSTEMCOLOR.InActiveCaptionGradation();
		}
		scope brush=new Brush(ActiveFlag ? SYSTEMCOLOR.ActiveCaption(): SYSTEMCOLOR.InActiveCaption());
		canvas.fillRect(Rect, brush);
	}
	
	/***/
	void draw(DRAWITEM* DrawItem) {
		Draw(parent()() == GetActiveWindow(), DrawItem.canvas, DrawItem.rect);
	}
	void onActive(WA Active) {
		RECT Rect;
		auto Size=clientSize();
		Rect.right = Size.cx;
		Rect.bottom= Size.cy;
		scope canvas=canvas();
		Draw(Active != WA.INACTIVE, canvas, Rect);
	}
	void onSize() {
		auto OwnerWnd = cast(NeWindow)parent();
		
		auto PaddingWidth=this.getSize();

		try {
			auto Size = OwnerWnd.clientSize();
			if(this.isHorizon()) {
				super.size(PaddingWidth, Size.cy);
			} else {
				super.size(Size.cx, PaddingWidth);
			}
		} catch(Exception e) {
			throw new NemuxiGuiException(Text("sizeTune:OwnerWnd.clientSize"));
		}
	}
	/***/
	static enum POSITION {
		TOP,
		LEFT,
	}
	POSITION Position;
	
	/**
	タイトルバーは横位置か？
	*/
	bool isHorizon() {
		return Position == POSITION.LEFT;
	}
	
	/***/
	int getSize() {
		int TitleFlag=void;
		
		if(this.isHorizon()) {
			TitleFlag = SM_CXVSCROLL;
		} else {
			TitleFlag = SM_CYVSCROLL;
		}

		return cast(int)(GetSystemMetrics(TitleFlag) >> 1);
	}

	protected override {
		bool OnMouseLeftDown(MOUSE_KEY Keys, int x, int y) {
			ReleaseCapture();
			super.parent.send(WM_NCLBUTTONDOWN, HT.CAPTION, MAKELONG(cast(ubyte)x, cast(ubyte)y));
			return true;
		}
		void OnDestroy() {
			SubClassOnNeGuiDestructor;
			super.OnDestroy();
		}
	}

}

