﻿/**

*/
module nemuxi.gui.control.listview;

debug import std.stdio: wl = writefln, pl = printf;

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
public import nemuxi.negui.draw.color;
import nemuxi.negui.window.newindow;
public import nemuxi.negui.control.control;
public import nemuxi.negui.draw.imagelist;
public import nemuxi.negui.control.listbox.listview;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.draw.cursor;
public import nemuxi.gui.gui;
public import nemuxi.file.items.items;
import nemuxi.gui.control.itemcontrol;
import nemuxi.negui.subclass;

/**
サクラエディタの色設定UIを参考に。

機能制限しまくり。
*/
final class ColorList: ListView {
	private {
		COLOR[][] ColorTable;
		ColorDialog dialog;
	}

	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner = Owner;
		NeGuiInfo.Id    = Id;
		NeGuiInfo.Style = LVS_NOSORTHEADER;
		
		super(&NeGuiInfo);
		
		type = TYPE.REPORT;
		
		dialog = new ColorDialog();
		dialog.initialize();
		dialog.flags = ColorDialog.FLAGS.FULLOPEN | ColorDialog.FLAGS.RGBINIT;
		dialog.ownerWindow = cast(NeWindow)GetParentWindow(Owner);
	}

	private void ReSizeColorTable(in size_t Height, in size_t Width) {
		if(ColorTable.length < Height) {
			ColorTable.length = Height;
		}
		
		if(ColorTable.length) {
			bool Change=false;
			foreach(ref color; ColorTable) {
				if(Change || color.length < Width) {
					Change = true;
					color.length = Width;
				}
			}
		}
	}
	
	
	bool color(in size_t Index, in size_t SubIndex, in COLOR Color) {
		LISTITEM ListItem;
		
		with(ListItem) {
			mask     = MASK.TEXT;
			index    = Index;
			subIndex = SubIndex;
			text     = Color.toHexColor(true);
		}
		
		auto flag=super.set(&ListItem);

		if(flag && ListItem.subIndex > 0) {
			ReSizeColorTable(Index+1, SubIndex);
			ColorTable[ListItem.index][ListItem.subIndex-1] = Color;
		}

		return flag;
	}
	
	COLOR color(in size_t Index, in size_t SubIndex) {
		return ColorTable[Index][SubIndex-1];
	}

	bool showDialog(in size_t Index, in size_t SubIndex) {
		dialog.color = color(Index, SubIndex);
		if(dialog.select) {
			color(Index, SubIndex, dialog.color);
			return true;
		} else {
			return false;
		}
	}

	void columns(Text[] texts) {
		LISTCOLUMN clm;
		with(clm) {
			mask = MASK.TEXT | MASK.POSITION | MASK.WIDTH;
			position = POSITION.LEFT;
			px = 80;
		}
		foreach(i, text; texts) {
			clm.text = text;
			if(i == 1) {
				clm.position = LISTCOLUMN.POSITION.CENTER;
			}
			insertColumn(i, &clm);
		}
	}
	void lines(Text[] texts) {
		LISTITEM ListItem;
		with(ListItem) {
			mask = MASK.TEXT;
			subIndex=0;
		}
		foreach(i, text; texts) {
			ListItem.text  = text;
			ListItem.index = i;
			insertItem(&ListItem);
		}
	}

	int onNotify(NOTIFY* Notify) {
		enforce(Notify.sender == this, new NemuxiGuiException(Text("？")));

		switch(Notify.code) {
			case ListView.COMMONEVENT.DBLCLK:
				LVHITTESTINFO HitTest;
				//Cursor.getPos(HitTest.pt);
			HitTest.pt=Cursor.getPos();
				pointToClient(HitTest.pt);
				HitTest.flags=LVHT_ONITEM;
				send(LVM_SUBITEMHITTEST , NONE, cast(LPARAM)&HitTest);
				if(HitTest.iItem >= 0 && HitTest.iSubItem && showDialog(HitTest.iItem, HitTest.iSubItem)) {
					return 1;
				} else {
					return 0;
				}
			case ListView.COMMONEVENT.CUSTOMDRAW:
				CUSTOMDRAW* CustomDraw = cast(CUSTOMDRAW*)Notify.ptr;
				switch(CustomDraw.stage) {
					case CustomDraw.STAGE.GLOBAL_PRE_PAINT:
						return CustomDraw.RETURN.NOTIFYITEMDRAW;
					case CustomDraw.STAGE.ITEM_PRE_PAINT:
						return CustomDraw.RETURN.SUBITEM;
					case CustomDraw.STAGE.ITEM_PRE_PAINT | CustomDraw.STAGE.ITEM_SUBITEM:
						auto ListDraw=cast(LISTVIEWDRAW*)Notify.ptr;

						if(count && ListDraw.subIndex) {
							auto color=color(CustomDraw.item, ListDraw.subIndex);
							ListDraw.textColor = color.negative();
							ListDraw.backColor = color;
						}
						return 0;
					default:
						return 0;
				}
			default:
				return 0;
		}
	}
}

/**
History:
	1.00β18:
		[B] iiPairs(ItemIconPairs)実行時にひたすらカラムが追加されていく。

	1.00β16:
		[B] コントロール破棄時にイメージリスト破棄処理追加。
*/
class ItemListView: ListView, IItemIconPairList, ISubClass {
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.ProcTop!(ItemListView));
		switch(Message) {
			case WM_SIZE:    mixin(EVENTLOOP.WM_SIZE());
			case WM_DESTROY: mixin(EVENTLOOP.WM_DESTROY());
			default:         mixin(EVENTLOOP.WM_LAST!(ItemListView));
		}
	}
	mixin(TSubClass);
	protected override {
		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			LISTCOLUMN ListClumn;
			ListClumn.mask = LISTCOLUMN.MASK.WIDTH;
			ListClumn.px   = Width;
			set(0, &ListClumn);

			return true;
		}

		/**
		History:
			1.00β16:
				[B] イメージリスト破棄処理追加。
		*/
		void OnDestroy() {
			if(auto image=imageListNormal) {
				image.kill;
			}
			
			SubClassOnNeGuiDestructor;
			super.OnDestroy();
		}
	}
	
	override this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id);

		noHeader = true;
		type     = TYPE.REPORT;
		single   = true;
		shareImageLists = true;

		listStyle(0, listStyle | LVS_EX_FULLROWSELECT);
		
			LISTCOLUMN ListClumn;
			ListClumn.mask = LISTCOLUMN.MASK.TEXT | LISTCOLUMN.MASK.IMAGE | LISTCOLUMN.MASK.WIDTH;
			ListClumn.px = 100;
			insertColumn(0, &ListClumn);

		
		SubClassOnNeGuiConstructor();
	}

	mixin MixInItemIconPairList;

	ItemIconPairs iiPairs() {
		return Pairs;
	}

	void iiPairs(ItemIconPairs Pairs) {
		ImageList OldImage;
		clear;
		this.Pairs=Pairs;
		if(this.Pairs) {
			auto IconPx=Pairs.iconPx;
			auto Image = new ImageList(IconPx, IconPx, ImageList.COLOR_TYPE.COLOR32 | ImageList.COLOR_TYPE.MASK, Pairs.length, 0, false);

			LISTITEM ListItem;
			ListItem.mask = LISTITEM.MASK.TEXT | LISTITEM.MASK.IMAGE | LISTITEM.MASK.DATA;
			foreach(i; 0 .. Pairs.length) {
				Image.add(Pairs[i].right);

				ListItem.text       = Pairs[i].left.toTextLine;
				ListItem.index = i;
				ListItem.imageIndex = i;
				ListItem.data = cast(void*)i;
				
				insertItem(&ListItem);
			}
			
			ListItem.index = 0;
			ListItem.mask = LISTITEM.MASK.STATE;
			ListItem.state= LISTITEM.STATE.SELECTED | LISTITEM.STATE.FOCUSED;
			ListItem.stateMask= LISTITEM.STATE.SELECTED | LISTITEM.STATE.FOCUSED;
			set(&ListItem);
			
			//select = 0;
			enable = true;

			OldImage = imageListSmall(Image);
		} else {
			enable = false;
			
			OldImage = imageListSmall();
		}

		if(OldImage) {
			OldImage.kill;
		}
	}
	
	Text selectID() {
		return selectValue.left.itemID;
	}
	
	void selectID(in Text ItemID) {
		selectValue(&Pairs[ItemID]);
	}

	ITEMICONPAIR* selectValue() {
		LISTITEM ListItem;
		ListItem.index     = next(NEXT.ALL | NEXT.SELECTED, -1);
		ListItem.mask      = LISTITEM.MASK.STATE;
		ListItem.state     = LISTITEM.STATE.SELECTED;
		ListItem.stateMask = LISTITEM.STATE.SELECTED;
		if(get(&ListItem)) {
			return &Pairs[cast(size_t)ListItem.data];
		} else {
			return null;
		}
	}
	void selectValue(ITEMICONPAIR* Pair) {
		LISTITEM ListItem;
		ListItem.mask      = LISTITEM.MASK.STATE;
		ListItem.stateMask = LISTITEM.STATE.SELECTED;
		
		if(auto pPair=(Pair.left.itemID in Pairs)) {
			ListItem.index     = Pairs.keyToIndex(pPair.left.itemID);
			ListItem.state     = LISTITEM.STATE.SELECTED;
		} else {
			ListItem.index     = next(NEXT.ALL | NEXT.SELECTED, -1);
		}
		set(&ListItem);
	}
	
}

