﻿/**
ぼったん
*/
module nemuxi.gui.control.button;

debug import std.stdio: wl = writefln, pl = printf;

import win32.windows;

import nemuxi.base;
import nemuxi.negui.subclass;
public import nemuxi.negui.control.button.button;
import nemuxi.negui.draw.draw;
public import nemuxi.negui.draw.icon;
public import nemuxi.image.icon;
public import nemuxi.negui.draw.bitmap;
import nemuxi.negui.draw.unit;

class ImageButton: Push, ISubClass {
	private Draw ImageObject;
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.ProcTop!(ImageButton));
		switch(Message) {
			case WM_DESTROY:
				mixin(EVENTLOOP.WM_DESTROY);
			default:
				mixin(EVENTLOOP.WM_LAST!(ImageButton));
		}
	}
	mixin(TSubClass);

	private this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id);
		/+
		SubclassObject = new SubClass(this, &SubClass_Proc);
		SubclassObject.start();
		+/
		SubClassOnNeGuiConstructor;
	}
	this(NeGui Owner, ITEM_ID Id, Icon icon) {
		this(Owner, Id);

		imageType = IMAGE_TYPE.ICON;
		ImageObject = icon;
		image = icon;

	}
	this(NeGui Owner, ITEM_ID Id, Bitmap bmp) {
		this(Owner, Id);
		
		imageType = IMAGE_TYPE.BITMAP;
		ImageObject = bmp;
		image = bmp;
	}

	protected override {
		void OnDestroy() {
			delete ImageObject;
			
			SubClassOnNeGuiDestructor;
			super.OnDestroy();
		}
	}
}

final class SystemIconButton: ImageButton {
	private {
		ICONSIZE IconSize;
	}
	this(NeGui Owner, ITEM_ID Id, SYSICON SysIcon, ICONSIZE IconSize) {
		this.IconSize = IconSize;
		super(Owner, Id, GetSystemIcon(SysIcon, IconSize));
	}

	mixin(StructGet!(ICONSIZE)("iconSize", q{IconSize}));

	const ref SIZE getSize() {
		return GetIconControlSize(IconSize);
	}
	
	void toDefaultSize() {
		size(getSize());
	}
}


