﻿/**
ショートカット用。

History:
	1.00β13:
	moduleをlink -> shortcutに変更。
*/
module nemuxi.file.shortcut;
debug import std.stdio: wl = writefln, pl = printf;
debug(shortcut) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.file.file;
import nemuxi.file.find;
import nemuxi.system.raii;
import nemuxi.com.ishelllink;
import nemuxi.com.ipersistfile;
public import nemuxi.com.ipersistfile: STGM;
import nemuxi.negui.window.window;
import nemuxi.negui.keyboard.keyboard;
import nemuxi.negui.system.type;

//mixin(ThrowableClasses("Shortcut", "Com"));
///
class ShortcutException: ComException {
	mixin MixInNemuxiException;
}


/**
History:
	1.00β13:
		新規作成。
*/
class Shortcut: Com!(IShellLink), IComPersistFile {
	size_t FilePathLength = PATH.MAX_PATH;
	size_t OptionLength   = INFOTIPSIZE;
	size_t CommnetLength  = INFOTIPSIZE;
	
	protected {
		Com!(IPersistFile) PersistFile;
		Window Owner;
	}
	protected override void Kill() {
		delete PersistFile;

		super.Kill();
	}
	this(Window Owner) {
		this.Owner = Owner;
		super(CLSID_ShellLink, IID_IShellLink, null, COM_CONTEXT.INPROC_SERVER, true);
		PersistFile = query!(IPersistFile)(IID_IPersistFile);
	}

	// *.lnk, 実ファイル処理 -----------------
	override {
		bool fileLoad(in Text FilePath, STGM Stgm) {
			if(SUCCEEDED(PersistFile.Load(FilePath.ptr, Stgm))) {
				return Known.Resolve(Owner ? Owner(): GetDesktopWindow(), SLR.ANY_MATCH | SLR.UPDATE) == NOERROR;
			}
			
			return false;
		}
		bool fileSave(in Text FilePath, bool Remember) {
			return PersistFile.Save(FilePath.length ? FilePath.ptr: null, Remember) == S_OK;
		}
		
		//--------------------------------
		bool isDirty() {
			return cast(bool)PersistFile.IsDirty();
		}
	}
	// ---------------------------------------

	/// こいつにポインタを指定してやればなんか入るかも。
	FILEITEM* FileItem;

	Text address() {
		auto text=new wchar[FilePathLength];
		
		HRESULT Result;
		
		Result = Known.GetPath(text.ptr, text.length, FileItem ? FileItem.ptr: null, SLGP.RAWPATH);
		if(Result != NOERROR) {
			// エラー処理
		}
		assert(Result == NOERROR, "一時的番兵");

		return Text(text.ptr);
	}
	bool address(in Text text)
	in {
		assert(text.length);
	}
	body {
		return Known.SetPath(text.ptr) == NOERROR;
	}

	Text workFolder() {
		auto text=new wchar[FilePathLength];

		enforce(
			Known.GetWorkingDirectory(text.ptr, text.length) == S_OK,
			new ShortcutException(Err.toString)
		);

		return Text(text.ptr);
	}
	bool workFolder(in Text text) {
		return Known.SetWorkingDirectory(text.ptr) == NOERROR;
	}

	Text option() {
		auto text=new wchar[OptionLength];

		enforce(
			Known.GetArguments(text.ptr, text.length) == S_OK,
			new ShortcutException(Err.toString)
		);

		return Text(text.ptr);
	}
	bool option(in Text text) {
		return Known.SetArguments(text.ptr) == S_OK;
	}

	Text getIcon(out int IconIndex) {
		auto text=new wchar[FilePathLength];
		
		enforce(
			Known.GetIconLocation(text.ptr, text.length, &IconIndex) == NOERROR,
			new ShortcutException(Err.toString)
		);

		return Text(text.ptr);
	}

	bool setIcon(in Text text, int IconIndex) {
		return Known.SetIconLocation(text.ptr, IconIndex) == NOERROR;
	}
	
	Text comment() {
		auto text=new wchar[CommnetLength];
		
		enforce(Known.GetDescription(text.ptr, text.length) == NOERROR, "aaa");
		
		return Text(text.ptr);
	}
	bool comment(Text text) {
		return Known.SetDescription(text.ptr) == NOERROR;
	}

	HOTKEYVALUE hotKey() {

		WORD KeyInfo;
		enforce(
			Known.GetHotkey(&KeyInfo) == NOERROR,
			new ShortcutException(Err.toString)
		);

		HOTKEYVALUE HotKeyValue;
		
		HotKeyValue.Key = cast(KEY)LOBYTE(KeyInfo);
		HotKeyValue.Mod = cast(HOTKEY)HIBYTE(KeyInfo);

		return HotKeyValue;
	}

	bool hotKey(HOTKEYVALUE HotKeyValue) {
		return Known.SetHotkey(MAKEWORD(HotKeyValue.Key, HotKeyValue.Mod)) == NOERROR;
	}

	SHOW show() {
		int Show;

		enforce(
			Known.GetShowCmd(&Show) == NOERROR,
			new ShortcutException(Err.toString)
		);

		return cast(SHOW)Show;
	}
	bool show(SHOW Show) {
		return Known.SetShowCmd(Show) == NOERROR;
	}
}







